/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.statusbar;

import java.text.NumberFormat;
import javax.swing.JLabel;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.gui.MatrixGUIObject;

class UpdateThread
extends Thread {
    private MatrixGUIObject matrixGUIObject = null;
    private JLabel jLabel = null;
    private static final NumberFormat nf = NumberFormat.getNumberInstance();

    static {
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
    }

    public UpdateThread(MatrixGUIObject matrixGUIObject, JLabel jLabel) {
        this.matrixGUIObject = matrixGUIObject;
        this.jLabel = jLabel;
        this.setPriority(1);
    }

    public void run() {
        this.jLabel.setText("calculating statistics...");
        long colMin = this.matrixGUIObject.getColumnSelectionModel().getMinSelectionIndex();
        long colMax = this.matrixGUIObject.getColumnSelectionModel().getMaxSelectionIndex();
        long rowMin = this.matrixGUIObject.getRowSelectionModel().getMinSelectionIndex();
        long rowMax = this.matrixGUIObject.getRowSelectionModel().getMaxSelectionIndex();
        Matrix m = null;
        m = colMin < 0L || colMax < 0L || rowMin < 0L || rowMax < 0L ? this.matrixGUIObject.getMatrix() : this.matrixGUIObject.getMatrix().subMatrix(Calculation.Ret.LINK, rowMin, colMin, rowMax, colMax);
        long count = m.getValueCount();
        double min = m.getMinValue();
        double max = m.getMaxValue();
        double mean = m.getMeanValue();
        double std = m.getStdValue();
        double sum = m.getValueSum();
        StringBuffer s = new StringBuffer();
        s.append(String.valueOf(count) + " cells selected:");
        s.append(" min=" + nf.format(min));
        s.append(" max=" + nf.format(max));
        s.append(" mean=" + nf.format(mean));
        s.append(" std=" + nf.format(std));
        s.append(" sum=" + nf.format(sum));
        this.jLabel.setText(s.toString());
    }
}

