/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.util;

import java.awt.Color;
import org.ujmp.core.Matrix;
import org.ujmp.gui.colormap.ColorMap;

public abstract class ColorUtil {
    public static final Color[] TRACECOLORS = new Color[]{Color.blue, Color.green, Color.red, Color.black, Color.yellow, Color.cyan};

    public static final Color contrastBW(Color c) {
        if ((double)(c.getRed() + c.getGreen() + c.getBlue()) > 200.0) {
            return Color.black;
        }
        return Color.white;
    }

    public static final Color fromRGB(int v) {
        return new Color(v);
    }

    public static final Color fromDouble(double v) {
        if (v == Double.MIN_VALUE || Double.isNaN(v)) {
            return Color.MAGENTA;
        }
        if (Double.isInfinite(v)) {
            return Color.CYAN;
        }
        if (v > 1.0) {
            return ColorMap.colorGreenToYellow[(int)(255.0 * Math.tanh((v - 1.0) / 10.0))];
        }
        if (v > 0.0) {
            return ColorMap.colorBlackToGreen[(int)(255.0 * v)];
        }
        if (v > -1.0) {
            return ColorMap.colorRedToBlack[(int)(255.0 * (v + 1.0))];
        }
        return ColorMap.colorRedToMagenta[(int)(255.0 * Math.tanh((-v - 1.0) / 10.0))];
    }

    private static Color fromString(String s) {
        if (s == null) {
            return Color.black;
        }
        int hc = Math.abs(ColorUtil.hash(s.hashCode()));
        int r = 192 + hc % 256 / 4;
        int g = 192 + (hc /= 256) % 256 / 4;
        int b = 192 + (hc /= 256) % 256 / 4;
        return new Color(r > 255 ? 255 : r, g > 255 ? 255 : g, b > 255 ? 255 : b);
    }

    public static Color fromObject(Object v) {
        if (v == null) {
            return Color.black;
        }
        if (v instanceof Double) {
            return ColorUtil.fromDouble((Double)v);
        }
        if (v instanceof Integer) {
            return ColorUtil.fromRGB((Integer)v);
        }
        if (v instanceof Matrix && ((Matrix)v).isScalar()) {
            return ColorUtil.fromObject(((Matrix)v).getAsObject(0L, 0L));
        }
        try {
            double d = Double.parseDouble(v.toString());
            return ColorUtil.fromDouble(d);
        }
        catch (Exception exception) {
            return ColorUtil.fromString(v.toString());
        }
    }

    private static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }
}

