/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.util;

import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import org.ujmp.gui.interfaces.CanBeRepainted;
import org.ujmp.gui.util.Executor;

public class GraphicsExecutor {
    private static final int count = Runtime.getRuntime().availableProcessors();
    private static final List<Executor> executors = new LinkedList<Executor>();

    public static synchronized void shutDown() {
        for (Executor ex : executors) {
            try {
                ex.shutdownNow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        executors.clear();
    }

    public static final synchronized void scheduleUpdate(CanBeRepainted component) {
        while (executors.size() < Runtime.getRuntime().availableProcessors()) {
            Executor executor = new Executor();
            executors.add(executor);
        }
        Component c = (Component)((Object)component);
        while (c != null && !(c instanceof JFrame)) {
            c = c.getParent();
        }
        if (c != null && c.isVisible()) {
            Executor executor = GraphicsExecutor.getExecutor(component);
            executor.sheduleUpdate(component);
        }
    }

    private static Executor getExecutor(CanBeRepainted component) {
        return executors.get(Math.abs(component.hashCode()) % count);
    }

    public static final void setFinished(CanBeRepainted component) {
        executors.get(component.hashCode() % count).setFinished(component);
    }
}

