/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.ujmp.core.collections.SoftHashMap;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix2D;

public abstract class AbstractDenseJDBCMatrix2D
extends AbstractDenseObjectMatrix2D
implements Closeable {
    private static final long serialVersionUID = -9077208839474846706L;
    private final Map<Integer, Connection> connections = new HashMap<Integer, Connection>();
    private String url = null;
    private String username = "sa";
    private String password = "";
    private final Map<Integer, PreparedStatement> selectStatements = new HashMap<Integer, PreparedStatement>();
    private final Map<Integer, ResultSet> resultSets = new SoftHashMap<Integer, ResultSet>();
    private String sqlStatement = null;
    private long[] size = null;
    private final int resultSize = Integer.MAX_VALUE;
    private final int connectionCount = 1;
    private int statementId = 0;

    public AbstractDenseJDBCMatrix2D(String url, String sqlStatement, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.sqlStatement = sqlStatement;
    }

    public String getSQLStatement() {
        return this.sqlStatement;
    }

    public synchronized Object getObject(long row, long column) {
        return this.getObject((int)row, (int)column);
    }

    public synchronized Object getObject(int row, int column) {
        try {
            ResultSet rs = this.getResultSet(row);
            return rs.getObject(column + 1);
        }
        catch (SQLException e) {
            if ("S1009".equals(e.getSQLState())) {
                return null;
            }
            throw new MatrixException(e);
        }
    }

    public final String getSelectString() {
        return this.sqlStatement;
    }

    public synchronized void setObject(Object value, long row, long column) {
    }

    public synchronized void setObject(Object value, int row, int column) {
    }

    public synchronized long[] getSize() {
        try {
            if (this.size == null) {
                ResultSet rs = this.getResultSet(1L);
                ResultSetMetaData rsMetaData = rs.getMetaData();
                long columnCount = rsMetaData.getColumnCount();
                rs.last();
                long rowCount = rs.getRow();
                this.size = new long[]{rowCount, columnCount};
            }
            return this.size;
        }
        catch (SQLException e) {
            throw new MatrixException(e);
        }
    }

    public synchronized void close() throws IOException {
        try {
            for (Connection connection : this.connections.values()) {
                if (connection == null) continue;
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new IOException(e.toString());
        }
    }

    public synchronized ResultSet getResultSet(long row) throws SQLException {
        int pos = (int)row / Integer.MAX_VALUE;
        int offset = pos * Integer.MAX_VALUE;
        int remain = (int)row - offset;
        ResultSet resultSet = this.resultSets.get(pos);
        if (resultSet == null) {
            PreparedStatement ps = this.getSelectStatement();
            resultSet = ps.executeQuery();
            this.resultSets.put(pos, resultSet);
            if (this.getMatrixAnnotation() == null) {
                this.setMatrixAnnotation(String.valueOf(this.getUrl()) + " " + this.getSelectString());
                ResultSetMetaData rsm = resultSet.getMetaData();
                int c = 0;
                while (c < rsm.getColumnCount()) {
                    this.setColumnLabel(c, rsm.getColumnLabel(c + 1));
                    ++c;
                }
            }
        }
        resultSet.absolute(remain + 1);
        return resultSet;
    }

    public synchronized PreparedStatement getSelectStatement() throws SQLException {
        PreparedStatement selectStatement = this.selectStatements.get(this.statementId);
        if (selectStatement == null) {
            selectStatement = this.getConnection(this.statementId).prepareStatement(this.getSelectString(), 1005, 1007);
        }
        this.statementId = ++this.statementId > 1 ? 0 : this.statementId;
        return selectStatement;
    }

    public synchronized Connection getConnection(int id) throws SQLException {
        Connection connection = this.connections.get(id);
        if (connection == null) {
            connection = DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
            this.connections.put(id, connection);
        }
        id = ++id >= 1 ? 0 : id;
        return connection;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

