/*
 * Decompiled with CFR 0.152.
 */
package weka.utils;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.output.prediction.AbstractOutput;
import weka.classifiers.evaluation.output.prediction.Null;
import weka.classifiers.meta.IterativeHMMClassifier;
import weka.classifiers.meta.IterativeHMMPropositionalizer;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;

public abstract class AbstractIterativeEvaluation<T extends IterativeHMMClassifier> {
    private T m_classifier;
    private int m_folds = 10;
    private Instances trainingSet;
    private int m_iterationSteps = 1;
    private boolean saveFolds = false;
    private int upperBoundIterations = -1;
    public String classifierName;
    protected AbstractOutput output = new Null();

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'F', (String[])options);
        this.m_folds = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 10;
        tmpStr = Utils.getOption((char)'I', (String[])options);
        this.upperBoundIterations = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : -1;
        if (this.upperBoundIterations <= 0) {
            this.upperBoundIterations = -1;
        }
        this.saveFolds = Utils.getFlag((char)'M', (String[])options);
        tmpStr = Utils.getOption((char)'S', (String[])options);
        this.m_iterationSteps = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 1;
        tmpStr = Utils.getOption((char)'T', (String[])options);
        this.trainingSet = ConverterUtils.DataSource.read((String)tmpStr);
        this.trainingSet.setClassIndex(this.trainingSet.numAttributes() - 1);
        tmpStr = Utils.getOption((String)"output", (String[])options);
        if (tmpStr.length() > 0) {
            String[] tmpOptions = Utils.splitOptions((String)tmpStr);
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.output = (AbstractOutput)Utils.forName(AbstractOutput.class, (String)tmpStr, (String[])tmpOptions);
        } else {
            this.output = new Null();
        }
        this.classifierName = Utils.getOption((char)'W', (String[])options);
        if (this.classifierName.length() <= 0) {
            throw new Exception("no classifier given");
        }
        this.setClassifier((IterativeHMMClassifier)AbstractClassifier.forName((String)this.classifierName, null));
        this.setClassifier((IterativeHMMClassifier)AbstractClassifier.forName((String)this.classifierName, (String[])Utils.partitionOptions((String[])options)));
    }

    public void setClassifier(T newClassifier) {
        this.m_classifier = newClassifier;
    }

    public T getClassifier() {
        return this.m_classifier;
    }

    public EvaluationIterator iterator() {
        return new EvaluationIterator(this);
    }

    public int getFolds() {
        return this.m_folds;
    }

    public void setFolds(int folds) {
        this.m_folds = folds;
    }

    public Instances getTrainingSet() {
        return this.trainingSet;
    }

    public void setTrainingSet(Instances trainingSet) {
        this.trainingSet = trainingSet;
    }

    public void setIterationSteps(int value) {
        this.m_iterationSteps = value;
    }

    public int getIterationSteps() {
        return this.m_iterationSteps;
    }

    public boolean isSaveFolds() {
        return this.saveFolds;
    }

    public void setSaveFolds(boolean saveFolds) {
        this.saveFolds = saveFolds;
    }

    public int getUpperBoundIterations() {
        return this.upperBoundIterations;
    }

    public void setUpperBoundIterations(int upperBoundIterations) {
        this.upperBoundIterations = upperBoundIterations;
    }

    public void setOutput(AbstractOutput value) {
        this.output = value;
    }

    public AbstractOutput getOutput() {
        return this.output;
    }

    public static void evaluate(AbstractIterativeEvaluation itEval, String[] args) throws Exception {
        itEval.setOptions(args);
        EvaluationIterator iter = itEval.iterator();
        while (iter.hasNext()) {
            iter.next();
        }
        System.out.println("Time elapsed in milliseconds: " + iter.getTime());
        long hours = iter.getTime() / 3600000L;
        long remainder = iter.getTime() - hours * 3600000L;
        long minutes = remainder / 60000L;
        long seconds = (remainder -= minutes * 60000L) / 1000L;
        System.out.println("Time elapsed: " + hours + "h " + minutes + "min " + seconds + "sec");
        if (iter.getIteration() != 0) {
            int i;
            for (i = 0; i < iter.getPositiveScores().size(); ++i) {
                System.out.println(">>score for positiv instance " + i + "\t" + iter.getPositiveScores().elementAt(i));
            }
            System.out.println("\n\n");
            for (i = 0; i < iter.getNegativeScores().size(); ++i) {
                System.out.println(">>score for negative instance " + i + "\t" + iter.getNegativeScores().elementAt(i));
            }
        }
    }

    public static class EvaluationIterator<T extends IterativeHMMClassifier>
    implements Iterator<EvaluationStep> {
        protected AbstractIterativeEvaluation<T> itEval;
        protected boolean converged;
        protected int stepSizeIteration;
        protected int seed;
        protected int folds;
        protected boolean saveOn;
        protected int stopAfterIteration;
        protected Random rand;
        protected long time;
        protected T actualClassifier;
        protected Instances randData;
        protected Vector pos;
        protected Vector neg;
        protected int iteration;
        protected List<IterativeHMMPropositionalizer> classifiersForAllFolds;
        protected List<Boolean> convergedInAllFolds;
        protected AbstractOutput output;
        protected StringBuffer outputBuffer;
        protected boolean stopping;
        protected boolean stopped;

        public EvaluationIterator(AbstractIterativeEvaluation<T> itEval) {
            this.itEval = itEval;
            this.actualClassifier = itEval.getClassifier();
            this.stepSizeIteration = itEval.getIterationSteps();
            this.seed = this.actualClassifier.getSeed();
            this.folds = itEval.getFolds();
            this.saveOn = itEval.isSaveFolds();
            this.stopAfterIteration = itEval.getUpperBoundIterations();
            this.outputBuffer = new StringBuffer();
            this.output = itEval.getOutput();
            this.output.setBuffer(this.outputBuffer);
            this.output.setHeader(itEval.getTrainingSet());
            this.stopping = false;
            this.stopped = false;
            this.rand = new Random(this.seed);
            this.randData = new Instances(itEval.getTrainingSet());
            System.out.println("Training and Prediction for: " + this.randData.relationName());
            this.randData.randomize(this.rand);
            if (this.randData.classAttribute().isNominal()) {
                this.randData.stratify(this.folds);
            }
            this.actualClassifier.setIterationStepSize(this.stepSizeIteration);
            this.actualClassifier.setSeed(this.seed);
            this.pos = new Vector();
            this.neg = new Vector();
            this.converged = false;
            this.time = 0L;
            try {
                this.classifiersForAllFolds = new Vector<IterativeHMMPropositionalizer>();
                this.convergedInAllFolds = new Vector<Boolean>();
                for (int i = 0; i < this.folds; ++i) {
                    this.classifiersForAllFolds.add(i, (IterativeHMMPropositionalizer)AbstractClassifier.makeCopy(this.actualClassifier));
                    this.convergedInAllFolds.add(i, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean hasNext() {
            return !this.converged && !this.stopped;
        }

        @Override
        public EvaluationStep next() {
            if (this.converged) {
                throw new NoSuchElementException("Already converged!");
            }
            try {
                int i;
                long timeStart = System.currentTimeMillis();
                this.converged = true;
                Evaluation eval = new Evaluation(this.randData);
                this.iteration = -1;
                for (int n = 0; n < this.folds && !this.stopping; ++n) {
                    Instances train = this.randData.trainCV(this.folds, n);
                    Instances test = this.randData.testCV(this.folds, n);
                    IterativeHMMPropositionalizer trainNow = this.classifiersForAllFolds.get(n);
                    this.iteration = trainNow.getIterationCount();
                    trainNow.setActualFold(n + 1);
                    trainNow.setNumberOfFolds(this.folds);
                    System.out.println("Working on fold " + (n + 1) + " of " + this.folds + " in iteration " + (this.iteration + 1));
                    trainNow.buildClassifier(train);
                    if (trainNow.getReUse()) {
                        test = trainNow.getPropositionalTestSet(test);
                    }
                    eval.evaluateModel((Classifier)trainNow, test, new Object[]{this.output});
                    this.convergedInAllFolds.set(n, trainNow.hmmsConverged());
                    this.classifiersForAllFolds.set(n, trainNow);
                    System.out.println(trainNow);
                }
                if (this.stopping) {
                    this.stopped = true;
                    return null;
                }
                FastVector pred = eval.predictions();
                this.pos = new Vector();
                this.neg = new Vector();
                String clsInfo = Utils.toCommandLine(this.actualClassifier).replace(" ", "_");
                this.pos.add(clsInfo);
                this.neg.add(clsInfo);
                for (i = 0; i < pred.size(); ++i) {
                    NominalPrediction pred4Instance = (NominalPrediction)pred.get(i);
                    double prob = pred4Instance.distribution()[0];
                    if (pred4Instance.actual() == 0.0) {
                        this.pos.add(prob);
                        continue;
                    }
                    this.neg.add(prob);
                }
                if (this.iteration == 0) {
                    for (i = 0; i < this.pos.size(); ++i) {
                        System.out.println(">score for positiv instance " + i + "\t" + this.pos.elementAt(i));
                    }
                    System.out.println("\n\n");
                    for (i = 0; i < this.neg.size(); ++i) {
                        System.out.println(">score for negative instance " + i + "\t" + this.neg.elementAt(i));
                    }
                }
                System.out.println("Iterative Evaluation for Iteration: " + (this.iteration + 1));
                System.out.println(eval.toSummaryString());
                System.out.println(eval.toClassDetailsString() + "\n\n");
                for (i = 0; i < this.folds; ++i) {
                    this.converged = this.converged && this.convergedInAllFolds.get(i) != false;
                }
                if (this.stopAfterIteration != -1 && this.iteration >= this.stopAfterIteration - 1) {
                    this.converged = true;
                    System.out.println("Maximum number of " + this.stopAfterIteration + " iteration(s) reached.");
                }
                long timeEnd = System.currentTimeMillis();
                this.time += timeEnd - timeStart;
                return new EvaluationStep(eval, this.pos, this.neg, timeEnd - timeStart);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public void remove() {
        }

        public long getTime() {
            return this.time;
        }

        public Vector getPositiveScores() {
            return this.pos;
        }

        public Vector getNegativeScores() {
            return this.neg;
        }

        public int getIteration() {
            return this.iteration;
        }

        public void stop() {
            this.stopping = true;
        }

        public boolean isStopping() {
            return this.stopping;
        }

        public boolean isStopped() {
            return this.stopped;
        }
    }

    public static class EvaluationStep {
        protected Vector pos;
        protected Vector neg;
        protected Evaluation eval;
        protected long time;

        public EvaluationStep(Evaluation eval, Vector pos, Vector neg, long time) {
            this.eval = eval;
            this.pos = pos;
            this.neg = neg;
            this.time = time;
        }

        public Evaluation getEvaluation() {
            return this.eval;
        }

        public Vector getPositiveScores() {
            return this.pos;
        }

        public Vector getNegativeScores() {
            return this.neg;
        }

        public long getTime() {
            return this.time;
        }
    }
}

