/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.cds.CDSNameTreeEntry;
import de.intarsys.pdf.cds.CDSNameTreeNode;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSInfoDict;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.crypt.AccessPermissionsTools;
import de.intarsys.pdf.crypt.IAccessPermissions;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.IAdditionalActionSupport;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAction;
import de.intarsys.pdf.pd.PDActionGoTo;
import de.intarsys.pdf.pd.PDAdditionalActions;
import de.intarsys.pdf.pd.PDApplicationData;
import de.intarsys.pdf.pd.PDOutline;
import de.intarsys.pdf.pd.PDOutputIntent;
import de.intarsys.pdf.pd.PDPageNode;
import de.intarsys.pdf.pd.PDPageTree;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.pdf.st.EnumWriteMode;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDDocument
implements IAdditionalActionSupport,
IAttributeSupport,
ILocatorSupport {
    public static final Set CATALOG_ACTION_TRIGGERS;
    public static final COSName CN_Perms_DocMDP;
    public static final COSName CN_Perms_UR;
    public static final COSName DK_OpenAction;
    public static final COSName DK_Perms;
    public static final COSName DK_Legal;
    private IAccessPermissions accessPermissions;
    private final COSDocument cosDoc;

    static {
        CN_Perms_DocMDP = COSName.constant("DocMDP");
        CN_Perms_UR = COSName.constant("UR");
        DK_OpenAction = COSName.constant("OpenAction");
        DK_Perms = COSName.constant("Perms");
        DK_Legal = COSName.constant("Legal");
        CATALOG_ACTION_TRIGGERS = new HashSet(6);
        CATALOG_ACTION_TRIGGERS.add("DC");
        CATALOG_ACTION_TRIGGERS.add("WS");
        CATALOG_ACTION_TRIGGERS.add("DS");
        CATALOG_ACTION_TRIGGERS.add("WP");
        CATALOG_ACTION_TRIGGERS.add("DP");
    }

    public static PDDocument createFromCos(COSDocument doc) {
        PDDocument result = (PDDocument)doc.getAttribute(PDDocument.class);
        if (result == null) {
            result = new PDDocument(doc);
            result.initializeFromCos();
            result.checkConsistency();
            doc.setAttribute(PDDocument.class, result);
        }
        return result;
    }

    public static PDDocument createFromLocator(ILocator locator) throws IOException, COSLoadException {
        return PDDocument.createFromLocator(locator, null);
    }

    public static PDDocument createFromLocator(ILocator locator, Map options) throws IOException, COSLoadException {
        return PDDocument.createFromCos(COSDocument.createFromLocator(locator, options));
    }

    public static PDDocument createNew() {
        PDDocument result = new PDDocument();
        result.initializeFromScratch();
        result.setAttribute(PDDocument.class, result);
        return result;
    }

    protected PDDocument() {
        this(COSDocument.createNew());
    }

    protected PDDocument(COSDocument newDoc) {
        this.cosDoc = newDoc;
    }

    public void addAction(PDAction action) {
        this.addOpenAction(action);
    }

    public void addDestination(String name, COSObject destination) {
        COSCatalog catalog = this.getCatalog();
        COSDictionary destsDict = catalog.cosGetDests();
        if (destsDict == null) {
            destsDict = COSDictionary.create();
            catalog.cosSetDests(destsDict);
        }
        destsDict.put(COSName.createUTF8(name), destination);
    }

    public void addOpenAction(PDAction newAction) {
        if (newAction == null) {
            return;
        }
        if (this.getOpenAction() != null) {
            this.getOpenAction().addNext(newAction);
        } else {
            this.setOpenAction(newAction);
        }
    }

    public void addPageNode(PDPageNode newNode) {
        this.getPageTree().addNode(newNode);
    }

    public void addPageNodeAfter(PDPageNode newNode, PDPageNode destination) {
        if (destination == null) {
            this.getPageTree().addNode(newNode);
        } else {
            destination.getParent().addNodeAfter(newNode, destination);
        }
    }

    protected void checkConsistency() throws COSRuntimeException {
        if (this.getCatalog() == null) {
            throw new COSRuntimeException("Catalog missing");
        }
        if (this.getPageTree() == null) {
            throw new COSRuntimeException("Page tree missing");
        }
    }

    public void close() throws IOException {
        this.cosDoc.close();
    }

    protected void collectAnnotations(List result) {
        this.getPageTree().collectAnnotations(result);
    }

    public PDDocument copyDeep() {
        return PDDocument.createFromCos(this.cosGetDoc().copyDeep());
    }

    public COSDocument cosGetDoc() {
        return this.cosDoc;
    }

    public COSDictionary cosGetPermissionsDict() {
        COSCatalog catalog = this.getCatalog();
        if (catalog == null) {
            return null;
        }
        return catalog.cosGetField(DK_Perms).asDictionary();
    }

    public COSDictionary cosGetPieceInfoDict() {
        COSCatalog catalog = this.getCatalog();
        if (catalog == null) {
            return null;
        }
        return catalog.cosGetField(COSCatalog.DK_PieceInfo).asDictionary();
    }

    public COSDictionary cosGetURI() {
        COSCatalog catalog = this.getCatalog();
        if (catalog == null) {
            return null;
        }
        return catalog.cosGetField(COSCatalog.DK_URI).asDictionary();
    }

    public void cosSetPermissionsDict(COSDictionary permsDict) {
        COSCatalog catalog = this.getCatalog();
        if (catalog == null) {
            return;
        }
        permsDict.beIndirect();
        catalog.cosSetField(DK_Perms, permsDict);
    }

    public void cosSetPieceInfoDict(COSDictionary dict) {
        COSCatalog catalog = this.getCatalog();
        if (catalog == null) {
            return;
        }
        dict.beIndirect();
        catalog.cosSetField(COSCatalog.DK_PieceInfo, dict);
    }

    public PDAcroForm createAcroForm() {
        if (this.getAcroForm() != null) {
            throw new IllegalStateException("AcroForm already available");
        }
        PDAcroForm acroForm = (PDAcroForm)PDAcroForm.META.createNew();
        PDResources formResources = (PDResources)PDResources.META.createNew();
        acroForm.setDefaultResources(formResources);
        this.setAcroForm(acroForm);
        return acroForm;
    }

    public PDPageTree createPageTree() {
        PDPageTree result = (PDPageTree)PDPageTree.META.createNew();
        return result;
    }

    public IAccessPermissions getAccessPermissions() {
        if (this.accessPermissions == null) {
            this.accessPermissions = AccessPermissionsTools.createPermissions(this);
        }
        return this.accessPermissions;
    }

    public PDAcroForm getAcroForm() {
        COSCatalog catalog = this.getCatalog();
        if (catalog == null) {
            return null;
        }
        return (PDAcroForm)PDAcroForm.META.createFromCos(catalog.cosGetField(COSCatalog.DK_AcroForm));
    }

    @Override
    public PDAdditionalActions getAdditionalActions() {
        COSDictionary aa = null;
        COSCatalog catalog = this.getCatalog();
        if (catalog != null) {
            aa = catalog.cosGetField(DK_AA).asDictionary();
        }
        return (PDAdditionalActions)PDAdditionalActions.META.createFromCos(aa);
    }

    public List getAnnotations() {
        ArrayList result = new ArrayList();
        this.collectAnnotations(result);
        return result;
    }

    public PDApplicationData getApplicationData(String name) {
        COSDictionary pid = this.cosGetPieceInfoDict();
        if (pid == null) {
            return null;
        }
        COSName cosName = COSName.createUTF8(name);
        COSDictionary pi = pid.get(cosName).asDictionary();
        if (pi == null) {
            return null;
        }
        return (PDApplicationData)PDApplicationData.META.createFromCos(pi);
    }

    public Object getAttribute(Object key) {
        return this.cosDoc.getAttribute(key);
    }

    public String getAuthor() {
        return this.getDocumentInfoString(COSInfoDict.DK_Author);
    }

    public COSCatalog getCatalog() {
        return this.cosGetDoc().getCatalog();
    }

    public CDSDate getCreationDate() {
        if (this.getInfoDict() == null) {
            return null;
        }
        return this.getInfoDict().getCreationDate();
    }

    public String getCreationDateString() {
        return this.getDocumentInfoString(COSInfoDict.DK_CreationDate);
    }

    public String getCreator() {
        return this.getDocumentInfoString(COSInfoDict.DK_Creator);
    }

    public List<String> getDestinationNames() {
        COSDictionary destsDict;
        COSDictionary names;
        ArrayList<String> destinationNames = new ArrayList<String>();
        COSDictionary dests = this.getCatalog().cosGetDests();
        if (dests != null) {
            for (COSName key : dests.keySet()) {
                destinationNames.add(key.stringValue());
            }
        }
        if ((names = this.getCatalog().cosGetNames()) != null && (destsDict = names.get(COSCatalog.DK_Dests).asDictionary()) != null) {
            CDSNameTreeNode destsTree = CDSNameTreeNode.createFromCos(destsDict);
            Iterator i = destsTree.iterator();
            while (i.hasNext()) {
                CDSNameTreeEntry entry = (CDSNameTreeEntry)i.next();
                destinationNames.add(entry.getName().stringValue());
            }
        }
        return destinationNames;
    }

    protected String getDocumentInfoString(COSName name) {
        COSInfoDict infoDict = this.cosGetDoc().getInfoDict();
        if (infoDict == null) {
            return null;
        }
        COSObject obj = infoDict.cosGetField(name);
        return obj.isNull() ? null : obj.stringValue();
    }

    public COSInfoDict getInfoDict() {
        return this.cosGetDoc().getInfoDict();
    }

    public String getKeywords() {
        return this.getDocumentInfoString(COSInfoDict.DK_Keywords);
    }

    public ILocator getLocator() {
        return this.cosDoc.getLocator();
    }

    public String getMetadata() {
        COSCatalog catalog = this.getCatalog();
        if (catalog == null) {
            return null;
        }
        COSStream metadata = catalog.cosGetField(COSCatalog.DK_Metadata).asStream();
        if (metadata == null) {
            return null;
        }
        byte[] bytes = metadata.getEncodedBytes();
        return new String(bytes);
    }

    public CDSDate getModDate() {
        if (this.getInfoDict() == null) {
            return null;
        }
        return this.getInfoDict().getModDate();
    }

    public String getModDateString() {
        return this.getDocumentInfoString(COSInfoDict.DK_ModDate);
    }

    public String getName() {
        return this.cosDoc.getName();
    }

    public PDAction getOpenAction() {
        COSCatalog catalog = this.getCatalog();
        if (catalog == null) {
            return null;
        }
        COSObject openAction = catalog.cosGetField(DK_OpenAction);
        if (openAction.isNull()) {
            return null;
        }
        if (openAction instanceof COSDictionary) {
            return (PDAction)PDAction.META.createFromCos(openAction);
        }
        if (openAction instanceof COSArray) {
            return (PDAction)PDActionGoTo.META.createFromCos(openAction);
        }
        return null;
    }

    public PDOutline getOutline() {
        return (PDOutline)PDOutline.META.createFromCos(this.getCatalog().cosGetOutline());
    }

    public PDOutputIntent getOutputIntent(COSName oiName) {
        List outputIntents = this.getOutputIntents();
        if (outputIntents != null) {
            for (PDOutputIntent element : outputIntents) {
                COSObject keys = element.cosGetField(PDOutputIntent.DK_S);
                if (keys == null || !keys.equals(oiName)) continue;
                return element;
            }
        }
        return null;
    }

    public List getOutputIntents() {
        COSArray oi = null;
        COSCatalog catalog = this.getCatalog();
        if (catalog != null && (oi = catalog.cosGetField(COSCatalog.DK_OutputIntents).asArray()) != null) {
            ArrayList<COSBasedObject> result = new ArrayList<COSBasedObject>();
            Iterator i = oi.iterator();
            while (i.hasNext()) {
                COSBasedObject pdObject = PDOutputIntent.META.createFromCos((COSObject)i.next());
                if (pdObject == null) continue;
                result.add(pdObject);
            }
            return result;
        }
        return null;
    }

    public PDPageTree getPageTree() {
        return (PDPageTree)PDPageNode.META.createFromCos(this.getCatalog().cosGetField(COSCatalog.DK_Pages));
    }

    public PDSignature getPermissions(COSName key) {
        COSDictionary perms = this.cosGetPermissionsDict();
        if (perms == null) {
            return null;
        }
        COSDictionary sigDict = perms.get(key).asDictionary();
        if (sigDict == null) {
            return null;
        }
        return (PDSignature)PDSignature.META.createFromCos(sigDict);
    }

    public String getProducer() {
        return this.getDocumentInfoString(COSInfoDict.DK_Producer);
    }

    public String getSubject() {
        return this.getDocumentInfoString(COSInfoDict.DK_Subject);
    }

    @Override
    public Set getSupportedTriggerEvents() {
        return CATALOG_ACTION_TRIGGERS;
    }

    public String getTitle() {
        return this.getDocumentInfoString(COSInfoDict.DK_Title);
    }

    public String getTrapped() {
        if (this.getInfoDict() == null) {
            return null;
        }
        return this.getInfoDict().getTrapped();
    }

    public EnumWriteMode getWriteModeHint() {
        return this.cosDoc.getWriteModeHint();
    }

    protected void initializeFromCos() {
    }

    protected void initializeFromScratch() {
        PDPageTree pageTree = (PDPageTree)PDPageTree.META.createNew();
        this.cosDoc.getCatalog().cosSetField(COSCatalog.DK_Pages, pageTree.cosGetObject());
    }

    public boolean isAppendOnly() {
        if (this.getAcroForm() == null) {
            return false;
        }
        return this.getAcroForm().getSigFlags().isAppendOnly();
    }

    public boolean isDirty() {
        return this.cosDoc.isDirty();
    }

    public boolean isEncrypted() {
        return this.cosDoc.isEncrypted();
    }

    public boolean isNew() {
        return this.cosDoc.isNew();
    }

    public boolean isPreferIncrementalSave() {
        if (this.isEncrypted()) {
            return true;
        }
        if (this.isAppendOnly()) {
            return true;
        }
        return this.isSigned();
    }

    public boolean isReadOnly() {
        return this.cosDoc.isReadOnly();
    }

    public boolean isSigned() {
        if (this.getAcroForm() == null) {
            return false;
        }
        return this.getAcroForm().isSigned();
    }

    public COSObject lookupDestination(String name) {
        COSDictionary destsDict;
        COSDictionary names;
        COSCatalog catalog = this.getCatalog();
        COSObject destination = null;
        COSDictionary dests = catalog.cosGetDests();
        if (dests != null) {
            destination = dests.get(COSName.createUTF8(name));
        }
        if (destination == null && (names = catalog.cosGetNames()) != null && (destsDict = names.get(COSCatalog.DK_Dests).asDictionary()) != null) {
            CDSNameTreeNode destsTree = CDSNameTreeNode.createFromCos(destsDict);
            destination = destsTree.get(COSString.create(name));
        }
        if (destination == null || destination.isNull()) {
            return null;
        }
        return destination;
    }

    public void removeApplicationData(String name) {
        COSDictionary pid = this.cosGetPieceInfoDict();
        if (pid == null) {
            return;
        }
        COSName cosName = COSName.createUTF8(name);
        pid.remove(cosName);
    }

    public Object removeAttribute(Object key) {
        return this.cosDoc.removeAttribute(key);
    }

    public void restore(ILocator locator) throws IOException, COSLoadException {
        this.cosGetDoc().restore(locator);
    }

    public void save() throws IOException {
        this.save(this.getLocator(), null);
    }

    public void save(ILocator locator) throws IOException {
        this.save(locator, null);
    }

    public void save(ILocator locator, Map options) throws IOException {
        HashMap<String, EnumWriteMode> actualOptions = options;
        if (actualOptions == null) {
            actualOptions = new HashMap<String, EnumWriteMode>();
        }
        if (this.isPreferIncrementalSave()) {
            actualOptions.put("writeModeHint", EnumWriteMode.INCREMENTAL);
        } else {
            EnumWriteMode mode = (EnumWriteMode)((Object)actualOptions.get("writeModeHint"));
            if ((mode == null || mode.isUndefined()) && locator != null && locator != this.getLocator()) {
                actualOptions.put("writeModeHint", EnumWriteMode.FULL);
            }
        }
        this.cosDoc.save(locator, actualOptions);
    }

    public void setAcroForm(PDAcroForm form) {
        COSCatalog catalog = this.getCatalog();
        if (catalog == null) {
            return;
        }
        catalog.setFieldObject(COSCatalog.DK_AcroForm, form);
    }

    @Override
    public void setAdditionalActions(PDAdditionalActions actions) {
        COSCatalog catalog = this.getCatalog();
        if (catalog != null) {
            catalog.setFieldObject(DK_AA, actions);
        }
    }

    public void setApplicationData(String name, PDApplicationData data) {
        COSDictionary pid = this.cosGetPieceInfoDict();
        if (pid == null) {
            pid = COSDictionary.create();
            this.cosSetPieceInfoDict(pid);
        }
        COSName cosName = COSName.createUTF8(name);
        if (data == null) {
            pid.remove(cosName);
        } else {
            pid.put(cosName, data.cosGetDict());
        }
    }

    public Object setAttribute(Object key, Object o) {
        return this.cosDoc.setAttribute(key, o);
    }

    public void setAuthor(String value) {
        this.setDocumentInfo(COSInfoDict.DK_Author, value);
    }

    public void setCreationDateString(String value) {
        this.setDocumentInfo(COSInfoDict.DK_CreationDate, value);
    }

    public void setCreator(String value) {
        this.setDocumentInfo(COSInfoDict.DK_Creator, value);
    }

    public void setDocumentInfo(COSName name, String value) {
        COSInfoDict infoDict = this.cosGetDoc().getInfoDict();
        if (infoDict == null) {
            infoDict = (COSInfoDict)COSInfoDict.META.createNew();
            this.cosGetDoc().setInfoDict(infoDict);
        }
        infoDict.setFieldString(name, value);
    }

    public void setInfoDict(COSInfoDict infoDict) {
        this.cosGetDoc().setInfoDict(infoDict);
    }

    public void setKeywords(String value) {
        this.setDocumentInfo(COSInfoDict.DK_Keywords, value);
    }

    public void setModDateString(String value) {
        this.setDocumentInfo(COSInfoDict.DK_ModDate, value);
    }

    public void setName(String name) {
        this.cosDoc.setName(name);
    }

    public void setOpenAction(PDAction newAction) {
        COSCatalog catalog = this.getCatalog();
        if (catalog == null) {
            return;
        }
        catalog.setFieldObject(DK_OpenAction, newAction);
    }

    public void setOutline(PDOutline outline) {
        this.getCatalog().cosSetOutline(outline.cosGetDict());
    }

    public void setPageTree(PDPageTree newTree) {
        this.getCatalog().setFieldObject(COSCatalog.DK_Pages, newTree);
    }

    public void setPermissions(COSName name, PDSignature signature) {
        COSDictionary perms = this.cosGetPermissionsDict();
        if (perms == null) {
            perms = COSDictionary.create();
            this.cosSetPermissionsDict(perms);
        }
        COSDictionary sigDict = signature.cosGetDict();
        sigDict.beIndirect();
        perms.put(name, sigDict);
    }

    public void setProducer(String value) {
        this.setDocumentInfo(COSInfoDict.DK_Producer, value);
    }

    public void setSubject(String value) {
        this.setDocumentInfo(COSInfoDict.DK_Subject, value);
    }

    public void setTitle(String value) {
        this.setDocumentInfo(COSInfoDict.DK_Title, value);
    }

    public void setTrapped(String value) {
        if (this.getInfoDict() == null) {
            return;
        }
        this.getInfoDict().setTrapped(value);
    }

    public void setWriteModeHint(EnumWriteMode writeMode) {
        this.cosDoc.setWriteModeHint(writeMode);
    }
}

