/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ColorChooser;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageRoi;
import ij.gui.MessageDialog;
import ij.gui.Plot;
import ij.gui.PointRoi;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.RoiProperties;
import ij.gui.ShapeRoi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.gui.YesNoCancelDialog;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.RoiDecoder;
import ij.io.RoiEncoder;
import ij.io.SaveDialog;
import ij.macro.Interpreter;
import ij.macro.MacroRunner;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.Colors;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.Filler;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.StringSorter;
import ij.util.Tools;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class RoiManager
extends PlugInFrame
implements ActionListener,
ItemListener,
MouseListener,
MouseWheelListener {
    public static final String LOC_KEY = "manager.loc";
    private static final int BUTTONS = 11;
    private static final int DRAW = 0;
    private static final int FILL = 1;
    private static final int LABEL = 2;
    private static final int SHOW_ALL = 0;
    private static final int SHOW_NONE = 1;
    private static final int LABELS = 2;
    private static final int NO_LABELS = 3;
    private static final int MENU = 0;
    private static final int COMMAND = 1;
    private static int rows = 15;
    private static int lastNonShiftClick = -1;
    private static boolean allowMultipleSelections = true;
    private static String moreButtonLabel = "More \u00bb";
    private Panel panel;
    private static Frame instance;
    private static int colorIndex;
    private List list;
    private Hashtable rois = new Hashtable();
    private boolean canceled;
    private boolean macro;
    private boolean ignoreInterrupts;
    private PopupMenu pm;
    private Button moreButton;
    private Button colorButton;
    private Checkbox showAllCheckbox = new Checkbox("Show All", false);
    private Checkbox labelsCheckbox = new Checkbox("Edit Mode", false);
    private static boolean measureAll;
    private static boolean onePerSlice;
    private static boolean restoreCentered;
    private int prevID;
    private boolean noUpdateMode;
    private int defaultLineWidth = 1;
    private Color defaultColor;
    private boolean firstTime = true;
    private int[] selectedIndexes;

    public RoiManager() {
        super("ROI Manager");
        if (instance != null) {
            WindowManager.toFront(instance);
            return;
        }
        instance = this;
        this.list = new List(rows, allowMultipleSelections);
        this.showWindow();
    }

    public RoiManager(boolean hideWindow) {
        super("ROI Manager");
        this.list = new List(rows, allowMultipleSelections);
    }

    void showWindow() {
        ImageJ ij = IJ.getInstance();
        this.addKeyListener(ij);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        WindowManager.addWindow(this);
        this.setLayout(new BorderLayout());
        this.list.add("012345678901234");
        this.list.addItemListener(this);
        this.list.addKeyListener(ij);
        this.list.addMouseListener(this);
        this.list.addMouseWheelListener(this);
        if (IJ.isLinux()) {
            this.list.setBackground(Color.white);
        }
        this.add("Center", this.list);
        this.panel = new Panel();
        int nButtons = 11;
        this.panel.setLayout(new GridLayout(nButtons, 1, 5, 0));
        this.addButton("Add [t]");
        this.addButton("Update");
        this.addButton("Delete");
        this.addButton("Rename...");
        this.addButton("Measure");
        this.addButton("Deselect");
        this.addButton("Properties...");
        this.addButton("Flatten [F]");
        this.addButton(moreButtonLabel);
        this.showAllCheckbox.addItemListener(this);
        this.panel.add(this.showAllCheckbox);
        this.labelsCheckbox.addItemListener(this);
        this.panel.add(this.labelsCheckbox);
        this.add("East", this.panel);
        this.addPopupMenu();
        this.pack();
        Dimension size = this.getSize();
        if (size.width > 270) {
            this.setSize(size.width - 40, size.height);
        }
        this.list.remove(0);
        Point loc = Prefs.getLocation(LOC_KEY);
        if (loc != null) {
            this.setLocation(loc);
        } else {
            GUI.center(this);
        }
        this.show();
        if (IJ.isMacOSX() && IJ.isJava16()) {
            this.list.setMultipleMode(false);
            this.list.setMultipleMode(true);
        }
    }

    void addButton(String label) {
        Button b = new Button(label);
        b.addActionListener(this);
        b.addKeyListener(IJ.getInstance());
        b.addMouseListener(this);
        if (label.equals(moreButtonLabel)) {
            this.moreButton = b;
        }
        this.panel.add(b);
    }

    void addPopupMenu() {
        this.pm = new PopupMenu();
        this.addPopupItem("Open...");
        this.addPopupItem("Save...");
        this.addPopupItem("Fill");
        this.addPopupItem("Draw");
        this.addPopupItem("AND");
        this.addPopupItem("OR (Combine)");
        this.addPopupItem("XOR");
        this.addPopupItem("Split");
        this.addPopupItem("Add Particles");
        this.addPopupItem("Multi Measure");
        this.addPopupItem("Multi Plot");
        this.addPopupItem("Sort");
        this.addPopupItem("Specify...");
        this.addPopupItem("Remove Slice Info");
        this.addPopupItem("Help");
        this.addPopupItem("Options...");
        this.add(this.pm);
    }

    void addPopupItem(String s) {
        MenuItem mi = new MenuItem(s);
        mi.addActionListener(this);
        this.pm.add(mi);
    }

    public void actionPerformed(ActionEvent e) {
        String label = e.getActionCommand();
        if (label == null) {
            return;
        }
        String command = label;
        if (command.equals("Add [t]")) {
            this.runCommand("add");
        } else if (command.equals("Update")) {
            this.update(true);
        } else if (command.equals("Delete")) {
            this.delete(false);
        } else if (command.equals("Rename...")) {
            this.rename(null);
        } else if (command.equals("Properties...")) {
            this.setProperties(null, -1, null);
        } else if (command.equals("Flatten [F]")) {
            this.flatten();
        } else if (command.equals("Measure")) {
            this.measure(0);
        } else if (command.equals("Open...")) {
            this.open(null);
        } else if (command.equals("Save...")) {
            this.save();
        } else if (command.equals("Fill")) {
            this.drawOrFill(1);
        } else if (command.equals("Draw")) {
            this.drawOrFill(0);
        } else if (command.equals("Deselect")) {
            this.select(-1);
        } else if (command.equals(moreButtonLabel)) {
            Point ploc = this.panel.getLocation();
            Point bloc = this.moreButton.getLocation();
            this.pm.show(this, ploc.x, bloc.y);
        } else if (command.equals("OR (Combine)")) {
            this.combine();
        } else if (command.equals("Split")) {
            this.split();
        } else if (command.equals("AND")) {
            this.and();
        } else if (command.equals("XOR")) {
            this.xor();
        } else if (command.equals("Add Particles")) {
            this.addParticles();
        } else if (command.equals("Multi Measure")) {
            this.multiMeasure();
        } else if (command.equals("Multi Plot")) {
            this.multiPlot();
        } else if (command.equals("Sort")) {
            this.sort();
        } else if (command.equals("Specify...")) {
            this.specify();
        } else if (command.equals("Remove Slice Info")) {
            this.removeSliceInfo();
        } else if (command.equals("Help")) {
            this.help();
        } else if (command.equals("Options...")) {
            this.options();
        } else if (command.equals("\"Show All\" Color...")) {
            this.setShowAllColor();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.showAllCheckbox) {
            if (this.firstTime) {
                this.labelsCheckbox.setState(true);
            }
            this.showAll(this.showAllCheckbox.getState() ? 0 : 1);
            this.firstTime = false;
            return;
        }
        if (source == this.labelsCheckbox) {
            if (this.firstTime) {
                this.showAllCheckbox.setState(true);
            }
            boolean editState = this.labelsCheckbox.getState();
            boolean showAllState = this.showAllCheckbox.getState();
            if (!showAllState && !editState) {
                this.showAll(1);
            } else {
                this.showAll(editState ? 2 : 3);
                if (editState) {
                    this.showAllCheckbox.setState(true);
                }
            }
            this.firstTime = false;
            return;
        }
        if (e.getStateChange() == 1 && !this.ignoreInterrupts) {
            int index = 0;
            try {
                index = Integer.parseInt(e.getItem().toString());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (index < 0) {
                index = 0;
            }
            if (!IJ.isMacintosh()) {
                if (!IJ.shiftKeyDown()) {
                    lastNonShiftClick = index;
                }
                if (!IJ.shiftKeyDown() && !IJ.controlKeyDown()) {
                    int[] indexes = this.getSelectedIndexes();
                    for (int i = 0; i < indexes.length; ++i) {
                        if (indexes[i] == index) continue;
                        this.list.deselect(indexes[i]);
                    }
                } else if (IJ.shiftKeyDown() && lastNonShiftClick >= 0 && lastNonShiftClick < this.list.getItemCount()) {
                    int i;
                    int firstIndex = Math.min(index, lastNonShiftClick);
                    int lastIndex = Math.max(index, lastNonShiftClick);
                    int[] indexes = this.getSelectedIndexes();
                    for (i = 0; i < indexes.length; ++i) {
                        if (indexes[i] >= firstIndex && indexes[i] <= lastIndex) continue;
                        this.list.deselect(indexes[i]);
                    }
                    for (i = firstIndex; i <= lastIndex; ++i) {
                        this.list.select(i);
                    }
                }
            }
            if (WindowManager.getCurrentImage() != null) {
                this.restore(this.getImage(), index, true);
                if (this.record()) {
                    if (Recorder.scriptMode()) {
                        Recorder.recordCall("rm.select(imp, " + index + ");");
                    } else {
                        Recorder.record("roiManager", "Select", index);
                    }
                }
            }
        }
    }

    void add(boolean shiftKeyDown, boolean altKeyDown) {
        if (shiftKeyDown) {
            this.addAndDraw(altKeyDown);
        } else if (altKeyDown) {
            this.addRoi(true);
        } else {
            this.addRoi(false);
        }
    }

    public void addRoi(Roi roi) {
        this.addRoi(roi, false, null, -1);
    }

    boolean addRoi(boolean promptForName) {
        return this.addRoi(null, promptForName, null, -1);
    }

    boolean addRoi(Roi roi, boolean promptForName, Color color, int lineWidth) {
        String label;
        Roi roi2;
        int n;
        ImagePlus imp;
        ImagePlus imagePlus = imp = roi == null ? this.getImage() : WindowManager.getCurrentImage();
        if (roi == null) {
            if (imp == null) {
                return false;
            }
            roi = imp.getRoi();
            if (roi == null) {
                this.error("The active image does not have a selection.");
                return false;
            }
        }
        if (color == null && roi.getStrokeColor() != null) {
            color = roi.getStrokeColor();
        } else if (color == null && this.defaultColor != null) {
            color = this.defaultColor;
        }
        if (lineWidth < 0) {
            int sw = (int)roi.getStrokeWidth();
            int n2 = lineWidth = sw > 1 ? sw : this.defaultLineWidth;
        }
        if (lineWidth > 100) {
            lineWidth = 1;
        }
        if ((n = this.list.getItemCount()) > 0 && !IJ.isMacro() && imp != null && (roi2 = (Roi)this.rois.get(label = this.list.getItem(n - 1))) != null) {
            int slice2 = this.getSliceNumber(roi2, label);
            if (roi.equals(roi2) && (slice2 == -1 || slice2 == imp.getCurrentSlice()) && imp.getID() == this.prevID && !Interpreter.isBatchMode()) {
                return false;
            }
        }
        this.prevID = imp != null ? imp.getID() : 0;
        String name = roi.getName();
        if (this.isStandardName(name)) {
            name = null;
        }
        String label2 = name != null ? name : this.getLabel(imp, roi, -1);
        label2 = promptForName ? this.promptForName(label2) : this.getUniqueName(label2);
        if (label2 == null) {
            return false;
        }
        this.list.add(label2);
        roi.setName(label2);
        Roi roiCopy = (Roi)roi.clone();
        if (lineWidth > 1) {
            roiCopy.setStrokeWidth(lineWidth);
        }
        if (color != null) {
            roiCopy.setStrokeColor(color);
        }
        this.rois.put(label2, roiCopy);
        this.updateShowAll();
        if (this.record()) {
            this.recordAdd(this.defaultColor, this.defaultLineWidth);
        }
        return true;
    }

    void recordAdd(Color color, int lineWidth) {
        if (Recorder.scriptMode()) {
            Recorder.recordCall("rm.addRoi(imp.getRoi());");
        } else if (color != null && lineWidth == 1) {
            Recorder.recordString("roiManager(\"Add\", \"" + this.getHex(color) + "\");\n");
        } else if (lineWidth > 1) {
            Recorder.recordString("roiManager(\"Add\", \"" + this.getHex(color) + "\", " + lineWidth + ");\n");
        } else {
            Recorder.record("roiManager", "Add");
        }
    }

    String getHex(Color color) {
        String hex;
        if (color == null) {
            color = ImageCanvas.getShowAllColor();
        }
        if ((hex = Integer.toHexString(color.getRGB())).length() == 8) {
            hex = hex.substring(2);
        }
        return hex;
    }

    public void add(ImagePlus imp, Roi roi, int n) {
        if (roi == null) {
            return;
        }
        String label = roi.getName();
        if (label == null) {
            label = this.getLabel(imp, roi, n);
        }
        if (label == null) {
            return;
        }
        this.list.add(label);
        roi.setName(label);
        this.rois.put(label, (Roi)roi.clone());
    }

    boolean isStandardName(String name) {
        if (name == null) {
            return false;
        }
        boolean isStandard = false;
        int len = name.length();
        if (len >= 14 && name.charAt(4) == '-' && name.charAt(9) == '-') {
            isStandard = true;
        } else if (len >= 17 && name.charAt(5) == '-' && name.charAt(11) == '-') {
            isStandard = true;
        } else if (len >= 9 && name.charAt(4) == '-') {
            isStandard = true;
        } else if (len >= 11 && name.charAt(5) == '-') {
            isStandard = true;
        }
        return isStandard;
    }

    String getLabel(ImagePlus imp, Roi roi, int n) {
        String ys;
        Rectangle r = roi.getBounds();
        int xc = r.x + r.width / 2;
        int yc = r.y + r.height / 2;
        if (n >= 0) {
            xc = yc;
            yc = n;
        }
        if (xc < 0) {
            xc = 0;
        }
        if (yc < 0) {
            yc = 0;
        }
        int digits = 4;
        String xs = "" + xc;
        if (xs.length() > digits) {
            digits = xs.length();
        }
        if ((ys = "" + yc).length() > digits) {
            digits = ys.length();
        }
        if (digits == 4 && imp != null && imp.getStackSize() >= 10000) {
            digits = 5;
        }
        xs = "000000" + xc;
        ys = "000000" + yc;
        String label = ys.substring(ys.length() - digits) + "-" + xs.substring(xs.length() - digits);
        if (imp != null && imp.getStackSize() > 1) {
            int slice = roi.getPosition();
            if (slice == 0) {
                slice = imp.getCurrentSlice();
            }
            String zs = "000000" + slice;
            label = zs.substring(zs.length() - digits) + "-" + label;
            roi.setPosition(slice);
        }
        return label;
    }

    void addAndDraw(boolean altKeyDown) {
        if (altKeyDown ? !this.addRoi(true) : !this.addRoi(false)) {
            return;
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            Undo.setup(4, imp);
            IJ.run(imp, "Draw", "slice");
            Undo.setup(5, imp);
        }
        if (this.record()) {
            Recorder.record("roiManager", "Add & Draw");
        }
    }

    boolean delete(boolean replacing) {
        int count = this.list.getItemCount();
        if (count == 0) {
            return this.error("The list is empty.");
        }
        int[] index = this.getSelectedIndexes();
        if (index.length == 0 || replacing && count > 1) {
            String msg = "Delete all items on the list?";
            if (replacing) {
                msg = "Replace items on the list?";
            }
            this.canceled = false;
            if (!IJ.isMacro() && !this.macro) {
                YesNoCancelDialog d = new YesNoCancelDialog((Frame)this, "ROI Manager", msg);
                if (d.cancelPressed()) {
                    this.canceled = true;
                    return false;
                }
                if (!d.yesPressed()) {
                    return false;
                }
            }
            index = this.getAllIndexes();
        }
        if (count == index.length && !replacing) {
            this.rois.clear();
            this.list.removeAll();
        } else {
            for (int i = count - 1; i >= 0; --i) {
                boolean delete = false;
                for (int j = 0; j < index.length; ++j) {
                    if (index[j] != i) continue;
                    delete = true;
                }
                if (!delete) continue;
                this.rois.remove(this.list.getItem(i));
                this.list.remove(i);
            }
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (count > 1 && index.length == 1 && imp != null) {
            imp.killRoi();
        }
        this.updateShowAll();
        if (this.record()) {
            Recorder.record("roiManager", "Delete");
        }
        return true;
    }

    boolean update(boolean clone) {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        ImageCanvas ic = imp.getCanvas();
        boolean showingAll = ic != null && ic.getShowAllROIs();
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.error("The active image does not have a selection.");
            return false;
        }
        int index = this.list.getSelectedIndex();
        if (index < 0 && !showingAll) {
            return this.error("Exactly one item in the list must be selected.");
        }
        if (index >= 0) {
            String name = this.list.getItem(index);
            this.rois.remove(name);
            if (clone) {
                Roi roi2 = (Roi)roi.clone();
                int position = roi.getPosition();
                if (imp.getStackSize() > 1) {
                    roi2.setPosition(imp.getCurrentSlice());
                }
                roi.setName(name);
                roi2.setName(name);
                this.rois.put(name, roi2);
            } else {
                this.rois.put(name, roi);
            }
        }
        if (this.record()) {
            Recorder.record("roiManager", "Update");
        }
        if (showingAll) {
            imp.draw();
        }
        return true;
    }

    boolean rename(String name2) {
        ImagePlus imp;
        int index = this.list.getSelectedIndex();
        if (index < 0) {
            return this.error("Exactly one item in the list must be selected.");
        }
        String name = this.list.getItem(index);
        if (name2 == null) {
            name2 = this.promptForName(name);
        }
        if (name2 == null) {
            return false;
        }
        Roi roi = (Roi)this.rois.get(name);
        this.rois.remove(name);
        roi.setName(name2);
        this.rois.put(name2, roi);
        this.list.replaceItem(name2, index);
        this.list.select(index);
        if (Prefs.useNamesAsLabels && this.labelsCheckbox.getState() && (imp = WindowManager.getCurrentImage()) != null) {
            imp.draw();
        }
        if (this.record()) {
            Recorder.record("roiManager", "Rename", name2);
        }
        return true;
    }

    String promptForName(String name) {
        GenericDialog gd = new GenericDialog("ROI Manager");
        gd.addStringField("Rename As:", name, 20);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        String name2 = gd.getNextString();
        name2 = this.getUniqueName(name2);
        return name2;
    }

    boolean restore(ImagePlus imp, int index, boolean setSlice) {
        ImageCanvas ic;
        int n;
        String label = this.list.getItem(index);
        Roi roi = (Roi)this.rois.get(label);
        if (imp == null || roi == null) {
            return false;
        }
        if (setSlice && (n = this.getSliceNumber(roi, label)) >= 1 && n <= imp.getStackSize()) {
            if (imp.isHyperStack() || imp.isComposite()) {
                imp.setPosition(n);
            } else {
                imp.setSlice(n);
            }
        }
        Roi roi2 = (Roi)roi.clone();
        Calibration cal = imp.getCalibration();
        Rectangle r = roi2.getBounds();
        int width = imp.getWidth();
        int height = imp.getHeight();
        if (restoreCentered && (ic = imp.getCanvas()) != null) {
            Rectangle r1 = ic.getSrcRect();
            Rectangle r2 = roi2.getBounds();
            roi2.setLocation(r1.x + r1.width / 2 - r2.width / 2, r1.y + r1.height / 2 - r2.height / 2);
        }
        if (r.x >= width || r.y >= height || r.x + r.width <= 0 || r.y + r.height <= 0) {
            roi2.setLocation((width - r.width) / 2, (height - r.height) / 2);
        }
        if (this.noUpdateMode) {
            imp.setRoi(roi2, false);
            this.noUpdateMode = false;
        } else {
            imp.setRoi(roi2, true);
        }
        return true;
    }

    boolean restoreWithoutUpdate(int index) {
        this.noUpdateMode = true;
        return this.restore(this.getImage(), index, false);
    }

    public int getSliceNumber(String label) {
        int slice = -1;
        if (label.length() >= 14 && label.charAt(4) == '-' && label.charAt(9) == '-') {
            slice = (int)Tools.parseDouble(label.substring(0, 4), -1.0);
        } else if (label.length() >= 17 && label.charAt(5) == '-' && label.charAt(11) == '-') {
            slice = (int)Tools.parseDouble(label.substring(0, 5), -1.0);
        } else if (label.length() >= 20 && label.charAt(6) == '-' && label.charAt(13) == '-') {
            slice = (int)Tools.parseDouble(label.substring(0, 6), -1.0);
        }
        return slice;
    }

    int getSliceNumber(Roi roi, String label) {
        int slice;
        int n = slice = roi != null ? roi.getPosition() : -1;
        if (slice == 0) {
            slice = -1;
        }
        if (slice == -1) {
            slice = this.getSliceNumber(label);
        }
        return slice;
    }

    void open(String path) {
        Roi roi;
        Macro.setOptions(null);
        String name = null;
        if (path == null || path.equals("")) {
            OpenDialog od = new OpenDialog("Open Selection(s)...", "");
            String directory = od.getDirectory();
            name = od.getFileName();
            if (name == null) {
                return;
            }
            path = directory + name;
        }
        if (this.record()) {
            Recorder.record("roiManager", "Open", path);
        }
        if (path.endsWith(".zip")) {
            this.openZip(path);
            return;
        }
        Opener o = new Opener();
        if (name == null) {
            name = o.getName(path);
        }
        if ((roi = o.openRoi(path)) != null) {
            if (name.endsWith(".roi")) {
                name = name.substring(0, name.length() - 4);
            }
            name = this.getUniqueName(name);
            this.list.add(name);
            this.rois.put(name, roi);
        }
        this.updateShowAll();
    }

    void openZip(String path) {
        ZipInputStream in = null;
        int nRois = 0;
        try {
            in = new ZipInputStream(new FileInputStream(path));
            byte[] buf = new byte[1024];
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (name.endsWith(".roi")) {
                    int len;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.close();
                    byte[] bytes = out.toByteArray();
                    RoiDecoder rd = new RoiDecoder(bytes, name);
                    Roi roi = rd.getRoi();
                    if (roi != null) {
                        name = name.substring(0, name.length() - 4);
                        name = this.getUniqueName(name);
                        this.list.add(name);
                        this.rois.put(name, roi);
                        ++nRois;
                    }
                }
                entry = in.getNextEntry();
            }
            in.close();
        }
        catch (IOException e) {
            this.error(e.toString());
        }
        if (nRois == 0) {
            this.error("This ZIP archive does not appear to contain \".roi\" files");
        }
        this.updateShowAll();
    }

    String getUniqueName(String name) {
        String name2 = name;
        int n = 1;
        Roi roi2 = (Roi)this.rois.get(name2);
        while (roi2 != null) {
            roi2 = (Roi)this.rois.get(name2);
            if (roi2 != null) {
                int lastDash = name2.lastIndexOf("-");
                if (lastDash != -1 && name2.length() - lastDash < 5) {
                    name2 = name2.substring(0, lastDash);
                }
                name2 = name2 + "-" + n;
                ++n;
            }
            roi2 = (Roi)this.rois.get(name2);
        }
        return name2;
    }

    boolean save() {
        if (this.list.getItemCount() == 0) {
            return this.error("The selection list is empty.");
        }
        int[] indexes = this.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        if (indexes.length > 1) {
            return this.saveMultiple(indexes, null);
        }
        String name = this.list.getItem(indexes[0]);
        Macro.setOptions(null);
        SaveDialog sd = new SaveDialog("Save Selection...", name, ".roi");
        String name2 = sd.getFileName();
        if (name2 == null) {
            return false;
        }
        String dir = sd.getDirectory();
        Roi roi = (Roi)this.rois.get(name);
        this.rois.remove(name);
        if (!name2.endsWith(".roi")) {
            name2 = name2 + ".roi";
        }
        String newName = name2.substring(0, name2.length() - 4);
        this.rois.put(newName, roi);
        roi.setName(newName);
        this.list.replaceItem(newName, indexes[0]);
        RoiEncoder re = new RoiEncoder(dir + name2);
        try {
            re.write(roi);
        }
        catch (IOException e) {
            IJ.error("ROI Manager", e.getMessage());
        }
        return true;
    }

    boolean saveMultiple(int[] indexes, String path) {
        Macro.setOptions(null);
        if (path == null) {
            SaveDialog sd = new SaveDialog("Save ROIs...", "RoiSet", ".zip");
            String name = sd.getFileName();
            if (name == null) {
                return false;
            }
            if (!name.endsWith(".zip") && !name.endsWith(".ZIP")) {
                name = name + ".zip";
            }
            String dir = sd.getDirectory();
            path = dir + name;
        }
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(path));
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(zos));
            RoiEncoder re = new RoiEncoder(out);
            for (int i = 0; i < indexes.length; ++i) {
                String label = this.list.getItem(indexes[i]);
                Roi roi = (Roi)this.rois.get(label);
                if (!label.endsWith(".roi")) {
                    label = label + ".roi";
                }
                zos.putNextEntry(new ZipEntry(label));
                re.write(roi);
                out.flush();
            }
            out.close();
        }
        catch (IOException e) {
            this.error("" + e);
            return false;
        }
        if (this.record()) {
            Recorder.record("roiManager", "Save", path);
        }
        return true;
    }

    boolean measure(int mode) {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        int[] indexes = this.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        if (indexes.length == 0) {
            return false;
        }
        boolean allSliceOne = true;
        for (int i = 0; i < indexes.length; ++i) {
            String label = this.list.getItem(indexes[i]);
            Roi roi = (Roi)this.rois.get(label);
            if (this.getSliceNumber(roi, label) <= 1) continue;
            allSliceOne = false;
        }
        int measurements = Analyzer.getMeasurements();
        if (imp.getStackSize() > 1) {
            Analyzer.setMeasurements(measurements | 0x100000);
        }
        int currentSlice = imp.getCurrentSlice();
        for (int i = 0; i < indexes.length && this.restore(this.getImage(), indexes[i], !allSliceOne); ++i) {
            IJ.run("Measure");
        }
        imp.setSlice(currentSlice);
        Analyzer.setMeasurements(measurements);
        if (indexes.length > 1) {
            IJ.run("Select None");
        }
        if (this.record()) {
            Recorder.record("roiManager", "Measure");
        }
        return true;
    }

    boolean multiMeasure() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        int[] indexes = this.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        if (indexes.length == 0) {
            return false;
        }
        int measurements = Analyzer.getMeasurements();
        int nSlices = imp.getStackSize();
        if (IJ.isMacro()) {
            if (nSlices > 1) {
                measureAll = true;
            }
            onePerSlice = true;
        } else {
            GenericDialog gd = new GenericDialog("Multi Measure");
            if (nSlices > 1) {
                gd.addCheckbox("Measure All " + nSlices + " Slices", measureAll);
            }
            gd.addCheckbox("One Row Per Slice", onePerSlice);
            int columns = this.getColumnCount(imp, measurements) * indexes.length;
            String str = nSlices == 1 ? "this option" : "both options";
            gd.setInsets(10, 25, 0);
            gd.addMessage("Enabling " + str + " will result\n" + "in a table with " + columns + " columns.");
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            if (nSlices > 1) {
                measureAll = gd.getNextBoolean();
            }
            onePerSlice = gd.getNextBoolean();
        }
        if (!measureAll) {
            nSlices = 1;
        }
        int currentSlice = imp.getCurrentSlice();
        if (!onePerSlice) {
            int measurements2 = nSlices > 1 ? measurements | 0x100000 : measurements;
            ResultsTable rt = new ResultsTable();
            Analyzer analyzer = new Analyzer(imp, measurements2, rt);
            for (int slice = 1; slice <= nSlices; ++slice) {
                if (nSlices > 1) {
                    imp.setSliceWithoutUpdate(slice);
                }
                for (int i = 0; i < indexes.length && this.restoreWithoutUpdate(indexes[i]); ++i) {
                    analyzer.measure();
                }
            }
            rt.show("Results");
            if (nSlices > 1) {
                imp.setSlice(currentSlice);
            }
            return true;
        }
        Analyzer aSys = new Analyzer(imp);
        ResultsTable rtSys = Analyzer.getResultsTable();
        ResultsTable rtMulti = new ResultsTable();
        Analyzer aMulti = new Analyzer(imp, measurements, rtMulti);
        for (int slice = 1; slice <= nSlices; ++slice) {
            int sliceUse = slice;
            if (nSlices == 1) {
                sliceUse = currentSlice;
            }
            imp.setSliceWithoutUpdate(sliceUse);
            rtMulti.incrementCounter();
            int roiIndex = 0;
            for (int i = 0; i < indexes.length && this.restoreWithoutUpdate(indexes[i]); ++i) {
                ++roiIndex;
                aSys.measure();
                for (int j = 0; j <= rtSys.getLastColumn(); ++j) {
                    String name;
                    float[] col = rtSys.getColumn(j);
                    String head = rtSys.getColumnHeading(j);
                    String suffix = "" + roiIndex;
                    Roi roi = imp.getRoi();
                    if (!(roi == null || (name = roi.getName()) == null || name.length() <= 0 || name.length() >= 9 && Character.isDigit(name.charAt(0)))) {
                        suffix = "(" + name + ")";
                    }
                    if (head == null || col == null || head.equals("Slice")) continue;
                    rtMulti.addValue(head + suffix, (double)rtSys.getValue(j, rtSys.getCounter() - 1));
                }
            }
        }
        rtMulti.show("Results");
        imp.setSlice(currentSlice);
        if (indexes.length > 1) {
            IJ.run("Select None");
        }
        if (this.record()) {
            Recorder.record("roiManager", "Multi Measure");
        }
        return true;
    }

    int getColumnCount(ImagePlus imp, int measurements) {
        ImageStatistics stats = imp.getStatistics(measurements);
        ResultsTable rt = new ResultsTable();
        Analyzer analyzer = new Analyzer(imp, measurements, rt);
        analyzer.saveResults(stats, null);
        int count = 0;
        for (int i = 0; i <= rt.getLastColumn(); ++i) {
            float[] col = rt.getColumn(i);
            String head = rt.getColumnHeading(i);
            if (head == null || col == null) continue;
            ++count;
        }
        return count;
    }

    void multiPlot() {
        Roi roi;
        int n;
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        int[] indexes = this.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        if ((n = indexes.length) == 0) {
            return;
        }
        Color[] colors = new Color[]{Color.blue, Color.green, Color.magenta, Color.red, Color.cyan, Color.yellow};
        if (n > colors.length) {
            colors = new Color[n];
            double c = 0.0;
            double inc = 150.0 / (double)n;
            for (int i = 0; i < n; ++i) {
                colors[i] = new Color((int)c, (int)c, (int)c);
                c += inc;
            }
        }
        int currentSlice = imp.getCurrentSlice();
        double[][] x = new double[n][];
        double[][] y = new double[n][];
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        int maxX = 0;
        Calibration cal = imp.getCalibration();
        double xinc = cal.pixelWidth;
        for (int i = 0; i < indexes.length && this.restore(this.getImage(), indexes[i], true) && (roi = imp.getRoi()) != null; ++i) {
            double[] a;
            if (roi.isArea() && roi.getType() != 0) {
                IJ.run(imp, "Area to Line", "");
            }
            ProfilePlot pp = new ProfilePlot(imp, IJ.altKeyDown());
            y[i] = pp.getProfile();
            if (y[i] == null) break;
            if (y[i].length > maxX) {
                maxX = y[i].length;
            }
            if ((a = Tools.getMinMax(y[i]))[0] < minY) {
                minY = a[0];
            }
            if (a[1] > maxY) {
                maxY = a[1];
            }
            double[] xx = new double[y[i].length];
            for (int j = 0; j < xx.length; ++j) {
                xx[j] = (double)j * xinc;
            }
            x[i] = xx;
        }
        String xlabel = "Distance (" + cal.getUnits() + ")";
        Plot plot = new Plot("Profiles", xlabel, "Value", x[0], y[0]);
        plot.setLimits(0.0, (double)maxX * xinc, minY, maxY);
        for (int i = 1; i < indexes.length; ++i) {
            plot.setColor(colors[i]);
            if (x[i] == null) continue;
            plot.addPoints(x[i], y[i], 2);
        }
        plot.setColor(colors[0]);
        if (x[0] != null) {
            plot.show();
        }
        imp.setSlice(currentSlice);
        if (indexes.length > 1) {
            IJ.run("Select None");
        }
        if (this.record()) {
            Recorder.record("roiManager", "Multi Plot");
        }
    }

    boolean drawOrFill(int mode) {
        int[] indexes = this.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        imp.killRoi();
        ImageProcessor ip = imp.getProcessor();
        ip.setColor(Toolbar.getForegroundColor());
        ip.snapshot();
        Undo.setup(1, imp);
        Filler filler = mode == 2 ? new Filler() : null;
        int slice = imp.getCurrentSlice();
        block5: for (int i = 0; i < indexes.length; ++i) {
            int slice2;
            String name = this.list.getItem(indexes[i]);
            Roi roi = (Roi)this.rois.get(name);
            int type = roi.getType();
            if (roi == null) continue;
            if (mode == 1 && (type == 6 || type == 7 || type == 8)) {
                mode = 0;
            }
            if ((slice2 = this.getSliceNumber(roi, name)) >= 1 && slice2 <= imp.getStackSize()) {
                imp.setSlice(slice2);
                ip = imp.getProcessor();
                ip.setColor(Toolbar.getForegroundColor());
                if (slice2 != slice) {
                    Undo.reset();
                }
            }
            switch (mode) {
                case 0: {
                    roi.drawPixels(ip);
                    continue block5;
                }
                case 1: {
                    ip.fill(roi);
                    continue block5;
                }
                case 2: {
                    roi.drawPixels(ip);
                    filler.drawLabel(imp, ip, i + 1, roi.getBounds());
                }
            }
        }
        ImageCanvas ic = imp.getCanvas();
        if (ic != null) {
            ic.setShowAllROIs(false);
        }
        imp.updateAndDraw();
        return true;
    }

    void setProperties(Color color, int lineWidth, Color fillColor) {
        boolean showingAll;
        int n;
        boolean showDialog = color == null && lineWidth == -1 && fillColor == null;
        int[] indexes = this.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        if ((n = indexes.length) == 0) {
            return;
        }
        Roi rpRoi = null;
        String rpName = null;
        Font font = null;
        int justification = 0;
        double opacity = -1.0;
        if (showDialog) {
            String label = this.list.getItem(indexes[0]);
            rpRoi = (Roi)this.rois.get(label);
            if (n == 1) {
                fillColor = rpRoi.getFillColor();
                rpName = rpRoi.getName();
            }
            if (rpRoi.getStrokeColor() == null) {
                rpRoi.setStrokeColor(ImageCanvas.getShowAllColor());
            }
            rpRoi = (Roi)rpRoi.clone();
            if (n > 1) {
                rpRoi.setName("range: " + (indexes[0] + 1) + "-" + (indexes[n - 1] + 1));
            }
            rpRoi.setFillColor(fillColor);
            RoiProperties rp = new RoiProperties("Properties", rpRoi);
            if (!rp.showDialog()) {
                return;
            }
            this.defaultLineWidth = lineWidth = (int)rpRoi.getStrokeWidth();
            color = rpRoi.getStrokeColor();
            fillColor = rpRoi.getFillColor();
            this.defaultColor = color;
            if (rpRoi instanceof TextRoi) {
                font = ((TextRoi)rpRoi).getCurrentFont();
                justification = ((TextRoi)rpRoi).getJustification();
            }
            if (rpRoi instanceof ImageRoi) {
                opacity = ((ImageRoi)rpRoi).getOpacity();
            }
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (n == this.list.getItemCount() && n > 1 && !IJ.isMacro()) {
            GenericDialog gd = new GenericDialog("ROI Manager");
            gd.addMessage("Apply changes to all " + n + " selections?");
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
        }
        for (int i = 0; i < n; ++i) {
            String label = this.list.getItem(indexes[i]);
            Roi roi = (Roi)this.rois.get(label);
            if (color != null) {
                roi.setStrokeColor(color);
            }
            if (lineWidth >= 0) {
                roi.setStrokeWidth(lineWidth);
            }
            roi.setFillColor(fillColor);
            if (roi != null && roi instanceof TextRoi) {
                roi.setImage(imp);
                if (font != null) {
                    ((TextRoi)roi).setCurrentFont(font);
                }
                ((TextRoi)roi).setJustification(justification);
                roi.setImage(null);
            }
            if (roi == null || !(roi instanceof ImageRoi) || opacity == -1.0) continue;
            ((ImageRoi)roi).setOpacity(opacity);
        }
        if (rpRoi != null && rpName != null && !rpRoi.getName().equals(rpName)) {
            this.rename(rpRoi.getName());
        }
        ImageCanvas ic = imp != null ? imp.getCanvas() : null;
        Roi roi = imp != null ? imp.getRoi() : null;
        boolean bl = showingAll = ic != null && ic.getShowAllROIs();
        if (!(roi == null || n != 1 && showingAll)) {
            if (lineWidth >= 0) {
                roi.setStrokeWidth(lineWidth);
            }
            if (color != null) {
                roi.setStrokeColor(color);
            }
            if (fillColor != null) {
                roi.setFillColor(fillColor);
            }
            if (roi != null && roi instanceof TextRoi) {
                ((TextRoi)roi).setCurrentFont(font);
                ((TextRoi)roi).setJustification(justification);
            }
            if (roi != null && roi instanceof ImageRoi && opacity != -1.0) {
                ((ImageRoi)roi).setOpacity(opacity);
            }
        }
        if (lineWidth > 1 && !showingAll && roi == null) {
            this.showAll(0);
            showingAll = true;
        }
        if (imp != null) {
            imp.draw();
        }
        if (this.record()) {
            if (fillColor != null) {
                Recorder.record("roiManager", "Set Fill Color", Colors.colorToString(fillColor));
            } else {
                Recorder.record("roiManager", "Set Color", Colors.colorToString(color != null ? color : Color.red));
                Recorder.record("roiManager", "Set Line Width", lineWidth);
            }
        }
    }

    void flatten() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        ImageCanvas ic = imp.getCanvas();
        if (!ic.getShowAllROIs() && ic.getDisplayList() == null && imp.getRoi() == null) {
            this.error("Image does not have an overlay or ROI");
        } else {
            IJ.doCommand("Flatten");
        }
    }

    public boolean getDrawLabels() {
        return this.labelsCheckbox.getState();
    }

    void combine() {
        Roi roi;
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        int[] indexes = this.getSelectedIndexes();
        if (indexes.length == 1) {
            this.error("More than one item must be selected, or none");
            return;
        }
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        int nPointRois = 0;
        for (int i = 0; i < indexes.length && (roi = (Roi)this.rois.get(this.list.getItem(indexes[i]))).getType() == 10; ++i) {
            ++nPointRois;
        }
        if (nPointRois == indexes.length) {
            this.combinePoints(imp, indexes);
        } else {
            this.combineRois(imp, indexes);
        }
        if (this.record()) {
            Recorder.record("roiManager", "Combine");
        }
    }

    void combineRois(ImagePlus imp, int[] indexes) {
        ShapeRoi s1 = null;
        ShapeRoi s2 = null;
        for (int i = 0; i < indexes.length; ++i) {
            Roi roi = (Roi)this.rois.get(this.list.getItem(indexes[i]));
            if (roi.isLine() || roi.getType() == 10) continue;
            if (s1 == null) {
                s1 = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
                if (s1 != null) continue;
                return;
            }
            s2 = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
            if (s2 == null || !roi.isArea()) continue;
            s1.or(s2);
        }
        if (s1 != null) {
            imp.setRoi(s1);
        }
    }

    void combinePoints(ImagePlus imp, int[] indexes) {
        int n = indexes.length;
        Polygon[] p = new Polygon[n];
        int points = 0;
        for (int i = 0; i < n; ++i) {
            Roi roi = (Roi)this.rois.get(this.list.getItem(indexes[i]));
            p[i] = roi.getPolygon();
            points += p[i].npoints;
        }
        if (points == 0) {
            return;
        }
        int[] xpoints = new int[points];
        int[] ypoints = new int[points];
        int index = 0;
        for (int i = 0; i < p.length; ++i) {
            for (int j = 0; j < p[i].npoints; ++j) {
                xpoints[index] = p[i].xpoints[j];
                ypoints[index] = p[i].ypoints[j];
                ++index;
            }
        }
        imp.setRoi(new PointRoi(xpoints, ypoints, xpoints.length));
    }

    void and() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        int[] indexes = this.getSelectedIndexes();
        if (indexes.length == 1) {
            this.error("More than one item must be selected, or none");
            return;
        }
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        ShapeRoi s1 = null;
        ShapeRoi s2 = null;
        for (int i = 0; i < indexes.length; ++i) {
            Roi roi = (Roi)this.rois.get(this.list.getItem(indexes[i]));
            if (!roi.isArea()) continue;
            if (s1 == null) {
                s1 = roi instanceof ShapeRoi ? (ShapeRoi)roi.clone() : new ShapeRoi(roi);
                if (s1 != null) continue;
                return;
            }
            s2 = roi instanceof ShapeRoi ? (ShapeRoi)roi.clone() : new ShapeRoi(roi);
            if (s2 == null) continue;
            s1.and(s2);
        }
        if (s1 != null) {
            imp.setRoi(s1);
        }
        if (this.record()) {
            Recorder.record("roiManager", "AND");
        }
    }

    void xor() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        int[] indexes = this.getSelectedIndexes();
        if (indexes.length == 1) {
            this.error("More than one item must be selected, or none");
            return;
        }
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        ShapeRoi s1 = null;
        ShapeRoi s2 = null;
        for (int i = 0; i < indexes.length; ++i) {
            Roi roi = (Roi)this.rois.get(this.list.getItem(indexes[i]));
            if (!roi.isArea()) continue;
            if (s1 == null) {
                s1 = roi instanceof ShapeRoi ? (ShapeRoi)roi.clone() : new ShapeRoi(roi);
                if (s1 != null) continue;
                return;
            }
            s2 = roi instanceof ShapeRoi ? (ShapeRoi)roi.clone() : new ShapeRoi(roi);
            if (s2 == null) continue;
            s1.xor(s2);
        }
        if (s1 != null) {
            imp.setRoi(s1);
        }
        if (this.record()) {
            Recorder.record("roiManager", "XOR");
        }
    }

    void addParticles() {
        String err = IJ.runMacroFile("ij.jar:AddParticles", null);
        if (err != null && err.length() > 0) {
            this.error(err);
        }
    }

    void sort() {
        int n = this.rois.size();
        if (n == 0) {
            return;
        }
        String[] labels = new String[n];
        int index = 0;
        Enumeration en = this.rois.keys();
        while (en.hasMoreElements()) {
            labels[index++] = (String)en.nextElement();
        }
        this.list.removeAll();
        StringSorter.sort(labels);
        for (int i = 0; i < labels.length; ++i) {
            this.list.add(labels[i]);
        }
        if (this.record()) {
            Recorder.record("roiManager", "Sort");
        }
    }

    void specify() {
        try {
            IJ.run("Specify...");
        }
        catch (Exception e) {
            return;
        }
        this.runCommand("add");
    }

    void removeSliceInfo() {
        int[] indexes = this.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        for (int i = 0; i < indexes.length; ++i) {
            int index = indexes[i];
            String name = this.list.getItem(index);
            int n = this.getSliceNumber(name);
            if (n == -1) continue;
            String name2 = name.substring(5, name.length());
            name2 = this.getUniqueName(name2);
            Roi roi = (Roi)this.rois.get(name);
            this.rois.remove(name);
            roi.setName(name2);
            roi.setPosition(0);
            this.rois.put(name2, roi);
            this.list.replaceItem(name2, index);
        }
        if (this.record()) {
            Recorder.record("roiManager", "Remove Slice Info");
        }
    }

    void help() {
        String macro = "run('URL...', 'url=http://imagej.nih.gov/ij/docs/menus/analyze.html#manager');";
        new MacroRunner(macro);
    }

    void options() {
        Color c = ImageCanvas.getShowAllColor();
        GenericDialog gd = new GenericDialog("Options");
        gd.addPanel(this.makeButtonPanel(gd), 10, new Insets(5, 0, 0, 0));
        gd.addCheckbox("Associate \"Show All\" ROIs with slices", Prefs.showAllSliceOnly);
        gd.addCheckbox("Restore ROIs centered", restoreCentered);
        gd.addCheckbox("Use ROI names as labels", Prefs.useNamesAsLabels);
        gd.showDialog();
        if (gd.wasCanceled()) {
            if (c != ImageCanvas.getShowAllColor()) {
                ImageCanvas.setShowAllColor(c);
            }
            return;
        }
        Prefs.showAllSliceOnly = gd.getNextBoolean();
        restoreCentered = gd.getNextBoolean();
        Prefs.useNamesAsLabels = gd.getNextBoolean();
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            imp.draw();
        }
        if (this.record()) {
            Recorder.record("roiManager", "Associate", Prefs.showAllSliceOnly ? "true" : "false");
            Recorder.record("roiManager", "Centered", restoreCentered ? "true" : "false");
            Recorder.record("roiManager", "UseNames", Prefs.useNamesAsLabels ? "true" : "false");
        }
    }

    Panel makeButtonPanel(GenericDialog gd) {
        Panel panel = new Panel();
        this.colorButton = new Button("\"Show All\" Color...");
        this.colorButton.addActionListener(this);
        panel.add(this.colorButton);
        return panel;
    }

    void setShowAllColor() {
        ColorChooser cc = new ColorChooser("\"Show All\" Color", ImageCanvas.getShowAllColor(), false);
        ImageCanvas.setShowAllColor(cc.getColor());
    }

    void split() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        Roi roi = imp.getRoi();
        if (roi == null || roi.getType() != 9) {
            this.error("Image with composite selection required");
            return;
        }
        boolean record = Recorder.record;
        Recorder.record = false;
        Roi[] rois = ((ShapeRoi)roi).getRois();
        for (int i = 0; i < rois.length; ++i) {
            imp.setRoi(rois[i]);
            this.addRoi(false);
        }
        Recorder.record = record;
        if (this.record()) {
            Recorder.record("roiManager", "Split");
        }
    }

    void showAll(int mode) {
        boolean showAll;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            this.error("There are no images open.");
            return;
        }
        ImageCanvas ic = imp.getCanvas();
        if (ic == null) {
            return;
        }
        boolean bl = showAll = mode == 0;
        if (mode == 2) {
            showAll = true;
            if (this.record()) {
                Recorder.record("roiManager", "Show All with labels");
            }
        } else if (mode == 3) {
            showAll = true;
            if (this.record()) {
                Recorder.record("roiManager", "Show All without labels");
            }
        }
        if (showAll) {
            imp.killRoi();
        }
        ic.setShowAllROIs(showAll);
        if (this.record()) {
            Recorder.record("roiManager", showAll ? "Show All" : "Show None");
        }
        imp.draw();
    }

    void updateShowAll() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        ImageCanvas ic = imp.getCanvas();
        if (ic != null && ic.getShowAllROIs()) {
            imp.draw();
        }
    }

    int[] getAllIndexes() {
        int count = this.list.getItemCount();
        int[] indexes = new int[count];
        for (int i = 0; i < count; ++i) {
            indexes[i] = i;
        }
        return indexes;
    }

    ImagePlus getImage() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            this.error("There are no images open.");
            return null;
        }
        return imp;
    }

    boolean error(String msg) {
        new MessageDialog((Frame)this, "ROI Manager", msg);
        Macro.abort();
        return false;
    }

    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            instance = null;
        }
        if (!IJ.isMacro()) {
            this.ignoreInterrupts = false;
        }
    }

    public static RoiManager getInstance() {
        return (RoiManager)instance;
    }

    public static RoiManager getInstance2() {
        RoiManager rm = RoiManager.getInstance();
        if (rm == null && IJ.isMacro()) {
            rm = Interpreter.getBatchModeRoiManager();
        }
        return rm;
    }

    public Hashtable getROIs() {
        return this.rois;
    }

    public List getList() {
        return this.list;
    }

    public int getCount() {
        return this.list.getItemCount();
    }

    public Roi[] getRoisAsArray() {
        int n = this.list.getItemCount();
        Roi[] array = new Roi[n];
        for (int i = 0; i < n; ++i) {
            String label = this.list.getItem(i);
            array[i] = (Roi)this.rois.get(label);
        }
        return array;
    }

    public Roi[] getSelectedRoisAsArray() {
        int[] indexes = this.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        int n = indexes.length;
        Roi[] array = new Roi[n];
        for (int i = 0; i < n; ++i) {
            String label = this.list.getItem(indexes[i]);
            array[i] = (Roi)this.rois.get(label);
        }
        return array;
    }

    public String getName(int index) {
        if (index >= 0 && index < this.list.getItemCount()) {
            return this.list.getItem(index);
        }
        return null;
    }

    public static String getName(String index) {
        int i = (int)Tools.parseDouble(index, -1.0);
        RoiManager instance = RoiManager.getInstance();
        if (instance != null && i >= 0 && i < instance.list.getItemCount()) {
            return instance.list.getItem(i);
        }
        return "null";
    }

    public boolean runCommand(String cmd) {
        cmd = cmd.toLowerCase();
        this.macro = true;
        boolean ok = true;
        if (cmd.equals("add")) {
            ImagePlus imp;
            Roi roi;
            boolean shift = IJ.shiftKeyDown();
            boolean alt = IJ.altKeyDown();
            if (Interpreter.isBatchMode()) {
                shift = false;
                alt = false;
            }
            Roi roi2 = roi = (imp = WindowManager.getCurrentImage()) != null ? imp.getRoi() : null;
            if (roi != null) {
                roi.setPosition(0);
            }
            this.add(shift, alt);
        } else if (cmd.equals("add & draw")) {
            this.addAndDraw(false);
        } else if (cmd.equals("update")) {
            this.update(true);
        } else if (cmd.equals("update2")) {
            this.update(false);
        } else if (cmd.equals("delete")) {
            this.delete(false);
        } else if (cmd.equals("measure")) {
            this.measure(1);
        } else if (cmd.equals("draw")) {
            this.drawOrFill(0);
        } else if (cmd.equals("fill")) {
            this.drawOrFill(1);
        } else if (cmd.equals("label")) {
            this.drawOrFill(2);
        } else if (cmd.equals("and")) {
            this.and();
        } else if (cmd.equals("or") || cmd.equals("combine")) {
            this.combine();
        } else if (cmd.equals("xor")) {
            this.xor();
        } else if (cmd.equals("split")) {
            this.split();
        } else if (cmd.equals("sort")) {
            this.sort();
        } else if (cmd.equals("multi measure")) {
            this.multiMeasure();
        } else if (cmd.equals("multi plot")) {
            this.multiPlot();
        } else if (cmd.equals("show all")) {
            if (WindowManager.getCurrentImage() != null) {
                this.showAll(0);
                this.showAllCheckbox.setState(true);
            }
        } else if (cmd.equals("show none")) {
            if (WindowManager.getCurrentImage() != null) {
                this.showAll(1);
                this.showAllCheckbox.setState(false);
            }
        } else if (cmd.equals("show all with labels")) {
            this.labelsCheckbox.setState(true);
            this.showAll(2);
            if (Interpreter.isBatchMode()) {
                IJ.wait(250);
            }
        } else if (cmd.equals("show all without labels")) {
            this.labelsCheckbox.setState(false);
            this.showAll(3);
            if (Interpreter.isBatchMode()) {
                IJ.wait(250);
            }
        } else if (cmd.equals("deselect") || cmd.indexOf("all") != -1) {
            if (IJ.isMacOSX()) {
                this.ignoreInterrupts = true;
            }
            this.select(-1);
            IJ.wait(50);
        } else if (cmd.equals("reset")) {
            if (IJ.isMacOSX() && IJ.isMacro()) {
                this.ignoreInterrupts = true;
            }
            this.list.removeAll();
            this.rois.clear();
            this.updateShowAll();
        } else if (!cmd.equals("debug")) {
            if (cmd.equals("enable interrupts")) {
                this.ignoreInterrupts = false;
            } else if (cmd.equals("remove slice info")) {
                this.removeSliceInfo();
            } else {
                ok = false;
            }
        }
        this.macro = false;
        return ok;
    }

    public boolean runCommand(String cmd, String name) {
        cmd = cmd.toLowerCase();
        this.macro = true;
        if (cmd.equals("open")) {
            this.open(name);
            this.macro = false;
            return true;
        }
        if (cmd.equals("save")) {
            if (!name.endsWith(".zip") && !name.equals("")) {
                return this.error("Name must end with '.zip'");
            }
            if (this.list.getItemCount() == 0) {
                return this.error("The selection list is empty.");
            }
            int[] indexes = this.getAllIndexes();
            boolean ok = false;
            ok = name.equals("") ? this.saveMultiple(indexes, null) : this.saveMultiple(indexes, name);
            this.macro = false;
            return ok;
        }
        if (cmd.equals("rename")) {
            this.rename(name);
            this.macro = false;
            return true;
        }
        if (cmd.equals("set color")) {
            Color color = Colors.decode(name, Color.cyan);
            this.setProperties(color, -1, null);
            this.macro = false;
            return true;
        }
        if (cmd.equals("set fill color")) {
            Color fillColor = Colors.decode(name, Color.cyan);
            this.setProperties(null, -1, fillColor);
            this.macro = false;
            return true;
        }
        if (cmd.equals("set line width")) {
            int lineWidth = (int)Tools.parseDouble(name, 0.0);
            if (lineWidth >= 0) {
                this.setProperties(null, lineWidth, null);
            }
            this.macro = false;
            return true;
        }
        if (cmd.equals("associate")) {
            Prefs.showAllSliceOnly = name.equals("true");
            this.macro = false;
            return true;
        }
        if (cmd.equals("centered")) {
            restoreCentered = name.equals("true");
            this.macro = false;
            return true;
        }
        if (cmd.equals("usenames")) {
            ImagePlus imp;
            Prefs.useNamesAsLabels = name.equals("true");
            this.macro = false;
            if (this.labelsCheckbox.getState() && (imp = WindowManager.getCurrentImage()) != null) {
                imp.draw();
            }
            return true;
        }
        return false;
    }

    public boolean runCommand(String cmd, String hexColor, double lineWidth) {
        Roi roi;
        ImagePlus imp = WindowManager.getCurrentImage();
        Roi roi2 = roi = imp != null ? imp.getRoi() : null;
        if (roi != null) {
            roi.setPosition(0);
        }
        if (hexColor == null && lineWidth == 1.0 && IJ.altKeyDown() && !Interpreter.isBatchMode()) {
            this.addRoi(true);
        } else {
            Color color = hexColor != null ? Colors.decode(hexColor, Color.cyan) : null;
            this.addRoi(null, false, color, (int)Math.round(lineWidth));
        }
        return true;
    }

    public void select(int index) {
        this.select(null, index);
    }

    public void select(ImagePlus imp, int index) {
        this.selectedIndexes = null;
        int n = this.list.getItemCount();
        if (index < 0) {
            for (int i = 0; i < n; ++i) {
                this.list.deselect(i);
            }
            if (this.record()) {
                Recorder.record("roiManager", "Deselect");
            }
            return;
        }
        if (index >= n) {
            return;
        }
        boolean mm = this.list.isMultipleMode();
        if (mm) {
            this.list.setMultipleMode(false);
        }
        int delay = 1;
        long start = System.currentTimeMillis();
        while (true) {
            this.list.select(index);
            if (delay > 1) {
                IJ.wait(delay);
            }
            if (this.list.isIndexSelected(index)) break;
            for (int i = 0; i < n; ++i) {
                if (!this.list.isSelected(i)) continue;
                this.list.deselect(i);
            }
            IJ.wait(delay);
            if ((delay *= 2) > 32) {
                delay = 32;
            }
            if (System.currentTimeMillis() - start <= 1000L) continue;
            this.error("Failed to select ROI " + index);
        }
        if (imp == null) {
            imp = this.getImage();
        }
        this.restore(imp, index, true);
        if (mm) {
            this.list.setMultipleMode(true);
        }
    }

    public void select(int index, boolean shiftKeyDown, boolean altKeyDown) {
        ImagePlus imp;
        if (!shiftKeyDown && !altKeyDown) {
            this.select(index);
        }
        if ((imp = IJ.getImage()) == null) {
            return;
        }
        Roi previousRoi = imp.getRoi();
        if (previousRoi == null) {
            this.select(index);
            return;
        }
        Roi.previousRoi = (Roi)previousRoi.clone();
        String label = this.list.getItem(index);
        Roi roi = (Roi)this.rois.get(label);
        if (roi != null) {
            roi.setImage(imp);
            roi.update(shiftKeyDown, altKeyDown);
        }
    }

    public void setEditMode(ImagePlus imp, boolean editMode) {
        ImageCanvas ic = imp.getCanvas();
        boolean showAll = false;
        if (ic != null) {
            showAll = ic.getShowAllROIs() | editMode;
            ic.setShowAllROIs(showAll);
            imp.draw();
        }
        this.showAllCheckbox.setState(showAll);
        this.labelsCheckbox.setState(editMode);
    }

    public void close() {
        super.close();
        instance = null;
        Prefs.saveLocation(LOC_KEY, this.getLocation());
    }

    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (e.isPopupTrigger() || e.isMetaDown()) {
            this.pm.show(e.getComponent(), x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseWheelMoved(MouseWheelEvent event) {
        RoiManager roiManager = this;
        synchronized (roiManager) {
            int index = this.list.getSelectedIndex();
            int rot = event.getWheelRotation();
            if (rot < -1) {
                rot = -1;
            }
            if (rot > 1) {
                rot = 1;
            }
            if ((index += rot) < 0) {
                index = 0;
            }
            if (index >= this.list.getItemCount()) {
                index = this.list.getItemCount();
            }
            this.select(index);
            if (IJ.isWindows()) {
                this.list.requestFocusInWindow();
            }
        }
    }

    public void setSelectedIndexes(int[] indexes) {
        int count = this.getCount();
        if (count == 0) {
            return;
        }
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] < 0) {
                indexes[i] = 0;
            }
            if (indexes[i] < count) continue;
            indexes[i] = count - 1;
        }
        this.selectedIndexes = indexes;
    }

    private int[] getSelectedIndexes() {
        if (this.selectedIndexes != null) {
            int[] indexes = this.selectedIndexes;
            this.selectedIndexes = null;
            return indexes;
        }
        return this.list.getSelectedIndexes();
    }

    private boolean record() {
        return Recorder.record && !IJ.isMacro();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    static {
        colorIndex = 4;
        measureAll = true;
        onePerSlice = true;
    }
}

