/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.parser.GrammarSupplier;
import adams.parser.MathematicalExpression;
import adams.parser.MathematicalExpressionText;
import java.util.HashMap;

public class MathExpression
extends AbstractTransformer
implements GrammarSupplier {
    private static final long serialVersionUID = -8477454145267616359L;
    public static final String PLACEHOLDER_INPUT = "X";
    protected MathematicalExpressionText m_Expression;
    protected boolean m_OutputValuePair;

    @Override
    public String globalInfo() {
        return "Evaluates a mathematical expression.\nThe input value (double or integer) can be accessed via 'X'.\nVariables are supported as well, e.g.: pow(X,@{exp}) with '@{exp}' being a variable available at execution time.\n\nThe following grammar is used for the expressions:\n\n" + this.getGrammar();
    }

    @Override
    public String getGrammar() {
        return new MathematicalExpression().getGrammar();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", new MathematicalExpressionText(PLACEHOLDER_INPUT));
        this.m_OptionManager.add("output-value-pair", "outputValuePair", false);
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("expression");
        if (variable != null) {
            return variable;
        }
        if (this.m_Expression != null && this.m_Expression.getValue().length() > 0) {
            return this.m_Expression.stringValue();
        }
        return null;
    }

    public void setExpression(MathematicalExpressionText value) {
        this.m_Expression = value;
        this.reset();
    }

    public MathematicalExpressionText getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The mathematical expression to evaluate; the input value can be accessed via 'X'.";
    }

    public void setOutputValuePair(boolean value) {
        this.m_OutputValuePair = value;
        this.reset();
    }

    public boolean getOutputValuePair() {
        return this.m_OutputValuePair;
    }

    public String outputValuePairTipText() {
        return "If enabled, a double array with X and Y is output and not just Y.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Integer.class, Double.class, Report.class, ReportHandler.class};
    }

    @Override
    public Class[] generates() {
        if (this.m_OutputValuePair) {
            return new Class[]{Double[].class};
        }
        return new Class[]{Double.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && (this.m_Expression == null || this.m_Expression.getValue().length() == 0)) {
            result = "No expression provided!";
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        String exp = this.m_Expression.getValue();
        try {
            exp = this.getVariables().expand(exp);
            Double x = null;
            Report report = null;
            if (this.m_InputToken.getPayload() instanceof Integer) {
                x = ((Integer)this.m_InputToken.getPayload()).doubleValue();
            } else if (this.m_InputToken.getPayload() instanceof Double) {
                x = (Double)this.m_InputToken.getPayload();
            } else if (this.m_InputToken.getPayload() instanceof Report) {
                report = (Report)this.m_InputToken.getPayload();
            } else if (this.m_InputToken.getPayload() instanceof ReportHandler) {
                report = ((ReportHandler)this.m_InputToken.getPayload()).getReport();
            }
            Double y = null;
            if (x != null) {
                HashMap<String, Double> symbols = new HashMap<String, Double>();
                symbols.put(PLACEHOLDER_INPUT, new Double(x));
                y = MathematicalExpression.evaluate(exp, symbols);
            } else if (report != null) {
                y = MathematicalExpression.evaluate(exp, report);
            }
            if (y != null) {
                this.m_OutputToken = this.m_OutputValuePair ? new Token(new Double[]{x, y}) : new Token(new Double(y));
            } else {
                result = "Failed to generate output?";
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            this.getSystemErr().println("Error evaluating: " + exp);
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        return result;
    }
}

