/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

@MixedCopyright(copyright="2002, 2003 Oliver Wieland", license=License.GPL2, url="http://fopps.sourceforge.net/", note="org.fopps.ui.EnhancedTable")
public class JTableHelper {
    public static final int MAX_ROWS = 100;
    protected JTable m_Table;

    public JTableHelper(JTable table) {
        this.m_Table = table;
    }

    public JTable getJTable() {
        return this.m_Table;
    }

    public int calcColumnWidth(int col) {
        return JTableHelper.calcColumnWidth(this.getJTable(), col);
    }

    public static int calcColumnWidth(JTable table, int col) {
        int result = JTableHelper.calcHeaderWidth(table, col);
        if (result == -1) {
            return result;
        }
        TableModel data = table.getModel();
        int rowCount = data.getRowCount();
        int dec = (int)Math.ceil((double)rowCount / 100.0);
        try {
            for (int row = rowCount - 1; row >= 0; row -= dec) {
                Component c = table.prepareRenderer(table.getCellRenderer(row, col), row, col);
                result = Math.max(result, c.getPreferredSize().width + 10);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int calcHeaderWidth(int col) {
        return JTableHelper.calcHeaderWidth(this.getJTable(), col);
    }

    public static int calcHeaderWidth(JTable table, int col) {
        if (table == null) {
            return -1;
        }
        if (col < 0 || col > table.getColumnCount()) {
            System.out.println("invalid col " + col);
            return -1;
        }
        JTableHeader header = table.getTableHeader();
        TableCellRenderer defaultHeaderRenderer = null;
        if (header != null) {
            defaultHeaderRenderer = header.getDefaultRenderer();
        }
        TableColumnModel columns = table.getColumnModel();
        TableColumn column = columns.getColumn(col);
        int width = -1;
        TableCellRenderer h = column.getHeaderRenderer();
        if (h == null) {
            h = defaultHeaderRenderer;
        }
        if (h != null) {
            Component c = h.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, col);
            width = c.getPreferredSize().width + 5;
        }
        return width;
    }

    public void setOptimalColumnWidth(int col) {
        JTableHelper.setOptimalColumnWidth(this.getJTable(), col);
    }

    public static void setOptimalColumnWidth(JTable table, int col) {
        int width;
        if (col >= 0 && col < table.getColumnModel().getColumnCount() && (width = JTableHelper.calcColumnWidth(table, col)) >= 0) {
            JTableHeader header = table.getTableHeader();
            TableColumn column = table.getColumnModel().getColumn(col);
            column.setPreferredWidth(width);
            table.doLayout();
            header.repaint();
        }
    }

    public void setOptimalColumnWidth() {
        JTableHelper.setOptimalColumnWidth(this.getJTable());
    }

    public static void setOptimalColumnWidth(JTable table) {
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            JTableHelper.setOptimalColumnWidth(table, i);
        }
    }

    public void setOptimalHeaderWidth(int col) {
        JTableHelper.setOptimalHeaderWidth(this.getJTable(), col);
    }

    public static void setOptimalHeaderWidth(JTable table, int col) {
        int width;
        if (col >= 0 && col < table.getColumnModel().getColumnCount() && (width = JTableHelper.calcHeaderWidth(table, col)) >= 0) {
            JTableHeader header = table.getTableHeader();
            TableColumn column = table.getColumnModel().getColumn(col);
            column.setPreferredWidth(width);
            table.doLayout();
            header.repaint();
        }
    }

    public void setOptimalHeaderWidth() {
        JTableHelper.setOptimalHeaderWidth(this.getJTable());
    }

    public static void setOptimalHeaderWidth(JTable table) {
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            JTableHelper.setOptimalHeaderWidth(table, i);
        }
    }

    public void scrollToVisible(int row, int col) {
        JTableHelper.scrollToVisible(this.getJTable(), row, col);
    }

    public static void scrollToVisible(JTable table, int row, int col) {
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(row, col, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }
}

