/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.core.ClassLister;
import adams.core.StatusMessageHandler;
import adams.core.base.BasePassword;
import adams.db.AbstractDatabaseConnection;
import adams.db.ConnectionParameters;
import adams.db.DatabaseConnectionProvider;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractDatabaseConnectionPanel
extends BasePanel
implements StatusMessageHandler,
Comparable<AbstractDatabaseConnectionPanel>,
DatabaseConnectionProvider {
    private static final long serialVersionUID = -8207475445903090661L;
    protected AbstractDatabaseConnectionPanel m_Self;
    protected JComboBox m_ComboBoxConnections;
    protected JTextField m_TextURL;
    protected JTextField m_TextUser;
    protected JPasswordField m_TextPassword;
    protected JCheckBox m_CheckBoxShowPassword;
    protected JSpinner m_SpinnerDebugLevel;
    protected JCheckBox m_CheckBoxConnectOnStartUp;
    protected JButton m_ButtonMakeDefault;
    protected JButton m_ButtonConnect;
    protected JLabel m_LabelStatus;
    protected ParameterPanel m_PanelParameters;
    protected HashSet<ChangeListener> m_ChangeListeners;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Self = this;
        this.m_ChangeListeners = new HashSet();
    }

    protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelParameters = new ParameterPanel();
        this.add((Component)this.m_PanelParameters, "North");
        this.m_ComboBoxConnections = new JComboBox<ConnectionParameters>(this.getDatabaseConnection().getConnections());
        this.m_ComboBoxConnections.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractDatabaseConnectionPanel.this.m_ComboBoxConnections.getSelectedIndex() == -1) {
                    return;
                }
                AbstractDatabaseConnectionPanel.this.displayParameters((ConnectionParameters)AbstractDatabaseConnectionPanel.this.m_ComboBoxConnections.getSelectedItem());
            }
        });
        this.m_PanelParameters.addParameter("_Connections", this.m_ComboBoxConnections);
        this.m_TextURL = new JTextField(20);
        this.m_PanelParameters.addParameter("_URL", this.m_TextURL);
        this.m_TextUser = new JTextField(20);
        this.m_PanelParameters.addParameter("U_ser", this.m_TextUser);
        this.m_TextPassword = new JPasswordField(20);
        this.m_TextPassword.setEchoChar('*');
        this.m_PanelParameters.addParameter("_Password", this.m_TextPassword);
        this.m_CheckBoxShowPassword = new JCheckBox();
        this.m_CheckBoxShowPassword.setSelected(false);
        this.m_CheckBoxShowPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractDatabaseConnectionPanel.this.m_CheckBoxShowPassword.isSelected()) {
                    AbstractDatabaseConnectionPanel.this.m_TextPassword.setEchoChar('\u0000');
                } else {
                    AbstractDatabaseConnectionPanel.this.m_TextPassword.setEchoChar('*');
                }
            }
        });
        this.m_PanelParameters.addParameter("Sho_w password", this.m_CheckBoxShowPassword);
        this.m_SpinnerDebugLevel = new JSpinner();
        ((SpinnerNumberModel)this.m_SpinnerDebugLevel.getModel()).setMinimum(Integer.valueOf(0));
        ((SpinnerNumberModel)this.m_SpinnerDebugLevel.getModel()).setMaximum(Integer.valueOf(99));
        this.m_PanelParameters.addParameter("Debug _level", this.m_SpinnerDebugLevel);
        this.m_CheckBoxConnectOnStartUp = new JCheckBox();
        this.m_CheckBoxConnectOnStartUp.setSelected(false);
        this.m_PanelParameters.addParameter("Co_nnect on startup", this.m_CheckBoxConnectOnStartUp);
        JPanel panel2 = new JPanel(new BorderLayout());
        this.add((Component)panel2, "South");
        this.m_LabelStatus = new JLabel();
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this.m_LabelStatus);
        panel2.add((Component)panel, "West");
        panel = new JPanel(new FlowLayout(2));
        this.m_ButtonMakeDefault = new JButton("Make default");
        panel.add(this.m_ButtonMakeDefault);
        this.m_ButtonMakeDefault.setMnemonic('m');
        this.m_ButtonMakeDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDatabaseConnectionPanel.this.m_ButtonMakeDefault.setEnabled(false);
                AbstractDatabaseConnectionPanel.this.makeDefault();
                AbstractDatabaseConnectionPanel.this.m_ButtonMakeDefault.setEnabled(true);
                AbstractDatabaseConnectionPanel.this.update();
            }
        });
        this.m_ButtonConnect = new JButton("Connect");
        panel.add(this.m_ButtonConnect);
        this.m_ButtonConnect.setMnemonic('C');
        this.m_ButtonConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDatabaseConnectionPanel.this.doReconnect();
            }
        });
        panel2.add((Component)panel, "East");
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.update();
    }

    protected abstract String getTitle();

    protected void displayParameters(ConnectionParameters conn) {
        this.m_TextURL.setText(conn.getURL());
        this.m_TextUser.setText(conn.getUser());
        this.m_TextPassword.setText(conn.getPassword().getValue());
        this.m_SpinnerDebugLevel.setValue(conn.getDebugLevel());
        this.m_CheckBoxConnectOnStartUp.setSelected(conn.getConnectOnStartUp());
    }

    protected void displayParameters(AbstractDatabaseConnection conn) {
        this.displayParameters(conn.getCurrentConnection());
        boolean connected = conn.isConnected();
        Vector<ConnectionParameters> connections = conn.getConnections();
        ConnectionParameters current = conn.getCurrentConnection();
        int index = connections.indexOf(current);
        this.m_ComboBoxConnections.setModel(new DefaultComboBoxModel<ConnectionParameters>(connections));
        this.m_ComboBoxConnections.setSelectedIndex(index);
        this.m_ComboBoxConnections.setEnabled(!connected);
        this.m_TextURL.setEditable(!connected);
        this.m_TextUser.setEditable(!connected);
        this.m_TextPassword.setEditable(!connected);
        this.m_CheckBoxShowPassword.setEnabled(!connected);
        this.m_SpinnerDebugLevel.setEnabled(!connected);
        this.m_CheckBoxConnectOnStartUp.setEnabled(!connected);
        this.m_ButtonMakeDefault.setEnabled(!this.getCurrentParameters().equals(conn.getDefaultConnection()));
        if (connected) {
            this.m_ButtonConnect.setText("Disconnect");
        } else {
            this.m_ButtonConnect.setText("Connect");
        }
    }

    protected abstract void doReconnect();

    protected void makeDefault() {
        if (!this.getDatabaseConnection().makeDefaultConnection(this.getCurrentParameters())) {
            GUIHelper.showErrorMessage(this.m_Self, "Failed to make current connection the default one!");
        }
    }

    protected ConnectionParameters newConnectionParameters() {
        return new ConnectionParameters();
    }

    protected ConnectionParameters getCurrentParameters() {
        ConnectionParameters result = this.newConnectionParameters();
        result.setParameter("URL", this.m_TextURL.getText());
        result.setParameter("User", this.m_TextUser.getText());
        result.setParameter("Password", new BasePassword(new String(this.m_TextPassword.getPassword())).stringValue());
        result.setParameter("DebugLevel", ((Number)this.m_SpinnerDebugLevel.getValue()).toString());
        result.setParameter("ConnectOnStartup", "" + this.m_CheckBoxConnectOnStartUp.isSelected());
        return result;
    }

    @Override
    public abstract AbstractDatabaseConnection getDatabaseConnection();

    public void update() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractDatabaseConnectionPanel.this.displayParameters(AbstractDatabaseConnectionPanel.this.getDatabaseConnection());
            }
        });
    }

    protected void setEnabledState(boolean b) {
        this.m_ComboBoxConnections.setEnabled(b);
        this.m_TextURL.setEnabled(b);
        this.m_TextUser.setEnabled(b);
        this.m_TextPassword.setEnabled(b);
        this.m_CheckBoxShowPassword.setEnabled(b);
        this.m_SpinnerDebugLevel.setEnabled(b);
        this.m_CheckBoxConnectOnStartUp.setEnabled(b);
        this.m_ButtonMakeDefault.setEnabled(b);
        this.m_ButtonConnect.setEnabled(b);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setEnabledState(b);
        this.update();
    }

    @Override
    public void showStatus(final String msg) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                AbstractDatabaseConnectionPanel.this.m_LabelStatus.setText(msg);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public int compareTo(AbstractDatabaseConnectionPanel o) {
        return this.getTitle().compareTo(o.getTitle());
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractDatabaseConnectionPanel) {
            return this.compareTo((AbstractDatabaseConnectionPanel)o) == 0;
        }
        return false;
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected void notifyChangeListeners() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener l : this.m_ChangeListeners) {
            l.stateChanged(event);
        }
    }

    public static String[] getPanels() {
        return ClassLister.getSingleton().getClassnames(AbstractDatabaseConnectionPanel.class);
    }
}

