/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.core.Properties;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.gui.chooser.ColorChooserPanel;
import adams.gui.chooser.DirectoryChooserPanel;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.chooser.FontChooserPanel;
import adams.gui.dialog.AbstractPreferencesDialog;
import adams.gui.goe.FontEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class PropertiesPreferencesDialog
extends AbstractPreferencesDialog {
    private static final long serialVersionUID = -822178750857036833L;
    protected Hashtable<String, PreferenceType> m_PreferenceTypes;

    public PropertiesPreferencesDialog(Dialog owner) {
        super(owner);
    }

    public PropertiesPreferencesDialog(Frame owner) {
        super(owner);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PreferenceTypes = new Hashtable();
    }

    public void clearPreferenceTypes() {
        this.m_PreferenceTypes.clear();
    }

    public void addPreferenceType(String property, PreferenceType type) {
        this.m_PreferenceTypes.put(property, type);
    }

    public boolean hasPreferenceType(String property) {
        return this.m_PreferenceTypes.containsKey(property);
    }

    public PreferenceType getPreferenceType(String property) {
        if (this.hasPreferenceType(property)) {
            return this.m_PreferenceTypes.get(property);
        }
        return PreferenceType.STRING;
    }

    public void setPreferences(Properties value) {
        this.clearPreferences();
        Vector<String> keys = new Vector<String>(value.keySetAll());
        Collections.sort(keys);
        block9: for (String key : keys) {
            PreferenceType type = this.getPreferenceType(key);
            switch (type) {
                case DATE: 
                case DOUBLE: 
                case STRING: {
                    JTextField textfield = new JTextField(20);
                    textfield.setText(value.getProperty(key));
                    this.addPreference(key, key, textfield);
                    continue block9;
                }
                case BOOLEAN: {
                    JCheckBox checkbox = new JCheckBox();
                    checkbox.setSelected(value.getBoolean(key));
                    this.addPreference(key, key, checkbox);
                    continue block9;
                }
                case INTEGER: {
                    JSpinner spinner = new JSpinner();
                    spinner.setValue(value.getInteger(key));
                    this.addPreference(key, key, spinner);
                    continue block9;
                }
                case FONT: {
                    FontChooserPanel fontPanel = new FontChooserPanel();
                    fontPanel.setCurrent((Font)FontEditor.valueOf(null, value.getProperty(key)));
                    this.addPreference(key, key, fontPanel);
                    continue block9;
                }
                case DIRECTORY: {
                    DirectoryChooserPanel dirPanel = new DirectoryChooserPanel();
                    dirPanel.setCurrent(new PlaceholderDirectory(value.getString(key)));
                    this.addPreference(key, key, dirPanel);
                    continue block9;
                }
                case FILE: {
                    FileChooserPanel filePanel = new FileChooserPanel();
                    filePanel.setCurrent(new PlaceholderFile(value.getString(key)));
                    this.addPreference(key, key, filePanel);
                    continue block9;
                }
                case COLOR: {
                    ColorChooserPanel colorPanel = new ColorChooserPanel();
                    colorPanel.setCurrent(value.getColor(key));
                    this.addPreference(key, key, colorPanel);
                    continue block9;
                }
            }
            throw new IllegalStateException("Unhandled preference type (property '" + keys + "'): " + (Object)((Object)type));
        }
        this.pack();
    }

    public Properties getPreferences() {
        Properties result = new Properties();
        for (int i = 0; i < this.getPreferenceCount(); ++i) {
            Component comp = this.getPreference(i);
            if (comp instanceof JTextField) {
                JTextField textfield = (JTextField)comp;
                result.setProperty((String)this.m_Identifiers.get(i), textfield.getText());
                continue;
            }
            if (comp instanceof JCheckBox) {
                JCheckBox checkbox = (JCheckBox)comp;
                result.setBoolean((String)this.m_Identifiers.get(i), checkbox.isSelected());
                continue;
            }
            if (comp instanceof JSpinner) {
                JSpinner spinner = (JSpinner)comp;
                result.setInteger((String)this.m_Identifiers.get(i), ((Number)spinner.getValue()).intValue());
                continue;
            }
            if (comp instanceof FontChooserPanel) {
                FontChooserPanel fontPanel = (FontChooserPanel)comp;
                result.setProperty((String)this.m_Identifiers.get(i), FontEditor.toString(null, fontPanel.getCurrent()));
                continue;
            }
            if (comp instanceof DirectoryChooserPanel) {
                DirectoryChooserPanel dirPanel = (DirectoryChooserPanel)comp;
                result.setProperty((String)this.m_Identifiers.get(i), ((File)dirPanel.getCurrent()).toString());
                continue;
            }
            if (comp instanceof FileChooserPanel) {
                FileChooserPanel filePanel = (FileChooserPanel)comp;
                result.setProperty((String)this.m_Identifiers.get(i), ((File)filePanel.getCurrent()).toString());
                continue;
            }
            if (comp instanceof ColorChooserPanel) {
                ColorChooserPanel colorPanel = (ColorChooserPanel)comp;
                result.setColor((String)this.m_Identifiers.get(i), (Color)colorPanel.getCurrent());
                continue;
            }
            throw new IllegalStateException("Unhandled component type: " + comp.getClass().getName());
        }
        return result;
    }

    public static enum PreferenceType {
        BOOLEAN,
        INTEGER,
        DOUBLE,
        STRING,
        DATE,
        COLOR,
        FONT,
        FILE,
        DIRECTORY;

    }
}

