/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.container;

import adams.gui.event.PaintEvent;
import adams.gui.visualization.container.DataContainerPanel;
import adams.gui.visualization.core.AbstractPaintlet;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import java.awt.Color;
import java.awt.Graphics;

public abstract class AbstractDataContainerZoomOverviewPaintlet<P extends DataContainerPanel>
extends AbstractPaintlet {
    private static final long serialVersionUID = -3979473621483079352L;
    protected Color m_HighlightColor;

    @Override
    public String globalInfo() {
        return "Highlights the section that is currently zoomed in.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("highlight-color", "highlightColor", Color.LIGHT_GRAY);
    }

    public void setHighlightColor(Color value) {
        this.m_HighlightColor = value;
        this.memberChanged();
    }

    public Color getHighlightColor() {
        return this.m_HighlightColor;
    }

    public String backgroundColorTipText() {
        return "The color for the zoom highlight.";
    }

    @Override
    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.BACKGROUND;
    }

    protected abstract P getContainerPanel();

    @Override
    public void performPaint(Graphics g) {
        P panel = this.getContainerPanel();
        if (panel == null) {
            return;
        }
        AxisPanel axis = ((DataContainerPanel)panel).getPlot().getAxis(Axis.BOTTOM);
        if (!axis.isZoomed()) {
            return;
        }
        double min = axis.getAxisModel().getActualMinimum();
        double max = axis.getAxisModel().getActualMaximum();
        axis = this.getPlot().getAxis(Axis.BOTTOM);
        g.setColor(this.m_HighlightColor);
        g.fillRect(axis.valueToPos(min), 0, axis.valueToPos(max) - axis.valueToPos(min) + 1, this.getPanel().getHeight());
    }
}

