/*
 * Decompiled with CFR 0.152.
 */
package adams.tools;

import adams.core.base.BaseRegExp;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.SQL;
import adams.tools.AbstractDatabaseTool;
import java.util.Vector;

public class DropTables
extends AbstractDatabaseTool {
    private static final long serialVersionUID = 5980651808577627734L;
    protected BaseRegExp m_RegExp;
    protected boolean m_Invert;

    @Override
    public String globalInfo() {
        return "Drops all tables that match a regular expression (matching sense can be inverted).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(".*"));
        this.m_OptionManager.add("invert", "invert", false);
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression used for matching the table names.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If set to true, then the matching sense is inverted.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void doRun() {
        conn = this.getDatabaseConnection().getConnection(false);
        if (conn == null) {
            this.getSystemErr().println("Failed to obtain database connection??");
            return;
        }
        try {
            metadata = conn.getMetaData();
            rs = null;
            tables = new Vector<String>();
            try {
                rs = metadata.getTables(null, null, null, new String[]{"TABLE"});
                while (rs.next()) {
                    tables.add(rs.getString("TABLE_NAME"));
                }
                ** if (rs == null) goto lbl-1000
            }
            catch (Exception e) {
                try {
                    this.getSystemErr().println("Failed to retrieve list of tables:");
                    this.getSystemErr().printStackTrace(e);
                    ** if (rs == null) goto lbl-1000
                }
                catch (Throwable var6_8) {
                    if (rs != null) {
                        SQL.closeAll(rs);
                    }
                    throw var6_8;
                }
lbl-1000:
                // 1 sources

                {
                    SQL.closeAll(rs);
                }
lbl-1000:
                // 2 sources

                {
                }
            }
lbl-1000:
            // 1 sources

            {
                SQL.closeAll(rs);
            }
lbl-1000:
            // 2 sources

            {
            }
            if (this.isDebugOn()) {
                this.debug("Tables found: " + tables);
            }
            for (String table : tables) {
                if (this.m_Invert != false ? this.m_RegExp.isMatch(table) != false : this.m_RegExp.isMatch(table) == false) continue;
                this.getSystemOut().println("Dropping table '" + table + "': " + SQL.getSingleton(this.getDatabaseConnection()).drop(table));
            }
        }
        catch (Exception e) {
            this.getSystemErr().println("Failed to drop tables:");
            this.getSystemErr().printStackTrace(e);
        }
    }
}

