/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.InterquartileRange;

public class InterquartileRangeSamp
extends InterquartileRange {
    private static final long serialVersionUID = 3811630774543798261L;
    private Hashtable<Integer, Vector<Double>> ht = new Hashtable();
    private int m_sample_size = 150;
    private int count = 0;
    private int min_samples = 5;
    private Hashtable<Integer, Vector<IQRs>> m_iqrs = new Hashtable();

    private void addIQR_For(Integer key, Vector v) {
        if (v.size() >= this.min_samples) {
            Object[] arr = v.toArray();
            Arrays.sort(arr);
            double q3val = this.valueAtPct(arr, 0.75);
            double q1val = this.valueAtPct(arr, 0.25);
            double med = this.valueAtPct(arr, 0.5);
            Double d = (Double)arr[arr.length - 1];
            IQRs is = new IQRs(q1val, q3val, d, med);
            Vector<IQRs> viqr = this.m_iqrs.get(key);
            if (viqr == null) {
                viqr = new Vector();
                this.m_iqrs.put(key, viqr);
            }
            viqr.add(is);
        }
    }

    private double valueAtPct(Object[] sorted_arr, double pct) {
        double qval;
        double qindex = pct * (double)sorted_arr.length;
        int iqindex = (int)Math.floor(qindex);
        if ((double)iqindex == qindex) {
            Double d = (Double)sorted_arr[iqindex];
            qval = d;
        } else {
            Double d1 = (Double)sorted_arr[iqindex];
            Double d2 = (Double)sorted_arr[iqindex + 1];
            double pcte = qindex - (double)iqindex;
            qval = d1 + (d2 - d1) * pcte;
        }
        return qval;
    }

    public String globalInfo() {
        return "A sampling filter made to behave like S2 for detecting outliers and extreme values based on interquartile ranges. The filter skips the class attribute.\n\nOutliers:\n  Q3 + OF*IQR < x <= Q3 + EVF*IQR\n  or\n  Q1 - EVF*IQR <= x < Q1 - OF*IQR\n\nExtreme values:\n  x > Q3 + EVF*IQR\n  or\n  x < Q1 - EVF*IQR\n\nKey:\n  Q1  = 25% quartile\n  Q3  = 75% quartile\n  IQR = Interquartile Range, difference between Q1 and Q3\n  OF  = Outlier Factor\n  EVF = Extreme Value Factor";
    }

    private void clearRemainder() {
        Enumeration<Integer> enu = this.ht.keys();
        while (enu.hasMoreElements()) {
            Integer key = enu.nextElement();
            Vector<IQRs> viqr = this.m_iqrs.get(key);
            if (viqr != null) continue;
            Vector<Double> v = this.ht.get(key);
            this.addIQR_For(key, v);
        }
    }

    protected void computeThresholds(Instances instances) {
        this.m_UpperExtremeValue = new double[this.m_AttributeIndices.length];
        this.m_UpperOutlier = new double[this.m_AttributeIndices.length];
        this.m_LowerOutlier = new double[this.m_AttributeIndices.length];
        this.m_LowerExtremeValue = new double[this.m_AttributeIndices.length];
        this.m_Median = new double[this.m_AttributeIndices.length];
        this.m_IQR = new double[this.m_AttributeIndices.length];
        for (int i = 0; i < this.m_AttributeIndices.length; ++i) {
            if (this.m_AttributeIndices[i] == -1) continue;
            double[] values = instances.attributeToDoubleArray(this.m_AttributeIndices[i]);
            Vector<Double> v = new Vector<Double>();
            this.ht.put(i, v);
            for (int j = 0; j < values.length; ++j) {
                v.add(values[j]);
                if (v.size() != this.m_sample_size) continue;
                this.addIQR_For(i, v);
                v.clear();
            }
            this.clearRemainder();
        }
        Enumeration<Integer> enu = this.m_iqrs.keys();
        while (enu.hasMoreElements()) {
            double q2;
            double q1;
            double q3;
            Integer key = enu.nextElement();
            double dmax = Double.NEGATIVE_INFINITY;
            Vector<IQRs> v = this.m_iqrs.get(key);
            if (v.size() == 0) continue;
            Object[] q1s = new Object[v.size()];
            Object[] q3s = new Object[v.size()];
            Object[] meds = new Object[v.size()];
            for (int k = 0; k < v.size(); ++k) {
                IQRs iqrs = v.get(k);
                q1s[k] = new Double(iqrs.quartile1);
                q3s[k] = new Double(iqrs.quartile3);
                meds[k] = new Double(iqrs.median);
                if (!(iqrs.maxval > dmax)) continue;
                dmax = iqrs.maxval;
            }
            Arrays.sort(q1s);
            Arrays.sort(q3s);
            Arrays.sort(meds);
            if (v.size() > 1) {
                q3 = this.valueAtPct(q3s, 0.5);
                q1 = this.valueAtPct(q1s, 0.5);
                q2 = this.valueAtPct(meds, 0.5);
            } else {
                q3 = (Double)q3s[0];
                q1 = (Double)q1s[0];
                q2 = (Double)meds[0];
            }
            double iqrange = q3 - q1;
            this.m_Median[key.intValue()] = q2;
            this.m_IQR[key.intValue()] = q3 - q1;
            this.m_UpperExtremeValue[key.intValue()] = q3 + this.getExtremeValuesFactor() * this.m_IQR[key];
            this.m_UpperOutlier[key.intValue()] = q3 + this.getOutlierFactor() * this.m_IQR[key];
            this.m_LowerOutlier[key.intValue()] = q1 - this.getOutlierFactor() * this.m_IQR[key];
            this.m_LowerExtremeValue[key.intValue()] = q1 - this.getExtremeValuesFactor() * this.m_IQR[key];
        }
        this.ht = new Hashtable();
        this.m_iqrs = new Hashtable();
    }

    public static void main(String[] args) {
        InterquartileRangeSamp.runFilter((Filter)new InterquartileRangeSamp(), (String[])args);
    }

    private class IQRs {
        public double quartile1;
        public double median;
        public double quartile3;
        public double maxval;

        public IQRs(double q1, double q3, double mval, double med) {
            this.quartile1 = q1;
            this.quartile3 = q3;
            this.maxval = mval;
            this.median = med;
        }
    }
}

