/* Generated By:JavaCC: Do not edit this line. ExpressionParser.java */
package JSci.maths.symbolic;

import JSci.maths.*;
import JSci.maths.fields.*;
import JSci.maths.groups.*;

import java.io.*;
import java.util.*;

/** This class has some static methods to create an Expression from 
 * a string or a text stream.  */
public class ExpressionParser implements ExpressionParserConstants {

  private static ExpressionParser parser=null;

  private static Map variables;

  /** Create an Expression reading a text from a stream. The text can
   * be something like "x+y*sin(z)".
   * @param is a stream
   * @param vars a Map name / variable; it can 
   * contain some of the variable names.	
   * @return the Expression
   */
  public synchronized static Expression parse(InputStream is,Map vars) throws ParseException {
    variables=vars;
    if (variables==null) variables=new Hashtable();
    if (parser==null) parser = new ExpressionParser(is);
    else parser.ReInit(is);
    return parser.Input();
  }

  /** Create an Expression from a String like "x+y*sin(z)". 
   * @param s	a string 
   * @param vars a Map name / variable; it can 
   * contain some of the variable names.
   * @return the Expression
   */
  public static Expression parse(String s,Map vars) throws ParseException {
    InputStream i=new ByteArrayInputStream(s.getBytes());
    return parse(i,vars);
  }

  /** Create an Expression from a String like "x+y*sin(z)". 
   * Variables are not accessible.
   * @param s a string 
   * @return the Expression
   */
  public static Expression parse(String s) throws ParseException {
    InputStream i=new ByteArrayInputStream(s.getBytes());
    return parse(i,null);
  }

  /** Create an Expression reading a text from a stream. The text can
   * be something like "x+y*sin(z)". Variables are not accessible.
   * @param is a stream
   * @return the Expression
   */
  public static Expression parse(InputStream is) throws ParseException {
    return parse(is,null);
  }

  static final public Expression Input() throws ParseException {
  Expression r=null;
    if (jj_2_1(60)) {
      r = expressionP0();
    } else {
      ;
    }
    label_1:
    while (true) {
      if (jj_2_2(60)) {
        ;
      } else {
        break label_1;
      }
      if (jj_2_3(60)) {
        jj_consume_token(1);
      } else if (jj_2_4(60)) {
        jj_consume_token(2);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(0);
    {if (true) return r;}
    throw new Error("Missing return statement in function");
  }

  static final public Expression expressionP0() throws ParseException {
  Expression[] arg; Expression argb;
    if (jj_2_5(60)) {
      arg = expressionP0l();
    if (arg.length==1) {if (true) return arg[0];}
    else {if (true) return new Sum(arg[0],arg[1]);}
    } else if (jj_2_6(60)) {
      argb = expressionP1();
    {if (true) return argb;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  static final public Expression[] expressionP0l() throws ParseException {
  Expression arga=null; Expression argb[]=null;
    if (jj_2_7(60)) {
      arga = expressionP1();
      jj_consume_token(3);
      argb = expressionP0l();
    if (argb.length==2) {if (true) return new Expression[] {arga,new Sum(argb[0],argb[1])};}
    else {if (true) return new Expression[] {arga,argb[0]};}
    } else if (jj_2_8(60)) {
      arga = expressionP1();
      jj_consume_token(4);
      argb = expressionP0l();
    Expression b0neg=Expression.negative(argb[0]);
    if (argb.length==2) {if (true) return new Expression[] {arga,new Sum(b0neg,argb[1])};}
    else {if (true) return new Expression[] {arga,b0neg};}
    } else if (jj_2_9(60)) {
      arga = expressionP1();
    {if (true) return new Expression[] {arga};}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  static final public Expression expressionP1() throws ParseException {
  Expression[] arg; Expression argb;
    if (jj_2_10(60)) {
      arg = expressionP1l();
    if (arg.length==1) {if (true) return arg[0];}
    else {if (true) return new Product(arg[0],arg[1]);}
    } else if (jj_2_11(60)) {
      argb = expressionP2();
    {if (true) return argb;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  static final public Expression[] expressionP1l() throws ParseException {
  Expression arga=null; Expression argb[]=null;
    if (jj_2_12(60)) {
      arga = expressionP2();
      jj_consume_token(5);
      argb = expressionP1l();
    if (argb.length==2) {if (true) return new Expression[] {arga,new Product(argb[0],argb[1])};}
    else {if (true) return new Expression[] {arga,argb[0]};}
    } else if (jj_2_13(60)) {
      arga = expressionP2();
      jj_consume_token(6);
      argb = expressionP1l();
    Expression b0inv=Expression.inverse(argb[0]);
    if (argb.length==2) {if (true) return new Expression[] {arga,new Product(b0inv,argb[1])};}
    else {if (true) return new Expression[] {arga,b0inv};}
    } else if (jj_2_14(60)) {
      arga = expressionP2();
    {if (true) return new Expression[] {arga};}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  static final public Expression expressionP2() throws ParseException {
  Expression arg=null;
    if (jj_2_15(60)) {
      jj_consume_token(4);
      arg = expressionP3();
    {if (true) return Expression.negative(arg);}
    } else if (jj_2_16(60)) {
      jj_consume_token(3);
      arg = expressionP3();
    {if (true) return arg;}
    } else if (jj_2_17(60)) {
      arg = expressionP3();
    {if (true) return arg;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  static final public Expression expressionP3() throws ParseException {
  Expression arga=null; Token f;
    if (jj_2_18(60)) {
      arga = expressionP4();
      jj_consume_token(7);
      f = jj_consume_token(INUM);
    {if (true) return new Power(arga,Integer.parseInt(f.toString()));}
    } else if (jj_2_19(60)) {
      arga = expressionP4();
    {if (true) return arga;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  static final public Expression expressionP4() throws ParseException {
  Token f; Expression arg=null;
    if (jj_2_20(60)) {
      f = jj_consume_token(DNUM);
    {if (true) return new Constant(new MathDouble(Double.parseDouble(f.toString())));}
    } else if (jj_2_21(60)) {
      f = jj_consume_token(INUM);
    {if (true) return new Constant(new MathDouble(Integer.parseInt(f.toString())));}
    } else if (jj_2_22(60)) {
      f = jj_consume_token(IDENTIFIER);
    Variable v=(Variable)variables.get(f.toString());
    if (v==null)
        v=new Variable(f.toString(),RealField.getInstance());
    variables.put(f.toString(),v);
    {if (true) return v;}
    } else if (jj_2_23(60)) {
      f = jj_consume_token(PI);
    {if (true) return new Constant(RealField.PI);}
    } else if (jj_2_24(60)) {
      f = jj_consume_token(IUNIT);
    {if (true) return new Constant(Complex.I);}
    } else if (jj_2_25(60)) {
      f = jj_consume_token(ONEARGFUNCTION);
      jj_consume_token(8);
      arg = expressionP0();
      jj_consume_token(9);
    {if (true) return new Function(f.toString(),arg);}
    } else if (jj_2_26(60)) {
      jj_consume_token(8);
      arg = expressionP0();
      jj_consume_token(9);
    {if (true) return arg;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  static final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  static final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  static final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  static final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  static final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  static final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  static final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  static final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  static final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  static final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  static final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  static final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  static final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  static final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  static final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  static final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  static final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  static final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  static final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  static final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  static final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  static final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  static final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  static final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  static final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  static final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  static final private boolean jj_3_11() {
    if (jj_3R_6()) return true;
    return false;
  }

  static final private boolean jj_3R_4() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3_11()) return true;
    }
    return false;
  }

  static final private boolean jj_3_10() {
    if (jj_3R_5()) return true;
    return false;
  }

  static final private boolean jj_3_19() {
    if (jj_3R_8()) return true;
    return false;
  }

  static final private boolean jj_3R_7() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_18()) {
    jj_scanpos = xsp;
    if (jj_3_19()) return true;
    }
    return false;
  }

  static final private boolean jj_3_18() {
    if (jj_3R_8()) return true;
    if (jj_scan_token(7)) return true;
    if (jj_scan_token(INUM)) return true;
    return false;
  }

  static final private boolean jj_3_9() {
    if (jj_3R_4()) return true;
    return false;
  }

  static final private boolean jj_3_4() {
    if (jj_scan_token(2)) return true;
    return false;
  }

  static final private boolean jj_3_17() {
    if (jj_3R_7()) return true;
    return false;
  }

  static final private boolean jj_3_8() {
    if (jj_3R_4()) return true;
    if (jj_scan_token(4)) return true;
    if (jj_3R_3()) return true;
    return false;
  }

  static final private boolean jj_3_16() {
    if (jj_scan_token(3)) return true;
    if (jj_3R_7()) return true;
    return false;
  }

  static final private boolean jj_3_3() {
    if (jj_scan_token(1)) return true;
    return false;
  }

  static final private boolean jj_3_2() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3_4()) return true;
    }
    return false;
  }

  static final private boolean jj_3R_6() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3_17()) return true;
    }
    }
    return false;
  }

  static final private boolean jj_3_15() {
    if (jj_scan_token(4)) return true;
    if (jj_3R_7()) return true;
    return false;
  }

  static final private boolean jj_3R_3() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3_9()) return true;
    }
    }
    return false;
  }

  static final private boolean jj_3_26() {
    if (jj_scan_token(8)) return true;
    if (jj_3R_2()) return true;
    if (jj_scan_token(9)) return true;
    return false;
  }

  static final private boolean jj_3_7() {
    if (jj_3R_4()) return true;
    if (jj_scan_token(3)) return true;
    if (jj_3R_3()) return true;
    return false;
  }

  static final private boolean jj_3_25() {
    if (jj_scan_token(ONEARGFUNCTION)) return true;
    if (jj_scan_token(8)) return true;
    if (jj_3R_2()) return true;
    if (jj_scan_token(9)) return true;
    return false;
  }

  static final private boolean jj_3_24() {
    if (jj_scan_token(IUNIT)) return true;
    return false;
  }

  static final private boolean jj_3_14() {
    if (jj_3R_6()) return true;
    return false;
  }

  static final private boolean jj_3_6() {
    if (jj_3R_4()) return true;
    return false;
  }

  static final private boolean jj_3_23() {
    if (jj_scan_token(PI)) return true;
    return false;
  }

  static final private boolean jj_3R_2() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3_6()) return true;
    }
    return false;
  }

  static final private boolean jj_3_5() {
    if (jj_3R_3()) return true;
    return false;
  }

  static final private boolean jj_3_13() {
    if (jj_3R_6()) return true;
    if (jj_scan_token(6)) return true;
    if (jj_3R_5()) return true;
    return false;
  }

  static final private boolean jj_3R_5() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3_14()) return true;
    }
    }
    return false;
  }

  static final private boolean jj_3_22() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_1() {
    if (jj_3R_2()) return true;
    return false;
  }

  static final private boolean jj_3_12() {
    if (jj_3R_6()) return true;
    if (jj_scan_token(5)) return true;
    if (jj_3R_5()) return true;
    return false;
  }

  static final private boolean jj_3_21() {
    if (jj_scan_token(INUM)) return true;
    return false;
  }

  static final private boolean jj_3R_8() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3_21()) {
    jj_scanpos = xsp;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    if (jj_3_25()) {
    jj_scanpos = xsp;
    if (jj_3_26()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  static final private boolean jj_3_20() {
    if (jj_scan_token(DNUM)) return true;
    return false;
  }

  static private boolean jj_initialized_once = false;
  static public ExpressionParserTokenManager token_source;
  static SimpleCharStream jj_input_stream;
  static public Token token, jj_nt;
  static private int jj_ntk;
  static private Token jj_scanpos, jj_lastpos;
  static private int jj_la;
  static public boolean lookingAhead = false;
  static private boolean jj_semLA;
  static private int jj_gen;
  static final private int[] jj_la1 = new int[0];
  static private int[] jj_la1_0;
  static {
      jj_la1_0();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {};
   }
  static final private JJCalls[] jj_2_rtns = new JJCalls[26];
  static private boolean jj_rescan = false;
  static private int jj_gc = 0;

  public ExpressionParser(java.io.InputStream stream) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  You must");
      System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ExpressionParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  static public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public ExpressionParser(java.io.Reader stream) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  You must");
      System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ExpressionParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  static public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public ExpressionParser(ExpressionParserTokenManager tm) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  You must");
      System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(ExpressionParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  static final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  static final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  static final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  static final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  static final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  static final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  static private java.util.Vector jj_expentries = new java.util.Vector();
  static private int[] jj_expentry;
  static private int jj_kind = -1;
  static private int[] jj_lasttokens = new int[100];
  static private int jj_endpos;

  static private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  static public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[19];
    for (int i = 0; i < 19; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 0; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 19; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  static final public void enable_tracing() {
  }

  static final public void disable_tracing() {
  }

  static final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 26; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  static final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
