/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.Utils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import java.lang.reflect.Array;
import java.util.ArrayList;

public abstract class AbstractArrayProvider
extends AbstractSource {
    private static final long serialVersionUID = -6681853409971243043L;
    protected ArrayList m_Queue;
    protected boolean m_OutputArray;
    protected int m_Index;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-array", "outputArray", false);
    }

    protected abstract Class getItemClass();

    public void setOutputArray(boolean value) {
        this.m_OutputArray = value;
        this.reset();
    }

    public boolean getOutputArray() {
        return this.m_OutputArray;
    }

    public abstract String outputArrayTipText();

    @Override
    public Class[] generates() {
        Class[] result;
        if (this.m_OutputArray) {
            Object array = Array.newInstance(this.getItemClass(), 0);
            result = new Class[]{array.getClass()};
        } else {
            result = new Class[]{this.getItemClass()};
        }
        return result;
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Queue = new ArrayList();
        this.m_Index = 0;
    }

    @Override
    protected String preExecute() {
        String result = super.preExecute();
        this.m_Index = 0;
        return result;
    }

    @Override
    public Token output() {
        Token result;
        if (this.m_OutputArray) {
            Object array = Array.newInstance(this.getItemClass(), this.m_Queue.size());
            for (int i = 0; i < this.m_Queue.size(); ++i) {
                Array.set(array, i, this.m_Queue.get(i));
            }
            result = new Token(array);
            this.m_Queue.clear();
        } else {
            result = new Token(this.m_Queue.get(this.m_Index));
            ++this.m_Index;
            if (this.m_Index >= this.m_Queue.size()) {
                this.m_Queue.clear();
                this.m_Index = 0;
            }
        }
        if (this.isDebugOn()) {
            if (this.m_OutputArray) {
                this.debug("Array: " + Utils.arrayToString(result.getPayload()));
            } else {
                this.debug("Element: " + result.getPayload());
            }
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Queue.size() > 0;
    }

    @Override
    public void wrapUp() {
        super.wrapUp();
        this.m_Queue = null;
    }
}

