/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.gui.visualization.core.AbstractPaintlet;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;

public abstract class AbstractStrokePaintlet
extends AbstractPaintlet {
    private static final long serialVersionUID = 1704075176011969771L;
    protected float m_StrokeThickness;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("stroke-thickness", "strokeThickness", Float.valueOf(1.0f), Float.valueOf(0.01f), null);
    }

    public void setStrokeThickness(float value) {
        this.m_StrokeThickness = value;
        this.memberChanged();
    }

    public String strokeThicknessTipText() {
        return "The thickness of the stroke.";
    }

    public float getStrokeThickness() {
        return this.m_StrokeThickness;
    }

    @Override
    public void paint(Graphics g) {
        if (this.isEnabled() && this.hasPanel()) {
            Graphics2D g2d = null;
            float width = 1.0f;
            if (g instanceof Graphics2D) {
                g2d = (Graphics2D)g;
                if (g2d.getStroke() instanceof BasicStroke) {
                    width = ((BasicStroke)g2d.getStroke()).getLineWidth();
                }
                g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
            }
            this.performPaint(g);
            if (g2d != null) {
                g2d.setStroke(new BasicStroke(width));
            }
        }
    }
}

