/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.parser.AbstractExpressionEvaluator;
import adams.parser.GrammarSupplier;
import adams.parser.actorsuggestion.Parser;
import adams.parser.actorsuggestion.Scanner;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java_cup.runtime.DefaultSymbolFactory;
import java_cup.runtime.SymbolFactory;

public class ActorSuggestion
extends AbstractExpressionEvaluator<AbstractActor>
implements GrammarSupplier {
    private static final long serialVersionUID = -2060968616326323959L;
    protected AbstractActor m_Parent;
    protected int m_Position;
    protected AbstractActor[] m_Actors;

    @Override
    public String globalInfo() {
        return "Evaluates rules for suggesting actors.\n\nIt uses the following grammar:\n\n" + this.getGrammar();
    }

    @Override
    public String getGrammar() {
        return " expr_list ::= expr_list expr_part | expr_part ;\n expr_part ::= boolexpr : <classname | \"classname+options\">;\n\n boolexpr ::=    ( boolean )\n               | boolean\n               | boolexpr AND boolexpr\n               | boolexpr OR boolexpr\n               | TRUE\n               | FALSE\n               | NOT boolexpr\n               | ISFIRST\n               | ISLAST\n               | PARENT IS <classname>\n               | BEFORE STANDALONE\n               | AFTER STANDALONE\n               | BEFORE SOURCE\n               | AFTER SOURCE\n               | BEFORE TRANSFORMER\n               | AFTER TRANSFORMER\n               | BEFORE SINK\n               | AFTER SINK\n               | BEFORE <classname>\n               | AFTER <classname>\n               ;\n";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("parent", "parent", new Flow());
        this.m_OptionManager.add("position", "position", 0, 0, null);
        this.m_OptionManager.add("actor", "actors", new AbstractActor[0]);
    }

    @Override
    protected String getDefaultExpression() {
        return "ISFIRST: adams.flow.standalone.GlobalActors";
    }

    @Override
    public String expressionTipText() {
        return "The rule for determining the actor to propose (result is null if rul does not apply).";
    }

    public void setParent(AbstractActor value) {
        this.m_Parent = value;
    }

    public AbstractActor getParent() {
        return this.m_Parent;
    }

    public String parentTipText() {
        return "The parent actor to use.";
    }

    public void setPosition(int value) {
        this.m_Position = value;
    }

    public int getPosition() {
        return this.m_Position;
    }

    public String positionTipText() {
        return "The position to add the proposed actor at.";
    }

    public void setActors(AbstractActor[] value) {
        this.m_Actors = value;
    }

    public AbstractActor[] getActors() {
        return this.m_Actors;
    }

    public String actorsTipText() {
        return "The actors to insert the proposed actor in.";
    }

    @Override
    public AbstractActor evaluate() throws Exception {
        DefaultSymbolFactory sf = new DefaultSymbolFactory();
        ByteArrayInputStream parserInput = new ByteArrayInputStream(this.m_Expression.getBytes());
        Parser parser = new Parser(new Scanner(parserInput, (SymbolFactory)sf), (SymbolFactory)sf);
        parser.setParent(this.getParent());
        parser.setPosition(this.getPosition());
        parser.setActors(this.getActors());
        parser.parse();
        return parser.getResult();
    }

    public static AbstractActor evaluate(String expr, AbstractActor parent, int position, AbstractActor[] actors) throws Exception {
        AbstractActor[] result = ActorSuggestion.evaluate(new String[]{expr}, parent, position, actors);
        return result[0];
    }

    public static AbstractActor[] evaluate(String[] expr, AbstractActor parent, int position, AbstractActor[] actors) throws Exception {
        ActorSuggestion suggestion = new ActorSuggestion();
        suggestion.setParent(parent);
        suggestion.setPosition(position);
        suggestion.setActors(actors);
        ArrayList<AbstractActor> result = new ArrayList<AbstractActor>();
        for (int i = 0; i < expr.length; ++i) {
            suggestion.setExpression(expr[i]);
            AbstractActor actor = suggestion.evaluate();
            if (actor == null || result.contains(actor)) continue;
            result.add(actor);
        }
        return result.toArray(new AbstractActor[result.size()]);
    }
}

