/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.mapmatrix;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ujmp.core.Matrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapMatrix<K, V>
extends AbstractDenseObjectMatrix2D
implements MapMatrix<K, V> {
    private static final long serialVersionUID = 5571429371462164416L;

    public abstract Map<K, V> getMap();

    @Override
    public final long[] getSize() {
        return new long[]{this.size(), 2L};
    }

    @Override
    public final Object getObject(long row, long column) {
        return this.getObject((int)row, (int)column);
    }

    @Override
    public final Object getObject(int row, int column) {
        Object mapKey = this.getKey(row);
        if (column == 0) {
            return mapKey;
        }
        if (column == 1) {
            return mapKey == null ? null : this.getMap().get(mapKey);
        }
        return null;
    }

    @Override
    public final void setObject(Object key, long row, long column) {
    }

    @Override
    public final void setObject(Object key, int row, int column) {
    }

    @Override
    public abstract MapMatrix<K, V> copy();

    private final Object getKey(int index) {
        if (this.getMap() instanceof List) {
            return ((List)((Object)this.getMap())).get(index);
        }
        Iterator<K> it = this.keySet().iterator();
        int i = 0;
        while (it.hasNext() && i < index) {
            it.next();
            ++i;
        }
        return it.hasNext() ? it.next() : null;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.getMap().containsValue(value);
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return this.getMap().entrySet();
    }

    @Override
    public final V get(Object key) {
        return this.getMap().get(key);
    }

    @Override
    public final boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public final Set<K> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public final V put(K key, V value) {
        V v = this.getMap().put(key, value);
        this.notifyGUIObject();
        return v;
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        this.getMap().putAll(m);
        this.notifyGUIObject();
    }

    @Override
    public final V remove(Object key) {
        V v = this.getMap().remove(key);
        this.notifyGUIObject();
        return v;
    }

    @Override
    public final int size() {
        return this.getMap().size();
    }

    @Override
    public final Collection<V> values() {
        return this.getMap().values();
    }

    @Override
    public final Matrix.StorageType getStorageType() {
        return Matrix.StorageType.MAP;
    }

    @Override
    public final void clear() {
        this.getMap().clear();
    }
}

