/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.util.HashSet;
import java.util.Set;

public class ChainedArgs
implements IArgs {
    private IArgs args;
    private IArgs fallbackArgs;

    public ChainedArgs(IArgs args, IArgs fallbackArgs) {
        this.args = args;
        this.fallbackArgs = fallbackArgs;
    }

    public void add(Object object) {
        this.args.add(object);
    }

    public void clear() {
        this.args.clear();
    }

    public Object get(int index) {
        Object fallbackResult;
        Object result = this.args.get(index);
        if (result == null) {
            return this.fallbackArgs.get(index);
        }
        if (result instanceof IArgs && (fallbackResult = this.fallbackArgs.get(index)) instanceof IArgs) {
            return new ChainedArgs((IArgs)result, (IArgs)fallbackResult);
        }
        return result;
    }

    public Object get(int index, Object defaultValue) {
        Object fallbackResult;
        Object result = this.args.get(index);
        if (result == null) {
            return this.fallbackArgs.get(index, defaultValue);
        }
        if (result instanceof IArgs && (fallbackResult = this.fallbackArgs.get(index)) instanceof IArgs) {
            return new ChainedArgs((IArgs)result, (IArgs)fallbackResult);
        }
        return result;
    }

    public Object get(String name) {
        Object fallbackResult;
        Object result = this.args.get(name);
        if (result == null) {
            if (!this.args.isDefined(name)) {
                result = this.fallbackArgs.get(name);
            }
        } else if (result instanceof IArgs && (fallbackResult = this.fallbackArgs.get(name)) instanceof IArgs) {
            result = new ChainedArgs((IArgs)result, (IArgs)fallbackResult);
        }
        return result;
    }

    public Object get(String name, Object defaultValue) {
        Object fallbackResult;
        Object result = this.args.get(name);
        if (result == null) {
            if (!this.args.isDefined(name)) {
                result = this.fallbackArgs.get(name, defaultValue);
            }
        } else if (result instanceof IArgs && (fallbackResult = this.fallbackArgs.get(name)) instanceof IArgs) {
            result = new ChainedArgs((IArgs)result, (IArgs)fallbackResult);
        }
        return result;
    }

    public IArgs getArgs() {
        return this.args;
    }

    public IArgs getFallbackArgs() {
        return this.fallbackArgs;
    }

    public boolean isDefined(int index) {
        if (this.args.isDefined(index)) {
            return true;
        }
        return this.fallbackArgs.isDefined(index);
    }

    public boolean isDefined(String name) {
        if (this.args.isDefined(name)) {
            return true;
        }
        return this.fallbackArgs.isDefined(name);
    }

    public boolean isIndexed() {
        return this.args.isIndexed() || this.fallbackArgs.isIndexed();
    }

    public boolean isNamed() {
        return this.args.isNamed() || this.fallbackArgs.isNamed();
    }

    public Set names() {
        HashSet<String> names = new HashSet<String>(this.args.names());
        names.addAll(this.fallbackArgs.names());
        return names;
    }

    public void put(int index, Object value) {
        this.args.put(index, value);
    }

    public void put(String name, Object value) {
        this.args.put(name, value);
    }

    public int size() {
        if (this.isIndexed()) {
            return Math.max(this.args.size(), this.fallbackArgs.size());
        }
        return this.names().size();
    }

    public String toString() {
        return ArgTools.toString(this, "");
    }
}

