/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.colt;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import java.util.HashSet;
import java.util.Iterator;
import org.ujmp.colt.ColtDenseDoubleMatrix2D;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractSparseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.util.CoordinateSetToLongWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColtSparseDoubleMatrix2D
extends AbstractSparseDoubleMatrix2D
implements Wrapper<SparseDoubleMatrix2D> {
    private static final long serialVersionUID = -3223474248020842822L;
    private SparseDoubleMatrix2D matrix = null;

    public ColtSparseDoubleMatrix2D(long ... size) {
        this.matrix = new SparseDoubleMatrix2D((int)size[0], (int)size[1]);
    }

    public ColtSparseDoubleMatrix2D(SparseDoubleMatrix2D m) {
        this.matrix = m;
    }

    public ColtSparseDoubleMatrix2D(Matrix source) throws MatrixException {
        this(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            this.setDouble(source.getAsDouble(c), c);
        }
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.getQuick((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.getQuick(row, column);
    }

    @Override
    public long[] getSize() {
        return new long[]{this.matrix.rows(), this.matrix.columns()};
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.setQuick((int)row, (int)column, value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.setQuick(row, column, value);
    }

    @Override
    public SparseDoubleMatrix2D getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(SparseDoubleMatrix2D object) {
        this.matrix = object;
    }

    @Override
    public Matrix inv() {
        return new ColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)new Algebra().inverse((DoubleMatrix2D)this.matrix));
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return new AvailableCoordinateIterable();
    }

    @Override
    public final boolean contains(long ... coordinates) {
        return this.getAsDouble(coordinates) != 0.0;
    }

    @Override
    public Matrix transpose() {
        return new ColtSparseDoubleMatrix2D((SparseDoubleMatrix2D)this.matrix.viewDice().copy());
    }

    @Override
    public Matrix plus(double value) {
        return new ColtSparseDoubleMatrix2D((SparseDoubleMatrix2D)this.matrix.copy().assign(Functions.plus((double)value)));
    }

    @Override
    public Matrix times(double value) {
        return new ColtSparseDoubleMatrix2D((SparseDoubleMatrix2D)this.matrix.copy().assign(Functions.mult((double)value)));
    }

    @Override
    public Matrix copy() {
        ColtSparseDoubleMatrix2D m = new ColtSparseDoubleMatrix2D((SparseDoubleMatrix2D)this.matrix.copy());
        if (this.getAnnotation() != null) {
            m.setAnnotation(this.getAnnotation().clone());
        }
        return m;
    }

    @Override
    public Matrix mtimes(Matrix m) {
        if (m instanceof ColtSparseDoubleMatrix2D) {
            SparseDoubleMatrix2D ret = new SparseDoubleMatrix2D((int)this.getRowCount(), (int)m.getColumnCount());
            this.matrix.zMult((DoubleMatrix2D)((ColtSparseDoubleMatrix2D)m).matrix, (DoubleMatrix2D)ret);
            return new ColtSparseDoubleMatrix2D(ret);
        }
        return super.mtimes(m);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AvailableCoordinateIterable
    implements Iterable<long[]> {
        AvailableCoordinateIterable() {
        }

        @Override
        public Iterator<long[]> iterator() {
            HashSet<Coordinates> cset = new HashSet<Coordinates>();
            long r = ColtSparseDoubleMatrix2D.this.getRowCount() - 1L;
            while (r >= 0L) {
                long c = ColtSparseDoubleMatrix2D.this.getColumnCount() - 1L;
                while (c >= 0L) {
                    if (ColtSparseDoubleMatrix2D.this.getDouble(r, c) != 0.0) {
                        cset.add(new Coordinates(r, c));
                    }
                    --c;
                }
                --r;
            }
            return new CoordinateSetToLongWrapper(cset).iterator();
        }
    }
}

