/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.MinusScalar;
import org.ujmp.core.calculation.MinusScalarCalculation;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.SparseMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MinusScalarMatrix
implements MinusScalarCalculation<Matrix, Matrix> {
    MinusScalarMatrix() {
    }

    @Override
    public final void calc(Matrix source, BigDecimal value, Matrix target) {
        if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
            MinusScalar.DENSEMATRIX.calc((DenseMatrix)source, value, (DenseMatrix)target);
        } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
            MinusScalar.SPARSEMATRIX.calc((SparseMatrix)source, value, (SparseMatrix)target);
        } else {
            VerifyUtil.assertSameSize(source, target);
            for (long[] c : source.allCoordinates()) {
                BigDecimal svalue = source.getAsBigDecimal(c);
                BigDecimal result = MathUtil.minus(svalue, value);
                target.setAsBigDecimal(result, c);
            }
        }
    }

    @Override
    public final void calc(Matrix source, double value, Matrix target) {
        if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
            MinusScalar.DENSEMATRIX.calc((DenseMatrix)source, value, (DenseMatrix)target);
        } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
            MinusScalar.SPARSEMATRIX.calc((SparseMatrix)source, value, (SparseMatrix)target);
        } else {
            this.calc(source, new BigDecimal(value, MathUtil.getDefaultMathContext()), target);
        }
    }
}

