/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.calculation.PlusMatrix;
import org.ujmp.core.calculation.PlusMatrixCalculation;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.DenseMatrix2D;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlusMatrixDenseMatrix
implements PlusMatrixCalculation<DenseMatrix, DenseMatrix, DenseMatrix> {
    PlusMatrixDenseMatrix() {
    }

    @Override
    public final void calc(DenseMatrix source1, DenseMatrix source2, DenseMatrix target) {
        if (source1 instanceof DenseMatrix2D && source2 instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            PlusMatrix.DENSEMATRIX2D.calc((DenseMatrix2D)source1, (DenseMatrix2D)source2, (DenseMatrix2D)target);
        } else {
            VerifyUtil.assertSameSize(source1, source2, target);
            for (long[] c : source1.allCoordinates()) {
                BigDecimal v1 = source1.getAsBigDecimal(c);
                BigDecimal v2 = source2.getAsBigDecimal(c);
                BigDecimal result = MathUtil.plus(v1, v2);
                target.setAsBigDecimal(result, c);
            }
        }
    }
}

