/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.decomposition;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.general.decomposition.LU;
import org.ujmp.core.doublematrix.calculation.general.decomposition.QR;
import org.ujmp.core.util.DecompositionOps;
import org.ujmp.core.util.UJMPSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Solve<T> {
    public static final int SQUARETHRESHOLD = 100;
    public static final int TALLTHRESHOLD = 100;
    public static final Solve<Matrix> MATRIX = new Solve<Matrix>(){

        @Override
        public final Matrix calc(Matrix a, Matrix b) {
            if (a.isSquare()) {
                if (UJMPSettings.getNumberOfThreads() == 1) {
                    if (a.getRowCount() >= 100L && a.getColumnCount() >= 100L) {
                        return MATRIXSQUARELARGESINGLETHREADED.calc(a, b);
                    }
                    return MATRIXSQUARESMALLSINGLETHREADED.calc(a, b);
                }
                if (a.getRowCount() >= 100L && a.getColumnCount() >= 100L) {
                    return MATRIXSQUARELARGEMULTITHREADED.calc(a, b);
                }
                return MATRIXSQUARESMALLMULTITHREADED.calc(a, b);
            }
            if (UJMPSettings.getNumberOfThreads() == 1) {
                if (a.getRowCount() >= 100L && a.getColumnCount() >= 100L) {
                    return MATRIXTALLLARGESINGLETHREADED.calc(a, b);
                }
                return MATRIXTALLSMALLSINGLETHREADED.calc(a, b);
            }
            if (a.getRowCount() >= 100L && a.getColumnCount() >= 100L) {
                return MATRIXTALLLARGEMULTITHREADED.calc(a, b);
            }
            return MATRIXTALLSMALLMULTITHREADED.calc(a, b);
        }
    };
    public static final Solve<Matrix> INSTANCE = MATRIX;
    public static final Solve<Matrix> UJMPSQUARE = new Solve<Matrix>(){

        @Override
        public final Matrix calc(Matrix a, Matrix b) {
            return LU.INSTANCE.solve(a, b);
        }
    };
    public static final Solve<Matrix> UJMPTALL = new Solve<Matrix>(){

        @Override
        public final Matrix calc(Matrix a, Matrix b) {
            return QR.INSTANCE.solve(a, b);
        }
    };
    public static final Solve<Matrix> MATRIXSQUARESMALLSINGLETHREADED = UJMPSQUARE;
    public static final Solve<Matrix> MATRIXTALLSMALLSINGLETHREADED = UJMPTALL;
    public static final Solve<Matrix> MATRIXSQUARELARGESINGLETHREADED = new Solve<Matrix>(){

        @Override
        public final Matrix calc(Matrix a, Matrix b) {
            Solve solve = null;
            if (UJMPSettings.isUseJBlas()) {
                solve = DecompositionOps.SOLVE_JBLAS;
            }
            if (solve == null && UJMPSettings.isUseOjalgo()) {
                solve = DecompositionOps.SOLVE_OJALGO;
            }
            if (solve == null && UJMPSettings.isUseEJML()) {
                solve = DecompositionOps.SOLVE_EJML;
            }
            if (solve == null && UJMPSettings.isUseMTJ()) {
                solve = DecompositionOps.SOLVE_MTJ;
            }
            if (solve == null) {
                solve = UJMPSQUARE;
            }
            return solve.calc(a, b);
        }
    };
    public static final Solve<Matrix> MATRIXTALLLARGESINGLETHREADED = new Solve<Matrix>(){

        @Override
        public final Matrix calc(Matrix a, Matrix b) {
            Solve solve = null;
            if (UJMPSettings.isUseOjalgo()) {
                solve = DecompositionOps.SOLVE_OJALGO;
            }
            if (solve == null && UJMPSettings.isUseEJML()) {
                solve = DecompositionOps.SOLVE_EJML;
            }
            if (solve == null && UJMPSettings.isUseMTJ()) {
                solve = DecompositionOps.SOLVE_MTJ;
            }
            if (solve == null) {
                solve = UJMPTALL;
            }
            return solve.calc(a, b);
        }
    };
    public static final Solve<Matrix> MATRIXSQUARELARGEMULTITHREADED = new Solve<Matrix>(){

        @Override
        public Matrix calc(Matrix a, Matrix b) {
            Solve solve = null;
            if (UJMPSettings.isUseJBlas()) {
                solve = DecompositionOps.SOLVE_JBLAS;
            }
            if (solve == null && UJMPSettings.isUseOjalgo()) {
                solve = DecompositionOps.SOLVE_OJALGO;
            }
            if (solve == null && UJMPSettings.isUseEJML()) {
                solve = DecompositionOps.SOLVE_EJML;
            }
            if (solve == null) {
                solve = UJMPSQUARE;
            }
            return solve.calc(a, b);
        }
    };
    public static final Solve<Matrix> MATRIXTALLLARGEMULTITHREADED = new Solve<Matrix>(){

        @Override
        public Matrix calc(Matrix a, Matrix b) {
            Solve solve = null;
            if (UJMPSettings.isUseParallelColt()) {
                solve = DecompositionOps.SOLVE_PARALLELCOLT;
            }
            if (UJMPSettings.isUseOjalgo()) {
                solve = DecompositionOps.SOLVE_OJALGO;
            }
            if (solve == null && UJMPSettings.isUseEJML()) {
                solve = DecompositionOps.SOLVE_EJML;
            }
            if (solve == null) {
                solve = UJMPTALL;
            }
            return solve.calc(a, b);
        }
    };
    public static final Solve<Matrix> MATRIXSQUARESMALLMULTITHREADED = UJMPSQUARE;
    public static final Solve<Matrix> MATRIXTALLSMALLMULTITHREADED = UJMPTALL;

    public T calc(T var1, T var2);
}

