/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.intmatrix.calculation;

import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.intmatrix.calculation.AbstractIntCalculation;
import org.ujmp.core.util.UJMPSettings;

public class DiscretizeStandardBinning
extends AbstractIntCalculation {
    private static final long serialVersionUID = -2045926868254834270L;
    private Matrix min = null;
    private Matrix max = null;
    private int numberOfBins = 3;

    public DiscretizeStandardBinning(int dimension, Matrix matrix, int numberOfBins) {
        super(dimension, matrix);
        this.numberOfBins = numberOfBins;
    }

    public int getInt(long ... coordinates) throws MatrixException {
        if (this.min == null || this.max == null) {
            this.calculate();
        }
        double v = this.getSource().getAsDouble(coordinates);
        double mi = 0.0;
        double ma = 0.0;
        switch (this.getDimension()) {
            case 0: {
                mi = this.min.getAsDouble(0L, coordinates[1]);
                ma = this.max.getAsDouble(0L, coordinates[1]) + UJMPSettings.getTolerance();
                break;
            }
            case 1: {
                mi = this.min.getAsDouble(coordinates[0], 0L);
                ma = this.max.getAsDouble(coordinates[0], 0L) + UJMPSettings.getTolerance();
                break;
            }
            default: {
                mi = this.min.getAsDouble(0L, 0L);
                ma = this.max.getAsDouble(0L, 0L) + UJMPSettings.getTolerance();
            }
        }
        double bs = (ma - mi) / (double)this.numberOfBins;
        int i = (int)Math.floor((v - mi) / bs);
        return i;
    }

    private void calculate() {
        this.min = this.getSource().min(Calculation.Ret.NEW, this.getDimension());
        this.max = this.getSource().max(Calculation.Ret.NEW, this.getDimension());
    }
}

