/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.plot;

import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.ListSelectionModel;
import org.ujmp.gui.plot.PlotSettings;

public class Selection {
    private PlotSettings plotSettings = null;

    public Selection(PlotSettings plotSettings) {
        this.plotSettings = plotSettings;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        ListSelectionModel lsm = this.plotSettings.getMatrixGUIObject().getRowSelectionModel();
        int min = lsm.getMinSelectionIndex();
        int max = lsm.getMaxSelectionIndex();
        if (min != -1 && max != -1) {
            double xf = this.plotSettings.getXFactor();
            int y1 = 0;
            int y2 = this.plotSettings.getHeight() - 1;
            int h = y2 - y1;
            int x1 = (int)((double)min * xf);
            int x2 = (int)((double)max * xf);
            int w = x2 - x1;
            g2d.setColor(this.plotSettings.getSelectionLineColor());
            g2d.drawLine(x1, y1, x1, y2);
            g2d.drawLine(x2, y1, x2, y2);
            g2d.setColor(this.plotSettings.getSelectionColor());
            if (w != 0) {
                g2d.fillRect(x1, y1, w, h);
            }
        }
    }
}

