/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import moa.core.InstancesHeader;
import moa.core.MiscUtils;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class RandomRBFGenerator
extends AbstractOptionHandler
implements InstanceStream {
    private static final long serialVersionUID = 1L;
    public IntOption modelRandomSeedOption = new IntOption("modelRandomSeed", 'r', "Seed for random generation of model.", 1);
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    public IntOption numClassesOption = new IntOption("numClasses", 'c', "The number of classes to generate.", 2, 2, Integer.MAX_VALUE);
    public IntOption numAttsOption = new IntOption("numAtts", 'a', "The number of attributes to generate.", 10, 0, Integer.MAX_VALUE);
    public IntOption numCentroidsOption = new IntOption("numCentroids", 'n', "The number of centroids in the model.", 50, 1, Integer.MAX_VALUE);
    protected InstancesHeader streamHeader;
    protected Centroid[] centroids;
    protected double[] centroidWeights;
    protected Random instanceRandom;

    public String getPurposeString() {
        return "Generates a random radial basis function stream.";
    }

    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        monitor.setCurrentActivity("Preparing random RBF...", -1.0);
        this.generateHeader();
        this.generateCentroids();
        this.restart();
    }

    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    public long estimatedRemainingInstances() {
        return -1L;
    }

    public boolean hasMoreInstances() {
        return true;
    }

    public boolean isRestartable() {
        return true;
    }

    public void restart() {
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
    }

    public Instance nextInstance() {
        Centroid centroid = this.centroids[MiscUtils.chooseRandomIndexBasedOnWeights(this.centroidWeights, this.instanceRandom)];
        int numAtts = this.numAttsOption.getValue();
        double[] attVals = new double[numAtts + 1];
        for (int i = 0; i < numAtts; ++i) {
            attVals[i] = this.instanceRandom.nextDouble() * 2.0 - 1.0;
        }
        double magnitude = 0.0;
        for (int i = 0; i < numAtts; ++i) {
            magnitude += attVals[i] * attVals[i];
        }
        magnitude = Math.sqrt(magnitude);
        double desiredMag = this.instanceRandom.nextGaussian() * centroid.stdDev;
        double scale = desiredMag / magnitude;
        for (int i = 0; i < numAtts; ++i) {
            attVals[i] = centroid.centre[i] + attVals[i] * scale;
        }
        DenseInstance inst = new DenseInstance(1.0, attVals);
        inst.setDataset((Instances)this.getHeader());
        inst.setClassValue((double)centroid.classLabel);
        return inst;
    }

    protected void generateHeader() {
        FastVector attributes = new FastVector();
        for (int i = 0; i < this.numAttsOption.getValue(); ++i) {
            attributes.addElement((Object)new Attribute("att" + (i + 1)));
        }
        FastVector classLabels = new FastVector();
        for (int i = 0; i < this.numClassesOption.getValue(); ++i) {
            classLabels.addElement((Object)("class" + (i + 1)));
        }
        attributes.addElement((Object)new Attribute("class", (List)classLabels));
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), (ArrayList)attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
    }

    protected void generateCentroids() {
        Random modelRand = new Random(this.modelRandomSeedOption.getValue());
        this.centroids = new Centroid[this.numCentroidsOption.getValue()];
        this.centroidWeights = new double[this.centroids.length];
        for (int i = 0; i < this.centroids.length; ++i) {
            this.centroids[i] = new Centroid();
            double[] randCentre = new double[this.numAttsOption.getValue()];
            for (int j = 0; j < randCentre.length; ++j) {
                randCentre[j] = modelRand.nextDouble();
            }
            this.centroids[i].centre = randCentre;
            this.centroids[i].classLabel = modelRand.nextInt(this.numClassesOption.getValue());
            this.centroids[i].stdDev = modelRand.nextDouble();
            this.centroidWeights[i] = modelRand.nextDouble();
        }
    }

    public void getDescription(StringBuilder sb, int indent) {
    }

    protected static class Centroid
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double[] centre;
        public int classLabel;
        public double stdDev;

        protected Centroid() {
        }
    }
}

