/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map;

import java.text.DateFormat;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonWriteNullProperties;
import org.codehaus.jackson.map.BeanDescription;
import org.codehaus.jackson.map.ClassIntrospector;
import org.codehaus.jackson.map.util.StdDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationConfig {
    protected static final int DEFAULT_FEATURE_FLAGS = Feature.collectDefaults();
    protected ClassIntrospector<? extends BeanDescription> _classIntrospector;
    protected int _featureFlags = DEFAULT_FEATURE_FLAGS;
    protected DateFormat _dateFormat = StdDateFormat.instance;

    public SerializationConfig(ClassIntrospector<? extends BeanDescription> intr) {
        this._classIntrospector = intr;
    }

    protected SerializationConfig(SerializationConfig src) {
        this._classIntrospector = src._classIntrospector;
        this._featureFlags = src._featureFlags;
        this._dateFormat = src._dateFormat;
    }

    public SerializationConfig createUnshared() {
        return new SerializationConfig(this);
    }

    public void fromAnnotations(Class<?> annotatedClass) {
        JsonAutoDetect autoDetect;
        JsonWriteNullProperties nullProps = annotatedClass.getAnnotation(JsonWriteNullProperties.class);
        if (nullProps != null) {
            this.set(Feature.WRITE_NULL_PROPERTIES, nullProps.value());
        }
        if ((autoDetect = annotatedClass.getAnnotation(JsonAutoDetect.class)) != null) {
            boolean set = false;
            for (JsonMethod m : autoDetect.value()) {
                if (!m.setterEnabled()) continue;
                set = true;
                break;
            }
            this.set(Feature.AUTO_DETECT_GETTERS, set);
        }
    }

    public final boolean isEnabled(Feature f) {
        return (this._featureFlags & f.getMask()) != 0;
    }

    public DateFormat getDateFormat() {
        return this._dateFormat;
    }

    public <T extends BeanDescription> T introspect(Class<?> cls) {
        return (T)this._classIntrospector.forSerialization(this, cls);
    }

    public <T extends BeanDescription> T introspectClassAnnotations(Class<?> cls) {
        return (T)this._classIntrospector.forClassAnnotations(cls);
    }

    public void enable(Feature f) {
        this._featureFlags |= f.getMask();
    }

    public void disable(Feature f) {
        this._featureFlags &= ~f.getMask();
    }

    public void set(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
    }

    public void setDateFormat(DateFormat df) {
        this._dateFormat = df;
        this.set(Feature.WRITE_DATES_AS_TIMESTAMPS, df == null);
    }

    public void setIntrospector(ClassIntrospector<? extends BeanDescription> i) {
        this._classIntrospector = i;
    }

    public String toString() {
        return "[SerializationConfig: flags=0x" + Integer.toHexString(this._featureFlags) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        AUTO_DETECT_GETTERS(true),
        CAN_OVERRIDE_ACCESS_MODIFIERS(true),
        WRITE_NULL_PROPERTIES(true),
        WRITE_DATES_AS_TIMESTAMPS(true),
        INDENT_OUTPUT(false);

        final boolean _defaultState;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

