/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.data.DatabaseNotesHandler;
import adams.data.Notes;
import adams.data.NotesHandler;
import adams.data.id.AbstractIDGenerator;
import adams.data.id.SimpleIDGenerator;
import adams.flow.sink.AbstractSink;
import java.io.File;

public class NotesWriter
extends AbstractSink {
    private static final long serialVersionUID = -4977041692875774457L;
    public static final String FILE_EXTENSION = ".txt";
    protected PlaceholderDirectory m_OutputDir;
    protected AbstractIDGenerator m_Generator;
    protected String m_Suffix;
    protected boolean m_OutputDatabaseID;
    protected boolean m_OutputErrors;
    protected boolean m_OutputWarnings;
    protected boolean m_OutputProcessInformation;
    protected boolean m_OutputAll;

    @Override
    public String globalInfo() {
        return "Saves the notes attached to a data structure to a text file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("outputDir", "outputDir", new PlaceholderDirectory("."));
        this.m_OptionManager.add("suffix", "suffix", "");
        this.m_OptionManager.add("generator", "generator", new SimpleIDGenerator());
        this.m_OptionManager.add("output-db-id", "outputDatabaseID", false);
        this.m_OptionManager.add("output-errors", "outputErrors", false);
        this.m_OptionManager.add("output-warnings", "outputWarnings", false);
        this.m_OptionManager.add("output-process-info", "outputProcessInformation", false);
        this.m_OptionManager.add("output-all", "outputAll", false);
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("outputDir");
        if (variable != null) {
            return variable;
        }
        if (this.m_OutputDir != null) {
            return this.m_OutputDir.toString();
        }
        return null;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{NotesHandler.class};
    }

    public void setOutputDir(PlaceholderDirectory value) {
        this.m_OutputDir = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDir() {
        return this.m_OutputDir;
    }

    public String outputDirTipText() {
        return "The output directory for the notes.";
    }

    public void setGenerator(AbstractIDGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractIDGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use for generating the IDs.";
    }

    public void setSuffix(String value) {
        this.m_Suffix = value;
        this.reset();
    }

    public String getSuffix() {
        return this.m_Suffix;
    }

    public String suffixTipText() {
        return "The suffix for the notes filename, before the extension.";
    }

    public void setOutputDatabaseID(boolean value) {
        this.m_OutputDatabaseID = value;
        this.reset();
    }

    public boolean getOutputDatabaseID() {
        return this.m_OutputDatabaseID;
    }

    public String outputDatabaseIDTipText() {
        return "If set to true, then the database ID will be output in the file as well.";
    }

    public void setOutputErrors(boolean value) {
        this.m_OutputErrors = value;
        this.reset();
    }

    public boolean getOutputErrors() {
        return this.m_OutputErrors;
    }

    public String outputErrorsTipText() {
        return "If set to true, then the errors will be output.";
    }

    public void setOutputWarnings(boolean value) {
        this.m_OutputWarnings = value;
        this.reset();
    }

    public boolean getOutputWarnings() {
        return this.m_OutputWarnings;
    }

    public String outputWarningsTipText() {
        return "If set to true, then the warnings will be output.";
    }

    public void setOutputProcessInformation(boolean value) {
        this.m_OutputProcessInformation = value;
        this.reset();
    }

    public boolean getOutputProcessInformation() {
        return this.m_OutputProcessInformation;
    }

    public String outputProcessInformationTipText() {
        return "If set to true, then the process information will be output.";
    }

    public void setOutputAll(boolean value) {
        this.m_OutputAll = value;
        this.reset();
    }

    public boolean getOutputAll() {
        return this.m_OutputAll;
    }

    public String outputAllTipText() {
        return "If set to true, then everything will be output.";
    }

    protected String[] notesToArray(Notes notes) {
        String[] result = null;
        if (notes.size() > 0) {
            result = notes.toString().split("\n");
        }
        return result;
    }

    protected String[] merge(String[] array1, String[] array2) {
        String[] result = null;
        int size = 0;
        if (array1 != null) {
            size += array1.length;
        }
        if (array2 != null) {
            size += array2.length;
        }
        if (size > 0) {
            result = new String[size];
            if (array1 != null) {
                System.arraycopy(array1, 0, result, 0, array1.length);
                if (array2 != null) {
                    System.arraycopy(array2, 0, result, array1.length, array2.length);
                }
            } else {
                System.arraycopy(array2, 0, result, 0, array2.length);
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (this.m_OutputAll || this.m_OutputErrors || this.m_OutputWarnings || this.m_OutputProcessInformation) {
            NotesHandler handler = (NotesHandler)this.m_InputToken.getPayload();
            PlaceholderFile file = new PlaceholderFile(this.m_OutputDir, FileUtils.createFilename(this.m_Generator.generate(handler) + this.m_Suffix + FILE_EXTENSION, "_"));
            String[] allContent = null;
            String[] warnings = null;
            String[] errors = null;
            String[] procInfo = null;
            if (this.m_OutputAll) {
                allContent = this.notesToArray(handler.getNotes());
            } else {
                if (this.m_OutputErrors) {
                    errors = this.notesToArray(handler.getNotes().getErrors());
                }
                if (this.m_OutputWarnings) {
                    warnings = this.notesToArray(handler.getNotes().getWarnings());
                }
                if (this.m_OutputProcessInformation) {
                    procInfo = this.notesToArray(handler.getNotes().getProcessInformation());
                }
                allContent = this.merge(allContent, errors);
                allContent = this.merge(allContent, warnings);
                allContent = this.merge(allContent, procInfo);
            }
            if (allContent != null && handler instanceof DatabaseNotesHandler && this.m_OutputDatabaseID) {
                String[] database = new String[]{"Database ID: " + ((DatabaseNotesHandler)handler).getDatabaseID(), ""};
                allContent = this.merge(database, allContent);
            }
            if (allContent != null && !FileUtils.saveToFile(allContent, (File)file)) {
                result = "Error saving notes to '" + file + "'!";
            }
        }
        return result;
    }
}

