/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.io.PlaceholderFile;
import adams.flow.source.AbstractArrayProvider;
import java.util.ArrayList;

public class MultiFileSupplier
extends AbstractArrayProvider {
    private static final long serialVersionUID = -8288435835502863891L;
    protected PlaceholderFile[] m_Files;

    @Override
    public String globalInfo() {
        return "Supplies multiple files.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file", "files", new PlaceholderFile[0]);
    }

    @Override
    public String getQuickInfo() {
        if (this.m_Files != null) {
            if (this.m_Files.length == 1) {
                return this.m_Files[0].toString();
            }
            return this.m_Files.length + " files";
        }
        return null;
    }

    @Override
    protected Class getItemClass() {
        return String.class;
    }

    public void setFiles(PlaceholderFile[] value) {
        this.m_Files = value;
    }

    public PlaceholderFile[] getFiles() {
        return this.m_Files;
    }

    public String filesTipText() {
        return "The files to supply.";
    }

    @Override
    public String outputArrayTipText() {
        return "Whether to return the files as array or one by one.";
    }

    @Override
    protected String doExecute() {
        this.m_Queue = new ArrayList();
        for (PlaceholderFile file : this.m_Files) {
            this.m_Queue.add(file.getAbsolutePath());
        }
        return null;
    }
}

