/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.container.DataContainer;
import adams.db.AbstractDatabaseConnection;
import adams.db.DataProvider;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public abstract class AbstractDataContainerDbWriter<T extends DataContainer>
extends AbstractTransformer {
    private static final long serialVersionUID = -7382952208593440101L;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DatabaseConnection = this.getDefaultDatabaseConnection();
    }

    protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

    @Override
    public abstract Class[] accepts();

    @Override
    public Class[] generates() {
        return new Class[]{Integer.class};
    }

    protected abstract DataProvider<T> getDataProvider(T var1);

    protected abstract AbstractDatabaseConnection getDatabaseConnection();

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        DataContainer cont = (DataContainer)this.m_InputToken.getPayload();
        DataProvider<DataContainer> provider = this.getDataProvider(cont);
        Integer id = provider.add(cont);
        if (id == null) {
            result = "Error saving container: " + this.m_InputToken;
        } else {
            this.m_OutputToken = new Token(id);
        }
        return result;
    }

    @Override
    public void wrapUp() {
        this.m_DatabaseConnection = null;
        super.wrapUp();
    }
}

