/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.base.BaseDate;
import adams.core.base.BaseObject;
import adams.core.base.BaseTime;
import adams.core.option.AbstractOption;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.freixas.jcalendar.JCalendar;

public class BaseDateEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
MultiSelectionEditor {
    protected JCalendar m_Calendar;
    protected JComboBox m_ComboBoxPlaceholders;
    protected JTextField m_TextCustom;
    protected JButton m_ButtonToday;
    protected JButton m_ButtonOK;
    protected BaseDate m_Date;

    public static String toString(AbstractOption option, Object object) {
        return ((BaseDate)object).getValue();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new BaseDate(str);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Date = new BaseDate();
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return BaseDateEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return BaseDateEditor.valueOf(null, str);
    }

    @Override
    public String getJavaInitializationString() {
        String result = "new " + this.getValue().getClass().getName() + "(\"" + BaseDateEditor.toString(null, this.getValue()) + "\")";
        return result;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getValue() == null ? "null" : BaseDateEditor.toString(null, this.getValue());
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    @Override
    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        panelAll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panelValues = new JPanel(new BorderLayout());
        panelAll.add((Component)panelValues, "Center");
        JPanel panelCustom = new JPanel(new BorderLayout());
        panelValues.add((Component)panelCustom, "South");
        this.m_Calendar = new JCalendar(Calendar.getInstance(), Locale.getDefault(), 1, false, "yyyy-MM-dd");
        panelValues.add((Component)this.m_Calendar, "Center");
        this.m_ComboBoxPlaceholders = new JComboBox<String>(new String[]{"Custom", "Selected", "-INF", "NOW", "+INF"});
        this.m_ComboBoxPlaceholders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = BaseDateEditor.this.m_ComboBoxPlaceholders.getSelectedIndex();
                if (index > 1) {
                    BaseDate date = new BaseDate((String)BaseDateEditor.this.m_ComboBoxPlaceholders.getSelectedItem());
                    BaseDateEditor.this.m_Calendar.setDate(date.dateValue());
                }
                BaseDateEditor.this.m_TextCustom.setEnabled(index == 0);
                BaseDateEditor.this.m_ButtonToday.setEnabled(index == 1);
                BaseDateEditor.this.m_Calendar.setEnabled(index != 1);
                BaseDateEditor.this.m_Calendar.setEnabled(index == 1);
            }
        });
        this.m_ButtonToday = new JButton("Today");
        this.m_ButtonToday.setMnemonic('T');
        this.m_ButtonToday.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseDateEditor.this.m_Calendar.setDate(new BaseTime("NOW").dateValue());
            }
        });
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        panel.add(new JLabel("Type"));
        panel.add(this.m_ComboBoxPlaceholders);
        panel.add(this.m_ButtonToday);
        panelCustom.add((Component)panel, "North");
        this.m_TextCustom = new JTextField(12);
        this.m_TextCustom.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            protected void update() {
                BaseDateEditor.this.updateButtons();
            }
        });
        panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        panel.add(new JLabel("Custom date"));
        panel.add(this.m_TextCustom);
        panelCustom.add((Component)panel, "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        this.m_ButtonOK = new JButton("OK");
        this.m_ButtonOK.setMnemonic('O');
        this.m_ButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = BaseDateEditor.this.m_ComboBoxPlaceholders.getSelectedIndex();
                if (index == 0) {
                    BaseDateEditor.this.setValue(new BaseDate(BaseDateEditor.this.m_TextCustom.getText()));
                } else if (index == 1) {
                    BaseDateEditor.this.setValue(new BaseDate(BaseDateEditor.this.m_Calendar.getDate()));
                } else {
                    BaseDateEditor.this.setValue(new BaseDate((String)BaseDateEditor.this.m_ComboBoxPlaceholders.getSelectedItem()));
                }
                BaseDateEditor.this.closeDialog(1);
            }
        });
        panelButtons.add(this.m_ButtonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseDateEditor.this.closeDialog(0);
            }
        });
        panelButtons.add(buttonClose);
        return panelAll;
    }

    protected void updateButtons() {
        int index = this.m_ComboBoxPlaceholders.getSelectedIndex();
        if (index == 0) {
            this.m_ButtonOK.setEnabled(this.m_Date.isValid(this.m_TextCustom.getText()));
        } else {
            this.m_ButtonOK.setEnabled(true);
        }
    }

    @Override
    protected void initForDisplay() {
        super.initForDisplay();
        this.m_TextCustom.setText(((BaseDate)this.getValue()).getValue());
        this.m_TextCustom.setToolTipText(((BaseObject)this.getValue()).getTipText());
        this.m_Calendar.setDate(((BaseDate)this.getValue()).dateValue());
        this.m_ComboBoxPlaceholders.setSelectedIndex(this.m_ComboBoxPlaceholders.getSelectedIndex());
        this.updateButtons();
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] result;
        Component comp = this.getCustomEditor();
        this.initForDisplay();
        MultiLineValueDialog dialog = new MultiLineValueDialog();
        dialog.setInfoText("Enter the date values, one per line:");
        dialog.setLocationRelativeTo(comp.getParent());
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            Vector<String> lines = new Vector<String>(Arrays.asList(dialog.getContent().split("\n")));
            Utils.removeEmptyLines(lines);
            result = new BaseDate[lines.size()];
            for (int i = 0; i < lines.size(); ++i) {
                result[i] = new BaseDate(lines.get(i));
            }
        } else {
            result = new BaseDate[]{};
        }
        return result;
    }
}

