/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.core.base.BaseString;
import adams.parser.AbstractExpressionEvaluator;
import java.util.HashMap;

public abstract class AbstractSymbolEvaluator<T>
extends AbstractExpressionEvaluator<T> {
    private static final long serialVersionUID = -5532014159307231647L;
    protected BaseString[] m_Symbols;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("symbol", "symbols", new BaseString[0]);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Symbols = new BaseString[0];
    }

    public void setSymbols(BaseString[] value) {
        this.m_Symbols = value;
    }

    public BaseString[] getSymbols() {
        return this.m_Symbols;
    }

    public String symbolsTipText() {
        return "The symbols to initialize the parser with, key-value pairs: name=value.";
    }

    protected abstract Object initializeSymbol(String var1, String var2);

    protected HashMap initializeSymbols() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < this.m_Symbols.length; ++i) {
            String pair = this.m_Symbols[i].stringValue();
            int pos = pair.indexOf(61);
            if (pos > -1) {
                String value;
                String name = pair.substring(0, pos);
                Object obj = this.initializeSymbol(name, value = pair.substring(pos + 1));
                if (obj != null) {
                    result.put(name, obj);
                    continue;
                }
                this.getSystemErr().println("Failed to initialize symbol '" + name + "' with value '" + value + "'!");
                continue;
            }
            this.getSystemErr().println("Symbol #" + (i + 1) + " is not of format 'name=value': " + this.m_Symbols[i]);
        }
        if (this.isDebugOn()) {
            this.debug("Generated symbols: " + result);
        }
        return result;
    }

    protected abstract T doEvaluate(HashMap var1) throws Exception;

    @Override
    public T evaluate() throws Exception {
        return this.doEvaluate(this.initializeSymbols());
    }
}

