/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.evaluator;

import adams.data.weka.evaluator.AbstractInstanceEvaluator;
import weka.core.Instances;

public abstract class AbstractDatasetInstanceEvaluator
extends AbstractInstanceEvaluator {
    private static final long serialVersionUID = 7443189522006925538L;
    protected Instances m_Data;
    protected double m_Threshold;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("threshold", "threshold", (Object)0.75);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Initialized = false;
    }

    public void setData(Instances value) {
        this.m_Data = value;
        this.reset();
    }

    public Instances getData() {
        return this.m_Data;
    }

    public void setThreshold(double value) {
        this.m_Threshold = value;
        this.reset();
    }

    public double getThreshold() {
        return this.m_Threshold;
    }

    public String thresholdTipText() {
        return "The threshold percentage to use (0-1).";
    }

    protected Instances[] split(Instances data, double percentage) {
        Instances[] result = new Instances[2];
        int max = (int)Math.round((double)data.numInstances() * percentage);
        result[0] = new Instances(data, 0, max);
        result[1] = new Instances(data, max, data.numInstances() - max);
        return result;
    }

    protected abstract String findThreshold();

    @Override
    protected String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.m_Data == null ? "No data for training available!" : (this.m_Data.classIndex() == -1 ? "No class attribute set!" : this.findThreshold());
        }
        return result;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_Data = null;
    }
}

