/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.parser.GrammarSupplier;
import adams.parser.twitterfilter.Symbols;
import java.util.HashMap;
import twitter4j.Status;
import twitter4j.Tweet;

public class TwitterFilter
extends AbstractTransformer
implements GrammarSupplier {
    private static final long serialVersionUID = -449062766931736640L;
    protected String m_Expression;

    public String globalInfo() {
        return "Filters Twitter objects (tweet/status) according to the provided filter expression. Only objects that match the filter expression are passed on.\n\nThe expressions use the following grammar:\n\n" + this.getGrammar();
    }

    public String getGrammar() {
        return new adams.parser.TwitterFilter().getGrammar();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", (Object)"text~\".*\"");
    }

    public void setExpression(String value) {
        this.m_Expression = value;
        this.reset();
    }

    public String getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The filter expression to use.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("expression");
        if (variable != null) {
            return variable;
        }
        if (this.m_Expression != null && this.m_Expression.length() > 0) {
            return this.m_Expression;
        }
        return null;
    }

    public Class[] accepts() {
        return new Class[]{Tweet.class, Status.class};
    }

    public Class[] generates() {
        return new Class[]{Tweet.class, Status.class};
    }

    protected HashMap processTweet(Tweet tweet) {
        HashMap<Symbols, String> result = new HashMap<Symbols, String>();
        result.put(Symbols.USER, tweet.getFromUser().toLowerCase());
        if (tweet.getSource() != null) {
            result.put(Symbols.SOURCE, tweet.getSource().toLowerCase());
        }
        result.put(Symbols.TEXT, tweet.getText().toLowerCase());
        if (tweet.getIsoLanguageCode() != null) {
            result.put(Symbols.LANGUAGE_CODE, tweet.getIsoLanguageCode().toLowerCase());
        }
        return result;
    }

    protected HashMap processStatus(Status status) {
        HashMap<Symbols, String> result = new HashMap<Symbols, String>();
        result.put(Symbols.USER, status.getUser().getName().toLowerCase());
        result.put(Symbols.SOURCE, status.getSource().toLowerCase());
        result.put(Symbols.TEXT, status.getText().toLowerCase());
        if (status.getPlace() != null) {
            result.put(Symbols.COUNTRY, status.getPlace().getCountry().toLowerCase());
            result.put(Symbols.COUNTRY_CODE, status.getPlace().getCountryCode().toLowerCase());
            result.put(Symbols.PLACE, status.getPlace().getName().toLowerCase());
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        String exp = this.m_Expression;
        try {
            HashMap symbols = this.m_InputToken.getPayload() instanceof Tweet ? this.processTweet((Tweet)this.m_InputToken.getPayload()) : this.processStatus((Status)this.m_InputToken.getPayload());
            boolean match = adams.parser.TwitterFilter.evaluate(exp, symbols);
            if (match) {
                this.m_OutputToken = new Token(this.m_InputToken.getPayload());
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            this.getSystemErr().println("Error evaluating: " + exp);
            this.getSystemErr().printStackTrace((Throwable)e);
            result = e.toString();
        }
        return result;
    }
}

