/*
 * Decompiled with CFR 0.152.
 */
package adams.data.sequence;

import adams.data.container.DataContainerUtils;
import adams.data.container.DataPoint;
import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequencePointComparator;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class XYSequenceUtils
extends DataContainerUtils {
    protected static XYSequencePointComparator m_Comparator = new XYSequencePointComparator(XYSequencePointComparator.Comparison.X, true);

    public XYSequencePointComparator getComparator() {
        return m_Comparator;
    }

    protected static XYSequence getHeader(List<XYSequencePoint> points) {
        XYSequence result;
        if (points.size() > 0 && points.get(0).getParent() != null) {
            result = (XYSequence)points.get(0).getParent().getHeader();
        } else {
            result = new XYSequence();
            result.setID("unknown");
        }
        return result;
    }

    public static int findX(List<XYSequencePoint> points, XYSequencePoint p) {
        int result = Collections.binarySearch(points, p, m_Comparator);
        if (result < 0) {
            result = -1;
        }
        return result;
    }

    public static int findX(List<XYSequencePoint> points, Number x) {
        return XYSequenceUtils.findX(points, new XYSequencePoint<Number, Object>(x, null));
    }

    public static int findClosestX(List<XYSequencePoint> points, Number x) {
        int result = -1;
        if (points.size() == 0) {
            return result;
        }
        int index = Collections.binarySearch(points, new XYSequencePoint<Number, Object>(x, null), m_Comparator);
        if (index < 0) {
            if ((index = -index) >= points.size()) {
                index = points.size() - 1;
            }
            result = index;
            double dist = Math.abs(x.doubleValue() - ((Number)points.get(index).getX()).doubleValue());
            for (int i = index - 2; i <= index + 2; ++i) {
                if (i < 0 || i >= points.size()) continue;
                XYSequencePoint currPoint = points.get(i);
                double currDist = Math.abs(x.doubleValue() - ((Number)currPoint.getX()).doubleValue());
                if (!(currDist < dist)) continue;
                dist = currDist;
                result = i;
            }
        } else {
            result = index;
        }
        return result;
    }

    public static int[] findEnclosingXs(List<XYSequencePoint> points, Number x) {
        int[] result = new int[]{-1, -1};
        int index = XYSequenceUtils.findClosestX(points, x);
        if (index > -1) {
            if (((Number)points.get(index).getX()).doubleValue() <= x.doubleValue()) {
                result[0] = index;
                if (index < points.size() - 1) {
                    result[1] = index + 1;
                }
            } else if (((Number)points.get(index).getX()).doubleValue() > x.doubleValue()) {
                result[1] = index;
                if (index > 0) {
                    result[0] = index - 1;
                }
            }
        }
        return result;
    }

    public static XYSequence getConsecutiveRegion(List<XYSequencePoint> points, XYSequencePoint lastEnd, XYSequencePoint end) {
        XYSequence result = XYSequenceUtils.getHeader(points);
        int indexStart = lastEnd == null ? 0 : XYSequenceUtils.findX(points, lastEnd) + 1;
        int indexEnd = end == null ? points.size() - 1 : XYSequenceUtils.findX(points, end);
        for (int i = indexStart; i <= indexEnd; ++i) {
            result.add((XYSequencePoint)points.get(i).getClone());
        }
        return result;
    }

    public static XYSequence getRegion(List<XYSequencePoint> points, XYSequencePoint start, XYSequencePoint end) {
        XYSequence result = XYSequenceUtils.getHeader(points);
        int indexStart = start == null ? 0 : XYSequenceUtils.findX(points, start);
        int indexEnd = end == null ? points.size() - 1 : XYSequenceUtils.findX(points, end);
        for (int i = indexStart; i <= indexEnd; ++i) {
            result.add((XYSequencePoint)points.get(i).getClone());
        }
        return result;
    }

    public static int countSignChanges(List<XYSequencePoint> points, Number start, Number end) {
        int result = 0;
        int startIndex = XYSequenceUtils.findX(points, start);
        int endIndex = XYSequenceUtils.findX(points, end);
        double y = ((Number)points.get(startIndex).getY()).doubleValue();
        for (int i = startIndex + 1; i <= endIndex; ++i) {
            XYSequencePoint point = points.get(i);
            if (Math.signum(((Number)point.getY()).doubleValue()) == Math.signum(y)) continue;
            ++result;
            y = ((Number)point.getY()).doubleValue();
        }
        return result;
    }

    public static int countRegions(List<XYSequencePoint> points, Number start, Number end, boolean positive) {
        int result = 0;
        int startIndex = XYSequenceUtils.findX(points, start);
        int endIndex = XYSequenceUtils.findX(points, end);
        double y = ((Number)points.get(startIndex).getY()).doubleValue();
        if (positive && y >= 0.0) {
            ++result;
        } else if (!positive && y < 0.0) {
            ++result;
        }
        for (int i = startIndex + 1; i <= endIndex; ++i) {
            XYSequencePoint point = points.get(i);
            if (Math.signum(((Number)point.getY()).doubleValue()) == Math.signum(y)) continue;
            y = ((Number)point.getY()).doubleValue();
            if (positive && y >= 0.0) {
                ++result;
                continue;
            }
            if (positive || !(y < 0.0)) continue;
            ++result;
        }
        return result;
    }

    public static double[] getHistogram(List<XYSequencePoint> points, int numBins) {
        double[] result = new double[numBins];
        double min = ((Number)points.get(0).getY()).doubleValue();
        double max = ((Number)points.get(points.size() - 1).getY()).doubleValue();
        double scale = 1.0 / ((max - min + 1.0) / (double)numBins);
        for (int i = 0; i < points.size(); ++i) {
            int n = (int)((((Number)points.get(i).getY()).doubleValue() - min) * scale);
            result[n] = result[n] + 1.0;
        }
        return result;
    }

    protected static void add(Hashtable<Number, XYSequencePoint> pool, XYSequence s) {
        for (XYSequencePoint pointSP : s.toList()) {
            XYSequencePoint poolSP = pool.get(pointSP.getX());
            if (poolSP == null) {
                poolSP = pointSP;
            }
            pool.put((Number)poolSP.getX(), poolSP);
        }
    }

    public static XYSequence merge(XYSequence s1, XYSequence s2) {
        Vector<XYSequence> list = new Vector<XYSequence>();
        list.add(s1);
        list.add(s2);
        return XYSequenceUtils.merge(list);
    }

    public static XYSequence merge(Vector<XYSequence> list) {
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        XYSequence result = (XYSequence)list.get(0).getHeader();
        Hashtable<Number, XYSequencePoint> pool = new Hashtable<Number, XYSequencePoint>();
        for (int i = 0; i < list.size(); ++i) {
            XYSequenceUtils.add(pool, list.get(i));
        }
        Enumeration elements = pool.elements();
        while (elements.hasMoreElements()) {
            result.add((DataPoint)elements.nextElement());
        }
        return result;
    }
}

