/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.test;

import adams.core.io.PlaceholderFile;
import adams.flow.condition.test.AbstractCondition;

public abstract class AbstractScriptCondition
extends AbstractCondition {
    private static final long serialVersionUID = -1266048092842841686L;
    protected PlaceholderFile m_ScriptFile;
    protected String m_ScriptOptions;
    protected transient Object m_ScriptObject;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "scriptFile", new PlaceholderFile("."));
        this.m_OptionManager.add("options", "scriptOptions", "");
    }

    @Override
    public void reset() {
        super.reset();
        this.m_ScriptObject = null;
    }

    public void setScriptFile(PlaceholderFile value) {
        this.m_ScriptFile = value;
    }

    public PlaceholderFile getScriptFile() {
        return this.m_ScriptFile;
    }

    public String scriptFileTipText() {
        return "The script file to load and execute.";
    }

    public void setScriptOptions(String value) {
        this.m_ScriptOptions = value;
    }

    public String getScriptOptions() {
        return this.m_ScriptOptions;
    }

    public String scriptOptionsTipText() {
        return "The options for the script.";
    }

    protected abstract String loadScriptObject();

    protected abstract String checkScriptObject();

    protected String initScriptObject() {
        String result = this.loadScriptObject();
        if (result == null) {
            result = this.checkScriptObject();
        }
        return result;
    }

    protected abstract String performScriptTest();

    @Override
    protected String performTest() {
        String result = null;
        if (this.m_ScriptObject == null) {
            result = this.initScriptObject();
        }
        if (result == null) {
            result = this.performScriptTest();
        }
        return result;
    }
}

