/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.base.BaseObject;
import adams.core.base.BaseTime;
import adams.core.option.AbstractOption;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.freixas.jcalendar.JCalendar;

public class BaseTimeEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
MultiSelectionEditor {
    protected JCalendar m_Calendar;
    protected JComboBox m_ComboBoxPlaceholders;
    protected JTextField m_TextCustom;
    protected JButton m_ButtonNow;
    protected JButton m_ButtonOK;
    protected BaseTime m_Time;

    public static String toString(AbstractOption option, Object object) {
        return ((BaseTime)object).getValue();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new BaseTime(str);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Time = new BaseTime();
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return BaseTimeEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return BaseTimeEditor.valueOf(null, str);
    }

    @Override
    public String getJavaInitializationString() {
        String result = "new " + this.getValue().getClass().getName() + "(\"" + BaseTimeEditor.toString(null, this.getValue()) + "\")";
        return result;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getValue() == null ? "null" : BaseTimeEditor.toString(null, this.getValue());
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    @Override
    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        panelAll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panelValues = new JPanel(new BorderLayout());
        panelAll.add((Component)panelValues, "Center");
        JPanel panel = new JPanel(new FlowLayout(0));
        panelValues.add((Component)panel, "Center");
        this.m_Calendar = new JCalendar(Calendar.getInstance(), Locale.getDefault(), 2, false, "HH:mm:ss");
        this.m_ComboBoxPlaceholders = new JComboBox<String>(new String[]{"Custom", "Selected", "-INF", "NOW", "+INF"});
        this.m_ComboBoxPlaceholders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = BaseTimeEditor.this.m_ComboBoxPlaceholders.getSelectedIndex();
                if (index > 1) {
                    BaseTime time = new BaseTime((String)BaseTimeEditor.this.m_ComboBoxPlaceholders.getSelectedItem());
                    BaseTimeEditor.this.m_Calendar.setDate(time.dateValue());
                }
                BaseTimeEditor.this.m_TextCustom.setEnabled(index == 0);
                BaseTimeEditor.this.m_ButtonNow.setEnabled(index == 1);
                BaseTimeEditor.this.m_Calendar.setEnabled(index != 1);
                BaseTimeEditor.this.m_Calendar.setEnabled(index == 1);
            }
        });
        this.m_ButtonNow = new JButton("Now");
        this.m_ButtonNow.setMnemonic('N');
        this.m_ButtonNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseTimeEditor.this.m_Calendar.setDate(new BaseTime("NOW").dateValue());
            }
        });
        panel.add((Component)this.m_Calendar);
        panel.add(new JLabel(" or "));
        panel.add(this.m_ComboBoxPlaceholders);
        panel.add(this.m_ButtonOK);
        this.m_TextCustom = new JTextField(10);
        this.m_TextCustom.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            protected void update() {
                BaseTimeEditor.this.updateButtons();
            }
        });
        panelValues.add((Component)this.m_TextCustom, "South");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        this.m_ButtonOK = new JButton("OK");
        this.m_ButtonOK.setMnemonic('O');
        this.m_ButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = BaseTimeEditor.this.m_ComboBoxPlaceholders.getSelectedIndex();
                if (index == 0) {
                    BaseTimeEditor.this.setValue(new BaseTime(BaseTimeEditor.this.m_TextCustom.getText()));
                } else if (index == 1) {
                    BaseTimeEditor.this.setValue(new BaseTime(BaseTimeEditor.this.m_Calendar.getDate()));
                } else {
                    BaseTimeEditor.this.setValue(new BaseTime((String)BaseTimeEditor.this.m_ComboBoxPlaceholders.getSelectedItem()));
                }
                BaseTimeEditor.this.closeDialog(1);
            }
        });
        panelButtons.add(this.m_ButtonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseTimeEditor.this.closeDialog(0);
            }
        });
        panelButtons.add(buttonClose);
        return panelAll;
    }

    protected void updateButtons() {
        int index = this.m_ComboBoxPlaceholders.getSelectedIndex();
        if (index == 0) {
            this.m_ButtonOK.setEnabled(this.m_Time.isValid(this.m_TextCustom.getText()));
        } else {
            this.m_ButtonOK.setEnabled(true);
        }
    }

    @Override
    protected void initForDisplay() {
        super.initForDisplay();
        this.m_TextCustom.setText(((BaseTime)this.getValue()).getValue());
        this.m_TextCustom.setToolTipText(((BaseObject)this.getValue()).getTipText());
        this.m_Calendar.setDate(((BaseTime)this.getValue()).dateValue());
        this.m_ComboBoxPlaceholders.setSelectedIndex(this.m_ComboBoxPlaceholders.getSelectedIndex());
        this.updateButtons();
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] result;
        Component comp = this.getCustomEditor();
        this.initForDisplay();
        MultiLineValueDialog dialog = new MultiLineValueDialog();
        dialog.setInfoText("Enter the time values, one per line:");
        dialog.setLocationRelativeTo(comp.getParent());
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            Vector<String> lines = new Vector<String>(Arrays.asList(dialog.getContent().split("\n")));
            Utils.removeEmptyLines(lines);
            result = new BaseTime[lines.size()];
            for (int i = 0; i < lines.size(); ++i) {
                result[i] = new BaseTime(lines.get(i));
            }
        } else {
            result = new BaseTime[]{};
        }
        return result;
    }
}

