/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.AdditionalInformationHandler;
import adams.core.Properties;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractNumericOption;
import adams.core.option.AbstractOption;
import adams.core.option.HtmlHelpProducer;
import adams.core.option.OptionHandler;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.BaseTextAreaWithButtons;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.core.ParameterPanel;
import adams.gui.goe.AbstractGenericObjectEditorHandler;
import adams.gui.goe.AbstractNumberEditor;
import adams.gui.goe.Editors;
import adams.gui.goe.GenericObjectEditor;
import adams.gui.goe.GenericObjectEditorHelpDialog;
import adams.gui.goe.PropertyPanel;
import adams.gui.goe.PropertyText;
import adams.gui.goe.PropertyValueSelector;
import adams.gui.goe.VariableSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;

public class PropertySheetPanel
extends BasePanel
implements PropertyChangeListener {
    static final long serialVersionUID = -557854258929870536L;
    public static final int MAX_TOOLTIP_WIDTH = 40;
    protected Object m_Target;
    protected Vector<AbstractOption> m_Options;
    protected PropertyDescriptor[] m_Properties;
    protected MethodDescriptor[] m_Methods;
    protected PropertyEditor[] m_Editors;
    protected Object[] m_Values;
    protected ParameterPanel m_ParameterPanel;
    protected JComponent[] m_Views;
    protected String[] m_TipTexts;
    protected StringBuffer m_HelpText;
    protected StringBuffer m_HelpTextHtml;
    protected String m_GlobalInfo;
    protected GenericObjectEditorHelpDialog m_DialogHelp;
    protected JButton m_ButtonHelp;
    protected BaseTextAreaWithButtons m_PanelAbout;
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);

    public PropertySheetPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
    }

    public JPanel getAboutPanel() {
        return this.m_PanelAbout;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.m_Support;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.wasModified(evt);
        this.m_Support.firePropertyChange("", null, null);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.removePropertyChangeListener(l);
    }

    protected String extractFirstSentence(String text, boolean indicator) {
        int pos = text.length() - 1;
        int newPos = text.indexOf(". ");
        if (newPos > -1 && newPos < pos) {
            pos = newPos;
        }
        if ((newPos = text.indexOf(".\n")) > -1 && newPos < pos) {
            pos = newPos;
        }
        String result = text.substring(0, pos + 1);
        if (indicator && result.length() < text.length()) {
            result = result + " ...";
        }
        return result;
    }

    protected void initSheet() {
        Properties blacklisted = Editors.getBlacklistedClasses();
        this.m_Options = null;
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.m_Target.getClass());
            if (this.m_Target instanceof OptionHandler) {
                List<AbstractOption> options = ((OptionHandler)this.m_Target).getOptionManager().getOptionsList();
                this.m_Options = new Vector();
                Vector<PropertyDescriptor> propdesc = new Vector<PropertyDescriptor>();
                for (int i = 0; i < options.size(); ++i) {
                    AbstractArgumentOption opt;
                    if (options.get(i) instanceof AbstractArgumentOption && ((opt = (AbstractArgumentOption)options.get(i)).isMultiple() ? blacklisted.getBoolean(opt.getBaseClass().getName() + "[]", false) != false : blacklisted.getBoolean(opt.getBaseClass().getName(), false) != false)) continue;
                    propdesc.add(options.get(i).getDescriptor());
                    this.m_Options.add(options.get(i));
                }
                this.m_Properties = propdesc.toArray(new PropertyDescriptor[propdesc.size()]);
            } else {
                this.m_Properties = bi.getPropertyDescriptors();
            }
            this.m_Methods = bi.getMethodDescriptors();
        }
        catch (IntrospectionException ex) {
            System.err.println("PropertySheet: Couldn't introspect");
            return;
        }
        this.m_Editors = new PropertyEditor[this.m_Properties.length];
        this.m_Values = new Object[this.m_Properties.length];
        this.m_Views = new JComponent[this.m_Properties.length];
        this.m_TipTexts = new String[this.m_Properties.length];
    }

    protected void initHelp() {
        Method method;
        this.m_HelpText = null;
        this.m_HelpTextHtml = null;
        this.m_GlobalInfo = null;
        if (this.m_Target instanceof OptionHandler) {
            this.m_HelpTextHtml = new StringBuffer();
            HtmlHelpProducer producer = new HtmlHelpProducer();
            producer.produce((OptionHandler)this.m_Target);
            this.m_HelpTextHtml.append(producer.toString());
        } else {
            this.m_HelpText = new StringBuffer();
        }
        try {
            method = this.m_Target.getClass().getMethod("globalInfo", new Class[0]);
            if (method != null) {
                String addInfo;
                this.m_GlobalInfo = (String)method.invoke(this.m_Target, new Object[0]);
                String className = this.m_Target.getClass().getName();
                this.m_HelpText.append("NAME\n");
                this.m_HelpText.append(className).append("\n\n");
                this.m_HelpText.append("SYNOPSIS\n").append(this.m_GlobalInfo).append("\n\n");
                if (this.m_Target instanceof AdditionalInformationHandler && (addInfo = ((AdditionalInformationHandler)this.m_Target).getAdditionalInformation()) != null && addInfo.length() > 0) {
                    this.m_HelpText.append("ADDITIONAL INFORMATION\n");
                    this.m_HelpText.append(addInfo + "\n\n");
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean firstTip = true;
        block4: for (int i = 0; i < this.m_Editors.length; ++i) {
            String name = this.m_Properties[i].getDisplayName();
            String tipName = name + "TipText";
            for (int j = 0; j < this.m_Methods.length; ++j) {
                String mname = this.m_Methods[j].getDisplayName();
                method = this.m_Methods[j].getMethod();
                String commandline = null;
                if (!mname.equals(tipName) || !method.getReturnType().equals(String.class)) continue;
                if (this.m_Options != null) {
                    commandline = this.m_Options.get(i).getCommandline();
                }
                try {
                    String tipText = (String)method.invoke(this.m_Target, new Object[0]);
                    this.m_TipTexts[i] = this.extractFirstSentence(tipText, true);
                    if (this.m_HelpText == null) continue block4;
                    if (firstTip) {
                        this.m_HelpText.append("OPTIONS\n");
                        firstTip = false;
                    }
                    this.m_HelpText.append(name);
                    if (commandline != null) {
                        this.m_HelpText.append("/-" + commandline);
                    }
                    this.m_HelpText.append(":\n");
                    this.m_HelpText.append(tipText).append("\n\n");
                }
                catch (Exception ex) {}
                continue block4;
            }
        }
    }

    public synchronized void setTarget(Object targ) {
        this.m_Target = targ;
        this.initSheet();
        this.initHelp();
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel scrollablePanel = new JPanel(new BorderLayout());
        BaseScrollPane scrollPane = new BaseScrollPane(scrollablePanel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scrollPane, "Center");
        this.setVisible(false);
        if (this.m_GlobalInfo != null) {
            String summary = this.extractFirstSentence(this.m_GlobalInfo, true);
            this.m_ButtonHelp = new JButton(GUIHelper.getIcon("help.gif"));
            this.m_ButtonHelp.setToolTipText("Help on " + this.m_Target.getClass().getName());
            this.m_ButtonHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent a) {
                    PropertySheetPanel.this.openHelpDialog();
                    PropertySheetPanel.this.m_ButtonHelp.setEnabled(false);
                }
            });
            this.m_PanelAbout = new BaseTextAreaWithButtons(summary);
            this.m_PanelAbout.setColumns(30);
            this.m_PanelAbout.setEditable(false);
            this.m_PanelAbout.setLineWrap(true);
            this.m_PanelAbout.setWrapStyleWord(true);
            this.m_PanelAbout.setTextFont(new Font("SansSerif", 0, 12));
            this.m_PanelAbout.getScrollPane().setBorder(null);
            ((BaseTextArea)this.m_PanelAbout.getComponent()).setBackground(this.getBackground());
            this.m_PanelAbout.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("About"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.m_PanelAbout.addToButtonsPanel(this.m_ButtonHelp);
            this.add((Component)this.m_PanelAbout, "North");
        }
        this.m_ParameterPanel = null;
        for (int i = 0; i < this.m_Properties.length; ++i) {
            if (this.m_Properties[i].isHidden() || this.m_Properties[i].isExpert()) continue;
            String name = this.m_Properties[i].getDisplayName();
            Class<?> type = this.m_Properties[i].getPropertyType();
            Method getter = this.m_Properties[i].getReadMethod();
            Method setter = this.m_Properties[i].getWriteMethod();
            if (getter == null || setter == null) continue;
            try {
                boolean canChangeClass = true;
                this.m_Values[i] = getter.invoke(this.m_Target, new Object[0]);
                Class<?> pec = this.m_Properties[i].getPropertyEditorClass();
                if (pec != null) {
                    try {
                        this.m_Editors[i] = (PropertyEditor)pec.newInstance();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (this.m_Editors[i] == null) {
                    this.m_Editors[i] = PropertyEditorManager.findEditor(type);
                }
                if (this.m_Editors[i] == null && this.m_Target instanceof OptionHandler) {
                    this.m_Editors[i] = new GenericObjectEditor();
                    canChangeClass = false;
                }
                if (this.m_Editors[i] == null) continue;
                AbstractGenericObjectEditorHandler handler = AbstractGenericObjectEditorHandler.getHandler(this.m_Editors[i]);
                handler.setClassType(this.m_Editors[i], type);
                handler.setCanChangeClassInDialog(this.m_Editors[i], canChangeClass);
                if (this.m_Values[i] == null) continue;
                this.m_Editors[i].setValue(this.m_Values[i]);
                if (this.m_Editors[i].supportsCustomEditor() && this.m_Editors[i].isPaintable()) {
                    this.m_Views[i] = new PropertyPanel(this.m_Editors[i]);
                } else if (this.m_Editors[i].supportsCustomEditor() && this.m_Editors[i].getCustomEditor() instanceof JComponent) {
                    this.m_Views[i] = (JComponent)this.m_Editors[i].getCustomEditor();
                } else if (this.m_Editors[i].getTags() != null) {
                    this.m_Views[i] = new PropertyValueSelector(this.m_Editors[i]);
                } else if (this.m_Editors[i].getAsText() != null) {
                    this.m_Views[i] = new PropertyText(this.m_Editors[i]);
                } else {
                    System.err.println("Warning: Property \"" + name + "\" has non-displayabale editor.  Skipping.");
                    continue;
                }
                if (this.m_Views[i] instanceof JSpinner) {
                    this.m_Views[i].setSize(new Dimension(100, 20));
                    this.m_Views[i].setPreferredSize(new Dimension(100, 20));
                    this.m_Views[i].setMaximumSize(new Dimension(100, 40));
                } else if (this.m_Views[i] instanceof JCheckBox) {
                    this.m_Views[i].setSize(new Dimension(25, 20));
                    this.m_Views[i].setPreferredSize(new Dimension(25, 20));
                    this.m_Views[i].setMaximumSize(new Dimension(25, 25));
                } else {
                    this.m_Views[i].setSize(new Dimension(300, 20));
                    this.m_Views[i].setPreferredSize(new Dimension(300, 20));
                    this.m_Views[i].setMaximumSize(new Dimension(300, 40));
                }
                this.m_Editors[i].addPropertyChangeListener(this);
            }
            catch (InvocationTargetException ex) {
                System.err.println("Skipping property " + name + "; exception on target: " + ex.getTargetException());
                ex.getTargetException().printStackTrace();
                continue;
            }
            catch (Exception ex) {
                System.err.println("Skipping property " + name + "; exception: " + ex);
                ex.printStackTrace();
                continue;
            }
            if (this.m_ParameterPanel == null) {
                this.m_ParameterPanel = new ParameterPanel();
                scrollablePanel.add((Component)this.m_ParameterPanel, "Center");
            }
            this.m_ParameterPanel.addParameter(name, this.m_Views[i]);
            this.m_ParameterPanel.getLabel(this.m_ParameterPanel.getParameterCount() - 1);
            final JLabel label = this.m_ParameterPanel.getLabel(this.m_ParameterPanel.getParameterCount() - 1);
            final PropertyEditor editor = this.m_Editors[i];
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (MouseUtils.isRightClick(evt)) {
                        evt.consume();
                        JPopupMenu menu = new JPopupMenu();
                        VariableSupport.updatePopup(PropertySheetPanel.this, editor, menu);
                        menu.show(label, evt.getX(), evt.getY());
                    } else {
                        super.mouseClicked(evt);
                    }
                }
            });
            if (this.m_Options != null) {
                label.setToolTipText("Command-line option: -" + this.m_Options.get(i).getCommandline());
                if (this.m_Options.get(i) instanceof AbstractArgumentOption) {
                    VariableSupport.updateLabel(label, ((AbstractArgumentOption)this.m_Options.get(i)).getVariableName());
                    if (this.m_Editors[i] instanceof AbstractNumberEditor) {
                        ((AbstractNumberEditor)this.m_Editors[i]).setDefaultValue((Number)this.m_Options.get(i).getDefaultValue());
                        ((AbstractNumberEditor)this.m_Editors[i]).setLowerBound((Number)((AbstractNumericOption)this.m_Options.get(i)).getLowerBound());
                        ((AbstractNumberEditor)this.m_Editors[i]).setUpperBound((Number)((AbstractNumericOption)this.m_Options.get(i)).getUpperBound());
                    }
                }
            }
            if (this.m_TipTexts[i] == null) continue;
            this.m_Views[i].setToolTipText(GUIHelper.processTipText(this.m_TipTexts[i], 40));
        }
        if (this.m_ParameterPanel == null) {
            JLabel empty = new JLabel("No editable properties", 0);
            scrollablePanel.add(empty);
        }
        this.validate();
        Dimension dim = scrollablePanel.getPreferredSize();
        dim.height += 20;
        dim.width += 20;
        scrollPane.setPreferredSize(dim);
        this.validate();
        this.setVisible(true);
    }

    protected void setMnemonics() {
        int i;
        String[] labels = new String[this.editableProperties()];
        for (i = 0; i < this.editableProperties(); ++i) {
            labels[i] = this.m_ParameterPanel.getLabel(i).getText();
        }
        char[] mnemonics = GUIHelper.getMnemonics(labels);
        for (i = 0; i < this.editableProperties(); ++i) {
            this.m_ParameterPanel.getLabel(i).setDisplayedMnemonic(mnemonics[i]);
        }
    }

    protected void openHelpDialog() {
        this.initHelp();
        boolean isHtml = this.m_HelpTextHtml != null;
        this.m_DialogHelp = GUIHelper.getParentDialog(this) != null ? new GenericObjectEditorHelpDialog(GUIHelper.getParentDialog(this), this) : new GenericObjectEditorHelpDialog(GUIHelper.getParentFrame(this), this);
        if (isHtml) {
            this.m_DialogHelp.setHelp(this.m_HelpTextHtml.toString(), true);
        } else {
            this.m_DialogHelp.setHelp(this.m_HelpText.toString(), false);
        }
        this.m_DialogHelp.setLocation(this.m_PanelAbout.getTopLevelAncestor().getLocationOnScreen().x + this.m_PanelAbout.getTopLevelAncestor().getSize().width, this.m_PanelAbout.getTopLevelAncestor().getLocationOnScreen().y);
        if (isHtml) {
            this.m_DialogHelp.setSize(800, 600);
        } else {
            this.m_DialogHelp.setSize(400, 350);
        }
        this.m_DialogHelp.setVisible(true);
    }

    public int editableProperties() {
        if (this.m_ParameterPanel == null) {
            return 0;
        }
        return this.m_ParameterPanel.getParameterCount();
    }

    synchronized void wasModified(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof PropertyEditor) {
            PropertyEditor editor = (PropertyEditor)evt.getSource();
            for (int i = 0; i < this.m_Editors.length; ++i) {
                Object value;
                if (this.m_Editors[i] != editor) continue;
                PropertyDescriptor property = this.m_Properties[i];
                this.m_Values[i] = value = editor.getValue();
                Method setter = property.getWriteMethod();
                try {
                    Object[] args = new Object[]{value};
                    args[0] = value;
                    setter.invoke(this.m_Target, args);
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof PropertyVetoException) {
                        String message = "WARNING: Vetoed; reason is: " + ex.getTargetException().getMessage();
                        System.err.println(message);
                        Container jf = evt.getSource() instanceof JPanel ? ((JPanel)evt.getSource()).getParent() : new JFrame();
                        JOptionPane.showMessageDialog(jf, message, "error", 2);
                        if (jf instanceof JFrame) {
                            ((Window)jf).dispose();
                        }
                    } else {
                        System.err.println(ex.getTargetException().getClass().getName() + " while updating " + property.getName() + ": " + ex.getTargetException().getMessage());
                        Container jf = evt.getSource() instanceof JPanel ? ((JPanel)evt.getSource()).getParent() : new JFrame();
                        JOptionPane.showMessageDialog(jf, ex.getTargetException().getClass().getName() + " while updating " + property.getName() + ":\n" + ex.getTargetException().getMessage(), "error", 2);
                        if (jf instanceof JFrame) {
                            ((Window)jf).dispose();
                        }
                    }
                }
                catch (Exception ex) {
                    System.err.println("Unexpected exception while updating " + property.getName());
                    ex.printStackTrace();
                }
                if (this.m_Views[i] == null || !(this.m_Views[i] instanceof PropertyPanel)) break;
                this.m_Views[i].repaint();
                this.revalidate();
                break;
            }
        }
        for (int i = 0; i < this.m_Properties.length; ++i) {
            Object o;
            try {
                Method getter = this.m_Properties[i].getReadMethod();
                Method setter = this.m_Properties[i].getWriteMethod();
                if (getter == null || setter == null) continue;
                Object[] args = new Object[]{};
                o = getter.invoke(this.m_Target, args);
            }
            catch (Exception ex) {
                o = null;
            }
            if (o == this.m_Values[i] || o != null && o.equals(this.m_Values[i])) continue;
            this.m_Values[i] = o;
            if (this.m_Editors[i] == null) continue;
            this.m_Editors[i].removePropertyChangeListener(this);
            this.m_Editors[i].setValue(o);
            this.m_Editors[i].addPropertyChangeListener(this);
            if (this.m_Views[i] == null) continue;
            this.m_Views[i].repaint();
        }
        if (Beans.isInstanceOf(this.m_Target, Component.class)) {
            ((Component)Beans.getInstanceOf(this.m_Target, Component.class)).repaint();
        }
    }

    protected int findEditor(PropertyEditor editor) {
        int result = -1;
        if (this.m_Options != null) {
            for (int i = 0; i < this.m_Editors.length; ++i) {
                if (this.m_Editors[i] != editor) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public AbstractOption findOption(PropertyEditor editor) {
        int index = this.findEditor(editor);
        AbstractOption result = index > -1 ? this.m_Options.get(index) : null;
        return result;
    }

    public JComponent findView(PropertyEditor editor) {
        int index = this.findEditor(editor);
        JComponent result = index > -1 ? this.m_Views[index] : null;
        return result;
    }

    public JLabel findLabel(PropertyEditor editor) {
        int index = this.findEditor(editor);
        JLabel result = index > -1 ? this.m_ParameterPanel.getLabel(index) : null;
        return result;
    }

    public JButton getHelpButton() {
        return this.m_ButtonHelp;
    }

    public JDialog getHelpDialog() {
        return this.m_DialogHelp;
    }
}

