/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.sendto;

import adams.core.ClassLister;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.gui.core.GUIHelper;
import adams.gui.sendto.AbstractSendToAction;
import adams.gui.sendto.SendToActionSupporter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class SendToActionUtils {
    public static final String MENUITEM_SENDTO = "Send to";
    protected static Hashtable<Class, ArrayList<Class>> m_AcceptedCache;
    protected static int m_Counter;

    protected static synchronized Hashtable<Class, ArrayList<Class>> getAcceptedCache() {
        if (m_AcceptedCache == null) {
            String[] classes;
            m_AcceptedCache = new Hashtable();
            for (String cls : classes = ClassLister.getSingleton().getClassnames(AbstractSendToAction.class)) {
                try {
                    Class[] accepted;
                    AbstractSendToAction sendto = (AbstractSendToAction)Class.forName(cls).newInstance();
                    for (Class accept : accepted = sendto.accepts()) {
                        if (!m_AcceptedCache.containsKey(accept)) {
                            m_AcceptedCache.put(accept, new ArrayList());
                        }
                        m_AcceptedCache.get(accept).add(sendto.getClass());
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to instantiate sendto action '" + cls + "':");
                    e.printStackTrace();
                }
            }
        }
        return m_AcceptedCache;
    }

    public static AbstractSendToAction[] getActions(Class[] cls) {
        ArrayList<AbstractSendToAction> result = new ArrayList<AbstractSendToAction>();
        for (int i = 0; i < cls.length; ++i) {
            ArrayList<Class> classes = SendToActionUtils.getAcceptedCache().get(cls[i]);
            if (classes == null) continue;
            for (Class c : classes) {
                try {
                    result.add((AbstractSendToAction)c.newInstance());
                }
                catch (Exception e) {
                    System.err.println("Failed to instantiate sendto action '" + c.getName() + "':");
                    e.printStackTrace();
                }
            }
        }
        if (result.size() > 1) {
            Collections.sort(result);
        }
        return result.toArray(new AbstractSendToAction[result.size()]);
    }

    protected static boolean addSubmenu(final SendToActionSupporter owner, JMenu submenu) {
        AbstractSendToAction[] actions2;
        for (final AbstractSendToAction action : actions2 = SendToActionUtils.getActions(owner.getSendToClasses())) {
            JMenuItem menuitem = new JMenuItem(action.getAction());
            menuitem.setIcon(action.getIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object item;
                    Component parent = null;
                    if (owner instanceof Component) {
                        parent = (Component)((Object)owner);
                    }
                    if ((item = owner.getSendToItem(action.accepts())) == null) {
                        GUIHelper.showInformationMessage(parent, "Nothing to send right now!");
                        return;
                    }
                    String error = action.send(item);
                    if (error != null) {
                        GUIHelper.showErrorMessage(parent, error);
                    }
                }
            });
            submenu.add(menuitem);
        }
        return true;
    }

    public static boolean addSendToSubmenu(SendToActionSupporter owner, JPopupMenu menu) {
        AbstractSendToAction[] actions2 = SendToActionUtils.getActions(owner.getSendToClasses());
        if (actions2.length == 0) {
            return false;
        }
        JMenu submenu = new JMenu(MENUITEM_SENDTO);
        menu.add(submenu);
        return SendToActionUtils.addSubmenu(owner, submenu);
    }

    public static boolean addSendToSubmenu(SendToActionSupporter owner, JMenu menu) {
        AbstractSendToAction[] actions2 = SendToActionUtils.getActions(owner.getSendToClasses());
        if (actions2.length == 0) {
            return false;
        }
        JMenu submenu = new JMenu(MENUITEM_SENDTO);
        submenu.setIcon(GUIHelper.getIcon("sendto.png"));
        menu.add(submenu);
        return SendToActionUtils.addSubmenu(owner, submenu);
    }

    public static synchronized PlaceholderFile nextTmpFile(String prefix, String extension) {
        File file;
        String tmp = FileUtils.getTempDirectory().getAbsolutePath();
        while ((file = new File(tmp + File.separator + prefix + ++m_Counter + "." + extension)).exists()) {
        }
        PlaceholderFile result = new PlaceholderFile(file);
        result.deleteOnExit();
        return result;
    }

    public static boolean isAvailable(Class needle, Class[] haystack) {
        boolean result = false;
        for (Class c : haystack) {
            if (!c.equals(needle)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isAvailable(Class[] needles, Class[] haystack) {
        Class needle;
        boolean result = false;
        Class[] arr$ = needles;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(result = SendToActionUtils.isAvailable(needle = arr$[i$], haystack)); ++i$) {
        }
        return result;
    }

    static {
        m_Counter = 0;
    }
}

