/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.ClassLister;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionHandler;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractArchiveHandler
extends AbstractOptionHandler {
    private static final long serialVersionUID = 3774402480647722078L;
    protected PlaceholderFile m_Archive;
    protected static Hashtable<String, Vector<Class>> m_Relation;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("archive", "archive", new PlaceholderFile("."));
    }

    public abstract String[] getExtensions();

    public void setArchive(PlaceholderFile value) {
        this.m_Archive = value;
        this.reset();
    }

    public PlaceholderFile getArchive() {
        return this.m_Archive;
    }

    public String archiveTipText() {
        return "The archive to obtain the files from.";
    }

    protected void checkArchive() {
        if (!this.m_Archive.exists()) {
            throw new IllegalStateException("Archive does not exist: " + this.m_Archive);
        }
        if (this.m_Archive.isDirectory()) {
            throw new IllegalStateException("Archive is not a file: " + this.m_Archive);
        }
    }

    protected abstract String[] listFiles();

    public String[] getFiles() {
        this.checkArchive();
        return this.listFiles();
    }

    protected abstract boolean doExtract(String var1, File var2);

    public boolean extract(String archiveFile, File outFile) {
        this.checkArchive();
        return this.doExtract(archiveFile, outFile);
    }

    public static String[] getHandlers() {
        return ClassLister.getSingleton().getClassnames(AbstractArchiveHandler.class);
    }

    protected static synchronized Hashtable<String, Vector<Class>> getRelation() {
        if (m_Relation == null) {
            m_Relation = new Hashtable();
            String[] handlers = AbstractArchiveHandler.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                try {
                    AbstractArchiveHandler handler = (AbstractArchiveHandler)Class.forName(handlers[i]).newInstance();
                    String[] extensions = handler.getExtensions();
                    for (int n = 0; n < extensions.length; ++n) {
                        if (!m_Relation.containsKey(extensions[n])) {
                            m_Relation.put(extensions[n], new Vector());
                        }
                        Vector<Class> classes = m_Relation.get(extensions[n]);
                        classes.add(handler.getClass());
                    }
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error processing archive handler: " + handlers[i]);
                    e.printStackTrace();
                }
            }
        }
        return m_Relation;
    }

    public static boolean hasHandler(File file) {
        return AbstractArchiveHandler.hasHandler(file.getAbsolutePath());
    }

    public static boolean hasHandler(String filename) {
        String extension = FileUtils.getExtension(filename);
        if (extension != null) {
            extension = extension.toLowerCase();
        }
        if (extension != null) {
            return AbstractArchiveHandler.getRelation().containsKey(extension);
        }
        return false;
    }

    public static Vector<Class> getHandlersForFile(File file) {
        return AbstractArchiveHandler.getHandlersForFile(file.getAbsolutePath());
    }

    public static Vector<Class> getHandlersForFile(String filename) {
        String extension = FileUtils.getExtension(filename);
        if (extension != null) {
            extension = extension.toLowerCase();
        }
        Vector<Class> result = extension != null && AbstractArchiveHandler.getRelation().containsKey(extension) ? AbstractArchiveHandler.getRelation().get(extension) : null;
        return result;
    }
}

