/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.ClassCache;
import adams.core.StringCompare;
import adams.core.Utils;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClassLocator {
    public static final boolean VERBOSE = false;
    protected static Hashtable<String, Vector<String>> m_Cache;
    protected static ClassCache m_ClassCache;

    public static boolean isSubclass(String superclass, String otherclass) {
        try {
            return ClassLocator.isSubclass(Class.forName(superclass), Class.forName(otherclass));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isSubclass(Class superclass, Class otherclass) {
        boolean result = false;
        Class currentclass = otherclass;
        do {
            result = currentclass.equals(superclass);
            if (currentclass.equals(Object.class) || currentclass.getSuperclass() == null) break;
            if (result) continue;
            currentclass = currentclass.getSuperclass();
        } while (!result);
        return result;
    }

    public static boolean hasInterface(String intf, String cls) {
        try {
            return ClassLocator.hasInterface(Class.forName(intf), Class.forName(cls));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean hasInterface(Class intf, Class cls) {
        return intf.isAssignableFrom(cls);
    }

    public static Vector<String> find(String classname, String[] pkgnames) {
        Vector<String> result = new Vector();
        try {
            Class<?> cls = Class.forName(classname);
            result = ClassLocator.find(cls, pkgnames);
        }
        catch (Throwable t) {
            System.err.println("Failed to instantiate '" + classname + "'/" + Utils.arrayToString(pkgnames) + " (find):");
            t.printStackTrace();
        }
        return result;
    }

    public static Vector<String> find(Class cls, String[] pkgnames) {
        Vector<String> result = new Vector<String>();
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < pkgnames.length; ++i) {
            names.addAll(ClassLocator.findInPackage(cls, pkgnames[i]));
        }
        result.addAll(names);
        Collections.sort(result, new StringCompare());
        return result;
    }

    public static Vector<String> findInPackage(String classname, String pkgname) {
        Vector<String> result = new Vector();
        try {
            Class<?> cls = Class.forName(classname);
            result = ClassLocator.findInPackage(cls, pkgname);
        }
        catch (Throwable t) {
            System.err.println("Failed to instantiate '" + classname + "'/" + pkgname + " (findInPackage):");
            t.printStackTrace();
        }
        return result;
    }

    public static Vector<String> findInPackage(Class cls, String pkgname) {
        Vector<String> result = ClassLocator.getCache(cls, pkgname);
        if (result == null) {
            result = new Vector();
            if (m_ClassCache.getClassnames(pkgname) != null) {
                result.addAll(m_ClassCache.getClassnames(pkgname));
            }
            int i = 0;
            while (i < result.size()) {
                try {
                    if (result.get(i).indexOf(36) > -1) {
                        result.remove(i);
                        continue;
                    }
                    Class<?> clsNew = Class.forName(result.get(i));
                    if (Modifier.isAbstract(clsNew.getModifiers())) {
                        m_ClassCache.remove(result.get(i));
                        result.remove(i);
                        continue;
                    }
                    if (cls.isInterface() && !ClassLocator.hasInterface(cls, clsNew)) {
                        result.remove(i);
                        continue;
                    }
                    if (!cls.isInterface() && !ClassLocator.isSubclass(cls, clsNew)) {
                        result.remove(i);
                        continue;
                    }
                    ++i;
                }
                catch (Throwable t) {
                    System.err.println("Failed to instantiate '" + result.get(i) + "' (find):");
                    t.printStackTrace();
                }
            }
            Collections.sort(result, new StringCompare());
            ClassLocator.addCache(cls, pkgname, result);
        }
        return result;
    }

    public static Vector<String> findPackages() {
        ClassLocator.initCache();
        Vector<String> result = new Vector<String>();
        Enumeration<String> packages = m_ClassCache.packages();
        while (packages.hasMoreElements()) {
            result.add(packages.nextElement());
        }
        Collections.sort(result, new StringCompare());
        return result;
    }

    protected static void initCache() {
        if (m_Cache == null) {
            m_Cache = new Hashtable();
        }
        if (m_ClassCache == null) {
            m_ClassCache = new ClassCache();
        }
    }

    protected static void addCache(Class cls, String pkgname, Vector<String> classnames) {
        ClassLocator.initCache();
        m_Cache.put(cls.getName() + "-" + pkgname, classnames);
    }

    protected static Vector<String> getCache(Class cls, String pkgname) {
        ClassLocator.initCache();
        return m_Cache.get(cls.getName() + "-" + pkgname);
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("packages")) {
            Vector<String> list = ClassLocator.findPackages();
            for (int i = 0; i < list.size(); ++i) {
                System.out.println(list.get(i));
            }
        } else if (args.length == 2) {
            Vector<String> packages = new Vector<String>();
            StringTokenizer tok = new StringTokenizer(args[1], ",");
            while (tok.hasMoreTokens()) {
                packages.add(tok.nextToken());
            }
            Vector<String> list = ClassLocator.find(args[0], packages.toArray(new String[packages.size()]));
            System.out.println("Searching for '" + args[0] + "' in '" + args[1] + "':\n" + "  " + list.size() + " found.");
            for (int i = 0; i < list.size(); ++i) {
                System.out.println("  " + (i + 1) + ". " + list.get(i));
            }
        } else {
            System.out.println("\nUsage:");
            System.out.println(ClassLocator.class.getName() + " packages");
            System.out.println("\tlists all packages in the classpath");
            System.out.println(ClassLocator.class.getName() + " <classname> <packagename(s)>");
            System.out.println("\tlists classes derived from/implementing 'classname' that");
            System.out.println("\tcan be found in 'packagename(s)' (comma-separated list)");
            System.out.println();
            System.exit(1);
        }
    }
}

