/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.option.AbstractActorJavaCodeProducer;
import adams.env.Environment;
import adams.flow.core.AbstractActor;
import java.util.List;
import java.util.Vector;

public class ActorExecutionClassProducer
extends AbstractActorJavaCodeProducer {
    private static final long serialVersionUID = -4862444496437534455L;

    @Override
    public String globalInfo() {
        return "Generates a wrapper class for executing an actor.";
    }

    @Override
    public void setSimpleName(String value) {
        super.setSimpleName(value);
    }

    @Override
    public String getSimpleName() {
        return super.getSimpleName();
    }

    @Override
    public void setPackage(String value) {
        super.setPackage(value);
    }

    @Override
    public String getPackage() {
        return super.getPackage();
    }

    @Override
    protected String getIndentation() {
        return "    ";
    }

    @Override
    protected List<String> getRequiredImports() {
        Vector<String> result = new Vector<String>(super.getRequiredImports());
        result.add(AbstractActor.class.getName());
        return result;
    }

    @Override
    protected void addClassJavadoc() {
        this.m_OutputBuffer.append("/**\n");
        this.m_OutputBuffer.append(" * Wrapper class for executing an actor.\n");
        this.m_OutputBuffer.append(" *\n");
        this.m_OutputBuffer.append(" * @author " + System.getProperty("user.name") + "\n");
        this.m_OutputBuffer.append(" * @author " + this.getClass().getName() + " (code generator)" + "\n");
        this.m_OutputBuffer.append(" * @version $Revision$\n");
        this.m_OutputBuffer.append(" */\n");
    }

    protected void addPreExecuteMethod() {
        this.m_OutputBuffer.append("  /**\n");
        this.m_OutputBuffer.append("   * Hook method before the actor is executed.\n");
        this.m_OutputBuffer.append("   * <p/>\n");
        this.m_OutputBuffer.append("   * Default implementation does nothing.\n");
        this.m_OutputBuffer.append("   *\n");
        this.m_OutputBuffer.append("   * @param actor \t\tthe actor that will get executed.\n");
        this.m_OutputBuffer.append("   * @throws Exception \tif an error occurs.\n");
        this.m_OutputBuffer.append("   */\n");
        this.m_OutputBuffer.append("  protected void preExecute(AbstractActor actor) throws Exception {\n");
        this.m_OutputBuffer.append("  }\n");
        this.m_OutputBuffer.append("\n");
    }

    protected void addDoExecuteMethod() {
        this.m_OutputBuffer.append("  /**\n");
        this.m_OutputBuffer.append("   * Performs the actual execution of the actor.\n");
        this.m_OutputBuffer.append("   *\n");
        this.m_OutputBuffer.append("   * @param actor \t\tthe actor that will get executed.\n");
        this.m_OutputBuffer.append("   * @throws Exception \tif an error occurs.\n");
        this.m_OutputBuffer.append("   */\n");
        this.m_OutputBuffer.append("  protected void doExecute(AbstractActor actor) throws Exception {\n");
        this.m_OutputBuffer.append("    String result = actor.setUp();\n");
        this.m_OutputBuffer.append("    if (result != null)\n");
        this.m_OutputBuffer.append("      throw new Exception(\"Setting up of actor failed: \" + result);\n");
        this.m_OutputBuffer.append("    result = actor.execute();\n");
        this.m_OutputBuffer.append("    if (result != null)\n");
        this.m_OutputBuffer.append("      throw new Exception(\"Execution of actor failed: \" + result);\n");
        this.m_OutputBuffer.append("    actor.wrapUp();\n");
        this.m_OutputBuffer.append("    // the following call closes all graphical output (like dialogs and frames)\n");
        this.m_OutputBuffer.append("    // and frees up memory\n");
        this.m_OutputBuffer.append("    actor.cleanUp();\n");
        this.m_OutputBuffer.append("  }\n");
        this.m_OutputBuffer.append("\n");
    }

    protected void addPostExecuteMethod() {
        this.m_OutputBuffer.append("  /**\n");
        this.m_OutputBuffer.append("   * Hook method after the actor was executed.\n");
        this.m_OutputBuffer.append("   * <p/>\n");
        this.m_OutputBuffer.append("   * Default implementation does nothing.\n");
        this.m_OutputBuffer.append("   *\n");
        this.m_OutputBuffer.append("   * @param actor \t\tthe actor that got executed.\n");
        this.m_OutputBuffer.append("   * @throws Exception \tif an error occurs.\n");
        this.m_OutputBuffer.append("   */\n");
        this.m_OutputBuffer.append("  protected void postExecute(AbstractActor actor) throws Exception {\n");
        this.m_OutputBuffer.append("  }\n");
        this.m_OutputBuffer.append("\n");
    }

    @Override
    protected void addAdditionalMethods() {
        this.addPreExecuteMethod();
        this.addDoExecuteMethod();
        this.addPostExecuteMethod();
        this.m_OutputBuffer.append("  /**\n");
        this.m_OutputBuffer.append("   * Executes the actor.\n");
        this.m_OutputBuffer.append("   *\n");
        this.m_OutputBuffer.append("   * @throws Exception \tif an error occurs.\n");
        this.m_OutputBuffer.append("   */\n");
        this.m_OutputBuffer.append("  public void execute() throws Exception {\n");
        this.m_OutputBuffer.append("    AbstractActor actor = getActor();\n");
        this.m_OutputBuffer.append("    preExecute(actor);\n");
        this.m_OutputBuffer.append("    doExecute(actor);\n");
        this.m_OutputBuffer.append("    postExecute(actor);\n");
        this.m_OutputBuffer.append("  }\n");
        this.m_OutputBuffer.append("\n");
    }

    @Override
    protected void addMethodStart() {
        this.m_OutputBuffer.append("  /**\n");
        this.m_OutputBuffer.append("   * Used to create an instance of a specific actor.\n");
        this.m_OutputBuffer.append("   *\n");
        this.m_OutputBuffer.append("   * @return a suitably configured <code>AbstractActor</code> value\n");
        this.m_OutputBuffer.append("   * @throws Exception if set up fails\n");
        this.m_OutputBuffer.append("   */\n");
        this.m_OutputBuffer.append("  public AbstractActor getActor() throws Exception {\n");
        this.m_OutputBuffer.append("    AbstractArgumentOption    argOption;\n");
        this.m_OutputBuffer.append("    \n");
        this.m_OutputBuffer.append("    " + this.m_Input.getClass().getName() + " " + this.getOuterVariableName() + " = new " + this.m_Input.getClass().getName() + "();\n");
        this.m_OutputBuffer.append("    \n");
    }

    @Override
    protected void addMethodEnd() {
        if (this.m_OutputBuffer.charAt(this.m_OutputBuffer.length() - 1) != '\n') {
            this.m_OutputBuffer.append("    \n");
        }
        this.m_OutputBuffer.append("    return " + this.getOuterVariableName() + ";\n");
        this.m_OutputBuffer.append("  }\n");
    }

    @Override
    protected void addMainMethod() {
        this.m_OutputBuffer.append("\n");
        this.m_OutputBuffer.append("  /**\n");
        this.m_OutputBuffer.append("   * Executes the actor, when started from commandline.\n");
        this.m_OutputBuffer.append("   *\n");
        this.m_OutputBuffer.append("   * @param args ignored\n");
        this.m_OutputBuffer.append("   * @throws Exception if execution fails\n");
        this.m_OutputBuffer.append("   */\n");
        this.m_OutputBuffer.append("  public static void main(String[] args) throws Exception {\n");
        this.m_OutputBuffer.append("    Environment.setEnvironmentClass(" + Environment.getEnvironmentClass().getName() + ".class);\n");
        String inst = this.m_SimpleName.toLowerCase() + "Inst";
        this.m_OutputBuffer.append("    " + this.m_SimpleName + " " + inst + " = new " + this.m_SimpleName + "();\n");
        this.m_OutputBuffer.append("    " + inst + ".execute();\n");
        this.m_OutputBuffer.append("  }\n");
    }
}

