/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.base.BaseDate;
import adams.data.conversion.AbstractConversion;

public class BaseDateToString
extends AbstractConversion {
    private static final long serialVersionUID = 6744245717394758406L;
    protected BaseDate m_Start;
    protected BaseDate m_End;

    @Override
    public String globalInfo() {
        return "Turns a BaseDate format string into a String, evaluted using user-supplied start and end dates (ignored if future INF dates).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("start", "start", new BaseDate("-INF"));
        this.m_OptionManager.add("end", "end", new BaseDate("+INF"));
    }

    public void setStart(BaseDate value) {
        this.m_Start = value;
        this.reset();
    }

    public BaseDate getStart() {
        return this.m_Start;
    }

    public String startTipText() {
        return "The start date to use in the evaluation.";
    }

    public void setEnd(BaseDate value) {
        this.m_End = value;
        this.reset();
    }

    public BaseDate getEnd() {
        return this.m_End;
    }

    public String endTipText() {
        return "The end date to use in the evaluation.";
    }

    @Override
    public Class accepts() {
        return String.class;
    }

    @Override
    public Class generates() {
        return String.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        BaseDate result = new BaseDate((String)this.m_Input);
        if (!this.m_Start.isInfinity()) {
            result.setStart(this.m_Start.dateValue());
        }
        if (!this.m_End.isInfinity()) {
            result.setEnd(this.m_End.dateValue());
        }
        return result.stringValue();
    }
}

