/*
 * Decompiled with CFR 0.152.
 */
package adams.data.outlier;

import adams.data.container.DataContainer;
import adams.data.filter.AbstractFilter;
import adams.data.outlier.AbstractDatabaseConnectionOutlierDetector;
import adams.data.outlier.AbstractOutlierDetector;
import adams.data.outlier.PassThrough;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import java.util.Vector;

public class FilteredOutlierDetector<T extends DataContainer>
extends AbstractDatabaseConnectionOutlierDetector<T> {
    private static final long serialVersionUID = 6570555834680774914L;
    protected AbstractFilter m_Filter;
    protected AbstractOutlierDetector m_Detector;

    @Override
    public String globalInfo() {
        return "A meta detector that first filters the data through a filter before pushing it through the base detector.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Filter = new adams.data.filter.PassThrough();
        this.m_Detector = new PassThrough();
    }

    @Override
    public void reset() {
        super.reset();
        if (this.m_Filter != null) {
            this.m_Filter.reset();
        }
        if (this.m_Detector != null) {
            this.m_Detector.reset();
        }
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", new adams.data.filter.PassThrough());
        this.m_OptionManager.add("detector", "detector", new PassThrough());
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    public String filterTipText() {
        return "The filter to apply.";
    }

    public void setFilter(AbstractFilter value) {
        if (value != null) {
            this.m_Filter = value;
            this.updateDatabaseConnection();
            this.reset();
        } else {
            this.getSystemErr().println(this.getClass().getName() + ": filter cannot be null!");
        }
    }

    public AbstractFilter getFilter() {
        return this.m_Filter;
    }

    public String detectorTipText() {
        return "The detector to use.";
    }

    public void setDetector(AbstractOutlierDetector value) {
        if (value != null) {
            this.m_Detector = value;
            this.updateDatabaseConnection();
            this.reset();
        } else {
            this.getSystemErr().println(this.getClass().getName() + ": detector cannot be null!");
        }
    }

    public AbstractOutlierDetector getDetector() {
        return this.m_Detector;
    }

    @Override
    protected void updateDatabaseConnection() {
        if (this.m_Detector instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)((Object)this.m_Detector)).setDatabaseConnection(this.getDatabaseConnection());
        }
        if (this.m_Filter instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)((Object)this.m_Filter)).setDatabaseConnection(this.getDatabaseConnection());
        }
    }

    @Override
    protected Vector<String> processData(DataContainer data) {
        data = this.m_Filter.filter(data);
        this.m_Filter.cleanUp();
        Vector<String> detection = this.m_Detector.detect(data);
        this.m_Detector.cleanUp();
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < detection.size(); ++i) {
            result.add(new String(detection.get(i)));
        }
        return result;
    }
}

