/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.AppendName;
import adams.flow.transformer.BaseName;
import adams.flow.transformer.FileExtension;
import java.io.File;

public class DirName
extends AbstractTransformer
implements ClassCrossReference {
    private static final long serialVersionUID = 4670761846363281951L;

    @Override
    public String globalInfo() {
        return "Extracts the directory part of the file/directory passing through, i.e., any trailing name part gets stripped.";
    }

    @Override
    public Class[] getClassCrossReferences() {
        return new Class[]{AppendName.class, BaseName.class, FileExtension.class};
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    @Override
    protected String doExecute() {
        int i;
        String[] strings;
        File[] files;
        String result = null;
        boolean array = false;
        boolean string = false;
        if (this.m_InputToken.getPayload() instanceof File) {
            files = new File[]{new PlaceholderFile((File)this.m_InputToken.getPayload())};
        } else if (this.m_InputToken.getPayload() instanceof File[]) {
            files = (File[])this.m_InputToken.getPayload();
            array = true;
        } else if (this.m_InputToken.getPayload() instanceof String) {
            files = new File[]{new PlaceholderFile((String)this.m_InputToken.getPayload())};
            string = true;
        } else if (this.m_InputToken.getPayload() instanceof String[]) {
            strings = (String[])this.m_InputToken.getPayload();
            files = new File[strings.length];
            for (i = 0; i < strings.length; ++i) {
                files[i] = new PlaceholderFile(strings[i]);
            }
            array = true;
            string = true;
        } else {
            throw new IllegalStateException("Unhandled input type: " + this.m_InputToken.getPayload().getClass());
        }
        strings = new String[files.length];
        for (i = 0; i < files.length; ++i) {
            if (string) {
                strings[i] = files[i].getParent();
                continue;
            }
            files[i] = files[i].getParentFile();
        }
        this.m_OutputToken = string ? (array ? new Token(strings) : new Token(strings[0])) : (array ? new Token(files) : new Token(files[0]));
        return result;
    }
}

