/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.Utils;
import java.io.File;
import java.io.Serializable;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter
implements Comparable<ExtensionFileFilter>,
Serializable {
    private static final long serialVersionUID = -2053536869521888824L;
    public static final String EXT_ALL_FILES = "*";
    protected String m_Description;
    protected String[] m_Extensions;
    protected boolean m_CaseSensitive;

    public ExtensionFileFilter() {
        this("All files", EXT_ALL_FILES);
    }

    public ExtensionFileFilter(String description, String extension) {
        this(description, extension, false);
    }

    public ExtensionFileFilter(String description, String[] extensions) {
        this(description, extensions, false);
    }

    public ExtensionFileFilter(String description, String extension, boolean caseSensitive) {
        this(description, new String[]{extension}, caseSensitive);
    }

    public ExtensionFileFilter(String description, String[] extensions, boolean caseSensitive) {
        this.m_Description = description;
        this.m_CaseSensitive = caseSensitive;
        this.m_Extensions = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            this.m_Extensions[i] = extensions[i].replaceAll("^\\.", "");
        }
    }

    @Override
    public boolean accept(File f) {
        boolean result = false;
        if (f.isDirectory()) {
            result = true;
        }
        if (!result) {
            for (int i = 0; i < this.m_Extensions.length && !(result = this.m_Extensions[i].equals(EXT_ALL_FILES) ? true : (this.m_CaseSensitive ? f.getPath().endsWith("." + this.m_Extensions[i]) : f.getPath().toLowerCase().endsWith("." + this.m_Extensions[i].toLowerCase()))); ++i) {
            }
        }
        return result;
    }

    @Override
    public String getDescription() {
        String result = this.m_Description + " (";
        for (int i = 0; i < this.m_Extensions.length; ++i) {
            if (i > 0) {
                result = result + ", ";
            }
            result = result + "*." + this.m_Extensions[i];
        }
        result = result + ")";
        return result;
    }

    public String[] getExtensions() {
        return this.m_Extensions;
    }

    public boolean isCaseSensitive() {
        return this.m_CaseSensitive;
    }

    @Override
    public int compareTo(ExtensionFileFilter o) {
        int result = this.m_Description.compareTo(o.m_Description);
        if (result == 0) {
            result = new Integer(this.m_Extensions.length).compareTo(new Integer(o.m_Extensions.length));
        }
        if (result == 0) {
            for (int i = 0; i < this.m_Extensions.length && (result = this.m_Extensions[i].compareTo(o.m_Extensions[i])) == 0; ++i) {
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        return "desc=" + this.m_Description + ", ext=" + Utils.arrayToString(this.m_Extensions) + ", case=" + this.m_CaseSensitive;
    }

    public static ExtensionFileFilter getTextFileFilter() {
        return new ExtensionFileFilter("Text files", "txt");
    }

    public static ExtensionFileFilter getLogFileFilter() {
        return new ExtensionFileFilter("Log files", "log");
    }

    public static ExtensionFileFilter getPropertiesFileFilter() {
        return new ExtensionFileFilter("Properties files", new String[]{"props", "properties"});
    }

    public static ExtensionFileFilter getCsvFileFilter() {
        return new ExtensionFileFilter("Comma-separated values files", "csv");
    }

    public static ExtensionFileFilter getPdfFileFilter() {
        return new ExtensionFileFilter("PDF files", "pdf");
    }

    public static ExtensionFileFilter getZipFileFilter() {
        return new ExtensionFileFilter("ZIP files", "zip");
    }

    public static ExtensionFileFilter getArffFileFilter() {
        return new ExtensionFileFilter("ARFF files", "arff");
    }
}

