/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.clustree.util;

import moa.clusterers.clustree.util.Gamma;

public class AuxiliaryFunctions {
    public static final int GAMMA_ITERATIONS = 100;

    private AuxiliaryFunctions() {
    }

    public static void addIntegerArrays(int[] a1, int[] a2) {
        assert (a1.length == a2.length);
        for (int i = 0; i < a1.length; ++i) {
            int n = i;
            a1[n] = a1[n] + a2[i];
        }
    }

    public static void overwriteDoubleArray(double[] a1, double[] a2) {
        assert (a1.length == a2.length);
        for (int i = 0; i < a1.length; ++i) {
            a1[i] = a2[i];
        }
    }

    public static void overwriteIntegerArray(int[] a1, int[] a2) {
        assert (a1.length == a2.length);
        for (int i = 0; i < a1.length; ++i) {
            a1[i] = a2[i];
        }
    }

    public static double weight(double negLambda, long timeDifference) {
        assert (negLambda < 0.0);
        assert (timeDifference > 0L);
        return Math.pow(2.0, negLambda * (double)timeDifference);
    }

    public static void printArray(double[] a) {
        System.out.println(AuxiliaryFunctions.formatArray(a));
    }

    public static String formatArray(double[] a) {
        if (a.length == 0) {
            return "[]";
        }
        String res = "[";
        for (int i = 0; i < a.length - 1; ++i) {
            res = res + (double)Math.round(a[i] * 1000.0) / 1000.0 + ", ";
        }
        res = res + (double)Math.round(a[a.length - 1] * 1000.0) / 1000.0 + "]";
        return res;
    }

    public static void printArray(String[] a) {
        if (a.length == 0) {
            System.out.println("[]");
            return;
        }
        System.out.print("[");
        for (int i = 0; i < a.length - 1; ++i) {
            System.out.print(a[i] + ", ");
        }
        System.out.print(a[a.length - 1]);
        System.out.println("]");
    }

    private static double incompleteGamma(double a, double x) {
        assert (!Double.isNaN(a));
        assert (!Double.isNaN(x));
        double sum = 0.0;
        double xPow = 1.0;
        for (int n = 0; n < 100; ++n) {
            double denom = a;
            for (int i = 1; i <= n; ++i) {
                denom *= a + (double)i;
            }
            assert (denom != 0.0);
            sum += xPow / denom;
            xPow *= x;
        }
        double res = Math.pow(x, a) * Math.exp(-x) * sum;
        if (Double.isNaN(res)) {
            System.err.println("a " + a);
            System.err.println("x " + x);
            System.err.println("x^a " + Math.pow(x, a));
            System.err.println("e^-x " + Math.exp(-x));
            System.err.println("sum " + sum);
            assert (false);
        }
        return res;
    }

    public static double gammaHalf(int n) {
        int[] doubleFac = new int[]{1, 1, 2, 3, 8, 15, 48, 105, 384, 945, 3840, 10395, 46080, 135135, 645120, 0x1EEE11, 10321920, 34459425, 185794560, 654729075};
        if (n == 0) {
            return Double.POSITIVE_INFINITY;
        }
        if (n % 2 == 0) {
            int v = n / 2 - 1;
            int res = 1;
            for (int i = 1; i <= v; ++i) {
                res *= i;
            }
            return res;
        }
        if (n == 1) {
            return 1.772453850905513;
        }
        if (n == 3) {
            return 0.8862269254527603;
        }
        return Math.sqrt(Math.PI) * (double)doubleFac[n - 2] / Math.pow(2.0, (double)(n - 1) * 0.5);
    }

    public static double distanceProbabilty(double threshold, int dimension) {
        if (threshold == 0.0) {
            return 1.0;
        }
        return 1.0 - Gamma.incompleteGamma((double)dimension * 0.5, threshold * 0.5) / AuxiliaryFunctions.gammaHalf(dimension);
    }

    public static double gompertzWeight(double average, double count) {
        if (average < 2.0) {
            return 1.0;
        }
        double logT = Math.log(0.97);
        double logt = Math.log(1.0E-4);
        double denomB = Math.pow(logT * logT, 1.0 / (average - 2.0));
        double b = Math.pow(logt * logt, 1.0 / (2.0 * (1.0 - 2.0 / average))) / denomB;
        double c = -(1.0 / average) * Math.log(-(1.0 / b) * logT);
        assert (b >= 0.0) : "Bad b " + b + ", average " + average;
        assert (c >= 0.0) : "Bad c " + c + ", average " + average;
        return Math.exp(-b * Math.exp(-c * count));
    }

    public static void sortDoubleArray(double[] a) {
        for (int i = 1; i < a.length; ++i) {
            int j;
            double value = a[j];
            for (j = i; j > 0 && a[j - 1] > value; --j) {
                a[j] = a[j - 1];
            }
            a[j] = value;
        }
    }

    public static double inverseError(double x) {
        double z = Math.sqrt(Math.PI) * x;
        double res = z / 2.0;
        double z2 = z * z;
        double zProd = z * z2;
        res += 0.041666666666666664 * zProd;
        res += 0.007291666666666667 * (zProd *= z2);
        res += 127.0 * (zProd *= z2) / 80640.0;
        res += 4369.0 * (zProd *= z2) / 1.161216E7;
        res += 34807.0 * (zProd *= z2) / 3.649536E8;
        return res += 2.0036983E7 * (zProd *= z2) / 7.970586624E11;
    }
}

