/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import java.awt.Rectangle;

public class FloatPolygon {
    Rectangle bounds;
    public int npoints;
    public float[] xpoints;
    public float[] ypoints;

    public FloatPolygon() {
        this.npoints = 0;
        this.xpoints = new float[10];
        this.ypoints = new float[10];
    }

    public FloatPolygon(float[] xpoints, float[] ypoints, int npoints) {
        this.npoints = npoints;
        this.xpoints = xpoints;
        this.ypoints = ypoints;
    }

    public boolean contains(float x, float y) {
        boolean inside = false;
        int i = 0;
        int j = this.npoints - 1;
        while (i < this.npoints) {
            if (this.ypoints[i] > y != this.ypoints[j] > y && x < (this.xpoints[j] - this.xpoints[i]) * (y - this.ypoints[i]) / (this.ypoints[j] - this.ypoints[i]) + this.xpoints[i]) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    public Rectangle getBounds() {
        if (this.npoints == 0) {
            return new Rectangle();
        }
        if (this.bounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        return this.bounds.getBounds();
    }

    void calculateBounds(float[] xpoints, float[] ypoints, int npoints) {
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        for (int i = 0; i < npoints; ++i) {
            float x = xpoints[i];
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
            float y = ypoints[i];
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        int iMinX = (int)Math.floor(minX);
        int iMinY = (int)Math.floor(minY);
        this.bounds = new Rectangle(iMinX, iMinY, (int)((double)(maxX - (float)iMinX) + 0.5), (int)((double)(maxY - (float)iMinY) + 0.5));
    }

    public void addPoint(float x, float y) {
        if (this.npoints == this.xpoints.length) {
            float[] tmp = new float[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, tmp, 0, this.npoints);
            this.xpoints = tmp;
            tmp = new float[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, tmp, 0, this.npoints);
            this.ypoints = tmp;
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        ++this.npoints;
        this.bounds = null;
    }

    public void addPoint(double x, double y) {
        this.addPoint((float)x, (float)y);
    }
}

