/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics;

import JSci.physics.ClassicalParticle3D;
import JSci.physics.Force3D;

public class GravityField {
    private final ClassicalParticle3D source;

    public GravityField(ClassicalParticle3D classicalParticle3D) {
        this.source = classicalParticle3D;
    }

    public double energy(ClassicalParticle3D classicalParticle3D) {
        double d = classicalParticle3D.x - this.source.x;
        double d2 = classicalParticle3D.y - this.source.y;
        double d3 = classicalParticle3D.z - this.source.z;
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        return -6.67259E-11 * this.source.getMass() * classicalParticle3D.getMass() / d4;
    }

    public Force3D createForce(ClassicalParticle3D classicalParticle3D) {
        return new Force(classicalParticle3D);
    }

    private class Force
    extends Force3D {
        private final ClassicalParticle3D p;
        private double x;
        private double y;
        private double z;

        public Force(ClassicalParticle3D classicalParticle3D) {
            this.p = classicalParticle3D;
        }

        private void calculate() {
            double d = this.p.x - ((GravityField)GravityField.this).source.x;
            double d2 = this.p.y - ((GravityField)GravityField.this).source.y;
            double d3 = this.p.z - ((GravityField)GravityField.this).source.z;
            double d4 = d * d + d2 * d2 + d3 * d3;
            double d5 = Math.sqrt(d4);
            double d6 = -6.67259E-11 * GravityField.this.source.getMass() * this.p.getMass() / d4;
            this.x = d6 * d / d5;
            this.y = d6 * d2 / d5;
            this.z = d6 * d3 / d5;
        }

        public double getXComponent(double d) {
            this.calculate();
            return this.x;
        }

        public double getYComponent(double d) {
            this.calculate();
            return this.y;
        }

        public double getZComponent(double d) {
            this.calculate();
            return this.z;
        }
    }
}

